/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.resources;

import java.util.HashSet;
import java.util.Set;
import org.ametys.core.resources.AbstractSimpleResourceHandlerProvider;
import org.ametys.core.resources.ImageResourceHandler;
import org.ametys.core.resources.ResourceHandler;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.excalibur.source.SourceResolver;

public class ImageResourceHandlerProvider
extends AbstractSimpleResourceHandlerProvider {
    protected SourceResolver _resolver;
    protected Set<String> _supportedMimeTypes;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] mimeTypes;
        super.configure(configuration);
        this._supportedMimeTypes = new HashSet<String>();
        for (Configuration mimeType : mimeTypes = configuration.getChild("mimeTypes").getChildren("mimeType")) {
            this._supportedMimeTypes.add(StringUtils.lowerCase((String)mimeType.getValue()));
        }
    }

    @Override
    public ResourceHandler getResourceHandler(String location) throws Exception {
        ResourceHandler resourceHandler = super.getResourceHandler(location);
        if (resourceHandler != null) {
            return resourceHandler;
        }
        ImageResourceHandler.SizedSource sizedSource = ImageResourceHandler._resolveSource(location, this._resolver);
        if (sizedSource != null) {
            if (this._supportedMimeTypes.stream().anyMatch(mimeType -> Strings.CI.equals(sizedSource.source().getMimeType(), mimeType))) {
                return new ImageResourceHandler(sizedSource);
            }
            this._resolver.release(sizedSource.source());
        }
        return null;
    }

    @Override
    protected ResourceHandler createResourceHandler(String source) {
        return new ImageResourceHandler();
    }
}

