/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.resources;

import java.util.Objects;
import org.ametys.core.resources.DefaultResourceHandler;
import org.ametys.core.resources.ResourceHandler;
import org.ametys.core.resources.ResourceHandlerProvider;
import org.ametys.core.util.LambdaUtils;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentPrioritizableExtensionPoint;
import org.ametys.runtime.plugin.component.LogEnabled;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.LifecycleHelper;
import org.apache.cocoon.util.log.SLF4JLoggerAdapter;

public class ResourceHandlerProviderExtensionPoint
extends AbstractThreadSafeComponentPrioritizableExtensionPoint<ResourceHandlerProvider> {
    public static final String ROLE = ResourceHandlerProviderExtensionPoint.class.getName();

    @Override
    protected boolean sortPriorityAscending() {
        return false;
    }

    public ResourceHandler getResourceHandler(String source) throws Exception {
        return this.getExtensionsIds().stream().map(this::getExtension).map(LambdaUtils.wrap(provider -> provider.getResourceHandler(source))).filter(Objects::nonNull).findFirst().orElse(this._getDefaultResourceHandler());
    }

    private ResourceHandler _getDefaultResourceHandler() throws Exception {
        DefaultResourceHandler handler = new DefaultResourceHandler();
        LifecycleHelper.setupComponent((Object)handler, (Logger)new SLF4JLoggerAdapter(this.getLogger()), (Context)this._context, (ServiceManager)this._cocoonManager, null);
        if (handler instanceof LogEnabled) {
            ((LogEnabled)handler).setLogger(this.getLogger());
        }
        return handler;
    }
}

