/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.resources;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.ametys.core.cocoon.source.NamedSource;
import org.ametys.core.resources.ResourceHandler;
import org.ametys.core.resources.ResourceHandlerProviderExtensionPoint;
import org.ametys.core.util.URIUtils;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.LifecycleHelper;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.http.HttpResponse;
import org.apache.cocoon.reading.AbstractReader;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.SAXException;

public class ResourceReader
extends AbstractReader
implements CacheableProcessingComponent,
Serviceable,
Contextualizable {
    public static final String LAST_MODIFIED = "lastModified";
    private SourceResolver _resolver;
    private Context _cocoonContext;
    private ResourceHandlerProviderExtensionPoint _resourcesHandlerEP;
    private ResourceHandler _resourceHandler;
    private Source _source;
    private boolean _readForDownload;
    private boolean _processRange;
    private long _rangeStart;
    private long _rangeEnd;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._cocoonContext = (Context)context.get((Object)"environment-context");
    }

    public void service(ServiceManager sManager) throws ServiceException {
        this._resourcesHandlerEP = (ResourceHandlerProviderExtensionPoint)sManager.lookup(ResourceHandlerProviderExtensionPoint.ROLE);
        this._resolver = (SourceResolver)sManager.lookup(SourceResolver.ROLE);
    }

    public void setup(org.apache.cocoon.environment.SourceResolver res, Map objModel, String src, Parameters setupParameters) throws ProcessingException, SAXException, IOException {
        super.setup(res, objModel, src, setupParameters);
        try {
            this._resourceHandler = this._resourcesHandlerEP.getResourceHandler(src);
        }
        catch (Exception e) {
            throw new ProcessingException("Exception while retrieving resource handler for resource '" + src + "'", (Throwable)e);
        }
        this._readForDownload = setupParameters.getParameterAsBoolean("download", false);
        this._source = this._resourceHandler.setup(src, objModel, setupParameters, this._readForDownload);
        Map params = (Map)objModel.get("parent-context");
        if (params != null) {
            params.put(LAST_MODIFIED, this.getLastModified());
        }
        Response response = ObjectModelHelper.getResponse((Map)objModel);
        if (this._resourceHandler.acceptRanges()) {
            response.setHeader("Accept-Ranges", "bytes");
            Request request = ObjectModelHelper.getRequest((Map)objModel);
            String range = request.getHeader("Range");
            if (range != null) {
                try {
                    this._parseRange(range.trim());
                    this._processRange = this._rangeStart != 0L || this._rangeEnd != Long.MAX_VALUE;
                }
                catch (IllegalArgumentException e) {
                    ((HttpResponse)response).setStatus(416);
                    this.getLogger().error("Illegal range request: " + e.getMessage());
                }
            }
        } else {
            response.setHeader("Accept-Ranges", "none");
        }
        if (this._readForDownload) {
            String name = this._source instanceof NamedSource ? URIUtils.encodeHeader(((NamedSource)this._source).getName()) : null;
            response.setHeader("Content-Disposition", "attachment" + (String)(name != null ? ";filename=\"" + name + "\";filename*=UTF-8''" + name : ""));
        }
    }

    public void generate() throws IOException, ProcessingException {
        Response response = ObjectModelHelper.getResponse((Map)this.objectModel);
        long contentLength = this._resourceHandler.getLength();
        if (!this._processRange || contentLength == -1L) {
            if (contentLength != -1L) {
                response.setHeader("Content-Length", Long.toString(contentLength));
            }
            this._resourceHandler.generate(this.out);
        } else {
            ((HttpResponse)response).setStatus(206);
            long actualEnd = this._rangeEnd == Long.MAX_VALUE ? contentLength - 1L : this._rangeEnd;
            long length = actualEnd - this._rangeStart + 1L;
            response.setHeader("Content-Range", "bytes " + this._rangeStart + "-" + actualEnd + "/" + contentLength);
            response.setHeader("Content-Length", Long.toString(length));
            this._resourceHandler.generate(this.out, this._rangeStart, length);
        }
        this.out.flush();
    }

    public Serializable getKey() {
        if (this._processRange) {
            return null;
        }
        return this._resourceHandler.getKey();
    }

    public SourceValidity getValidity() {
        return this._resourceHandler.getValidity();
    }

    public void recycle() {
        super.recycle();
        this._resolver.release(this._source);
        LifecycleHelper.dispose((Object)this._resourceHandler);
        this._processRange = false;
        this._rangeStart = 0L;
        this._rangeEnd = 0L;
    }

    public String getMimeType() {
        String mimeType;
        String sourceMimeType = this._source.getMimeType();
        if (sourceMimeType != null) {
            return sourceMimeType;
        }
        if (this._cocoonContext != null && (mimeType = this._cocoonContext.getMimeType(this._source.getURI())) != null) {
            return mimeType;
        }
        return null;
    }

    public long getLastModified() {
        return this._resourceHandler.getLastModified();
    }

    private void _parseRange(String requestedRange) {
        if (!requestedRange.startsWith("bytes=")) {
            throw new IllegalArgumentException("Ranges are only accepted for bytes: " + requestedRange);
        }
        String range = requestedRange.substring("bytes=".length());
        if (range.contains(",")) {
            throw new IllegalArgumentException("Only single-values ranges are allowed: " + range);
        }
        int i = range.indexOf(45);
        if (i < 0) {
            throw new IllegalArgumentException("Wrong format for range: " + range);
        }
        if (i == 0) {
            throw new IllegalArgumentException("Suffix ranges not supported: " + range);
        }
        this._rangeStart = Long.parseLong(range.substring(0, i));
        int length = range.length();
        this._rangeEnd = i < length - 1 ? (long)Integer.parseInt(range.substring(i + 1, length)) : Long.MAX_VALUE;
        if (this._rangeStart > this._rangeEnd) {
            throw new IllegalArgumentException("Start value is greater than end value in range: " + range);
        }
    }
}

