/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.resources;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import org.ametys.core.resources.ResourceHandler;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.commons.io.IOUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;

public class SimpleResourceHandler
extends AbstractLogEnabled
implements ResourceHandler,
Serviceable {
    protected SourceResolver _resolver;
    protected Source _source;
    protected Parameters _parameters;
    protected Map _objectModel;
    protected boolean _readForDownload;
    protected String _requestedLocation;

    public SimpleResourceHandler() {
    }

    public SimpleResourceHandler(Source source) {
        this._source = source;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    @Override
    public Source setup(String location, Map objectModel, Parameters parameters, boolean readForDownload) throws IOException, ProcessingException {
        this._requestedLocation = location;
        this._objectModel = objectModel;
        this._parameters = parameters;
        this._readForDownload = readForDownload;
        if (this._source == null) {
            this._source = this._resolver.resolveURI(location);
            if (!this._source.exists()) {
                throw new ResourceNotFoundException("Resource not found for URI : " + this._source.getURI());
            }
        }
        return this._source;
    }

    @Override
    public void generate(OutputStream out) throws IOException, ProcessingException {
        try (InputStream is = this._source.getInputStream();){
            IOUtils.copy((InputStream)is, (OutputStream)out);
        }
    }

    @Override
    public Serializable getKey() {
        return this._source.getURI();
    }

    @Override
    public SourceValidity getValidity() {
        return this._source.getValidity();
    }

    @Override
    public long getLastModified() {
        return this._source.getLastModified();
    }

    @Override
    public String getMimeType() {
        return this._source.getMimeType();
    }
}

