/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.right;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.ametys.core.right.RightAssignmentContext;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractStaticRightAssignmentContext
extends StaticClientSideElement
implements RightAssignmentContext,
Contextualizable {
    protected boolean _isPrivate;
    protected Context _context;
    protected Pattern _workspaceMatcher;
    protected boolean _reverseWorkspaceMather;
    protected I18nizableText _label;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        Configuration labelConf = configuration.getChild("class").getChild("label");
        this._label = I18nizableText.getI18nizableTextValue(labelConf, "plugin." + this._pluginName, labelConf.getValue(this._id));
        String workspace = configuration.getChild("workspace").getValue();
        if (StringUtils.isNotBlank((CharSequence)workspace)) {
            if (workspace.startsWith("!")) {
                this._reverseWorkspaceMather = true;
                workspace = workspace.substring(1);
            }
            this._workspaceMatcher = Pattern.compile(workspace);
        }
        this._isPrivate = configuration.getChild("private").getValueAsBoolean(false);
    }

    @Override
    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        if (!this.matchWorkspace(contextParameters)) {
            return new ArrayList<ClientSideElement.Script>();
        }
        return super.getScripts(ignoreRights, contextParameters);
    }

    @Override
    public boolean isPrivate() {
        return this._isPrivate;
    }

    @Override
    public boolean matchWorkspace(Map<String, Object> contextParameters) {
        boolean match;
        String currentWorkspace = (String)contextParameters.get("workspaceName");
        return this._workspaceMatcher == null || (!(match = this._workspaceMatcher.matcher(currentWorkspace).matches()) || !this._reverseWorkspaceMather) && (match || this._reverseWorkspaceMather);
    }
}

