/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.right;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.AccessExplanation;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.UserIdentity;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.Supporter;
import org.apache.commons.lang3.StringUtils;

public interface AccessController
extends Supporter<Object> {
    public String getId();

    public AccessResult getPermission(UserIdentity var1, Set<GroupIdentity> var2, String var3, Object var4);

    public AccessResult getReadAccessPermission(UserIdentity var1, Set<GroupIdentity> var2, Object var3);

    public Map<String, AccessResult> getPermissionByRight(UserIdentity var1, Set<GroupIdentity> var2, Object var3);

    public AccessResult getPermissionForAnonymous(String var1, Object var2);

    public AccessResult getReadAccessPermissionForAnonymous(Object var1);

    public AccessResult getPermissionForAnyConnectedUser(String var1, Object var2);

    public AccessResult getReadAccessPermissionForAnyConnectedUser(Object var1);

    public Map<UserIdentity, AccessResult> getPermissionByUser(String var1, Object var2);

    public Map<UserIdentity, AccessResult> getReadAccessPermissionByUser(Object var1);

    public Map<GroupIdentity, AccessResult> getPermissionByGroup(String var1, Object var2);

    public Map<GroupIdentity, AccessResult> getReadAccessPermissionByGroup(Object var1);

    public boolean hasUserAnyPermissionOnWorkspace(Set<Object> var1, UserIdentity var2, Set<GroupIdentity> var3, String var4);

    public boolean hasUserAnyReadAccessPermissionOnWorkspace(Set<Object> var1, UserIdentity var2, Set<GroupIdentity> var3);

    public boolean hasAnonymousAnyPermissionOnWorkspace(Set<Object> var1, String var2);

    public boolean hasAnonymousAnyReadAccessPermissionOnWorkspace(Set<Object> var1);

    public boolean hasAnyConnectedUserAnyPermissionOnWorkspace(Set<Object> var1, String var2);

    public boolean hasAnyConnectedUserAnyReadAccessPermissionOnWorkspace(Set<Object> var1);

    default public AccessExplanation explainReadAccessPermissionForAnonymous(Object object) {
        return AccessController.getDefaultAccessExplanation(this.getId(), this.getReadAccessPermissionForAnonymous(object));
    }

    default public AccessExplanation explainPermissionForAnonymous(String rightId, Object object) {
        return AccessController.getDefaultAccessExplanation(this.getId(), this.getPermissionForAnonymous(rightId, object));
    }

    default public AccessExplanation explainReadAccessPermissionForAnyConnectedUser(Object object) {
        return AccessController.getDefaultAccessExplanation(this.getId(), this.getReadAccessPermissionForAnyConnectedUser(object));
    }

    default public AccessExplanation explainPermissionForAnyConnectedUser(String rightId, Object object) {
        return AccessController.getDefaultAccessExplanation(this.getId(), this.getPermissionForAnyConnectedUser(rightId, object));
    }

    default public AccessExplanation explainReadAccessPermission(UserIdentity user, Set<GroupIdentity> groups, Object object) {
        return AccessController.getDefaultAccessExplanation(this.getId(), this.getReadAccessPermission(user, groups, object));
    }

    default public AccessExplanation explainPermission(UserIdentity user, Set<GroupIdentity> groups, String rightId, Object object) {
        return AccessController.getDefaultAccessExplanation(this.getId(), this.getPermission(user, groups, rightId, object));
    }

    public static AccessExplanation getDefaultAccessExplanation(String controllerId, AccessResult result) {
        I18nizableText label = new I18nizableText("plugin.core", "PLUGINS_CORE_RIGHTS_EXPLAIN_TOOL_RESULT_" + result.name(), Map.of("controllerId", new I18nizableText(controllerId)));
        return new AccessExplanation(controllerId, result, label);
    }

    public Map<ExplanationObject, Map<Permission, AccessExplanation>> explainAllPermissions(UserIdentity var1, Set<GroupIdentity> var2, Set<Object> var3);

    default public ExplanationObject getExplanationObject(Object object) {
        return new ExplanationObject(object, this.getObjectLabel(object), this.getObjectCategory(object), this.getObjectPriority(object));
    }

    public I18nizableText getObjectLabel(Object var1);

    public I18nizableText getObjectCategory(Object var1);

    default public int getObjectPriority(Object object) {
        return 0;
    }

    public Map<Permission, AccessExplanation> explainAllPermissionsForAnonymous(Object var1);

    public Map<Permission, AccessExplanation> explainAllPermissionsForAnyConnected(Object var1);

    public Map<UserIdentity, Map<Permission, AccessExplanation>> explainAllPermissionsByUser(Object var1);

    public Map<GroupIdentity, Map<Permission, AccessExplanation>> explainAllPermissionsByGroup(Object var1);

    public static enum AccessResult {
        ANONYMOUS_ALLOWED,
        USER_DENIED,
        USER_ALLOWED,
        GROUP_DENIED,
        GROUP_ALLOWED,
        ANY_CONNECTED_DENIED,
        ANY_CONNECTED_ALLOWED,
        ANONYMOUS_DENIED,
        UNKNOWN;


        public RightManager.RightResult toRightResult() {
            switch (this.ordinal()) {
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    return RightManager.RightResult.RIGHT_DENY;
                }
                case 0: 
                case 2: 
                case 4: 
                case 6: {
                    return RightManager.RightResult.RIGHT_ALLOW;
                }
            }
            return RightManager.RightResult.RIGHT_UNKNOWN;
        }

        public static AccessResult merge(Collection<AccessResult> accessResults) {
            return accessResults.stream().filter(r -> r != null).min(Comparator.naturalOrder()).orElse(UNKNOWN);
        }

        public static AccessResult merge(AccessResult ... accessResults) {
            return Arrays.stream(accessResults).filter(r -> r != null).min(Comparator.naturalOrder()).orElse(UNKNOWN);
        }
    }

    public record ExplanationObject(Object object, I18nizableText label, I18nizableText category, int order) {
        public ExplanationObject(Object obj, I18nizableText lab, I18nizableText cat) {
            this(obj, lab, cat, 0);
        }

        @Override
        public final boolean equals(Object other) {
            if (other instanceof ExplanationObject) {
                ExplanationObject otherContext = (ExplanationObject)other;
                return this.object.equals(otherContext.object()) && (this.category == null && otherContext.category() == null || this.category != null && this.category.equals(otherContext.category()));
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return this.object.hashCode() + (this.category != null ? 23 * this.category.hashCode() : 0);
        }
    }

    public record Permission(PermissionType type, String id) {
        @Override
        public String toString() {
            if (StringUtils.isNotBlank((CharSequence)this.id)) {
                return this.type.name() + "#" + this.id;
            }
            return this.type.name();
        }

        public static enum PermissionType {
            READ,
            RIGHT,
            PROFILE,
            ALL_RIGHTS;

        }
    }
}

