/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.right;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.group.Group;
import org.ametys.core.right.AccessController;
import org.ametys.core.right.Profile;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;

public record AccessExplanation(String accessControllerId, AccessController.AccessResult accessResult, I18nizableText explanation) implements Comparable<AccessExplanation>
{
    public static I18nizableText profilesToI18nizableText(Set<Profile> profiles) {
        List<String> profileLabel = profiles.stream().map(Profile::getLabel).map(escapeHTML -> Strings.CS.replace(Strings.CS.replace(escapeHTML, "&", "&amp;"), "<", "&lt;")).sorted().collect(Collectors.toList());
        return AccessExplanation.elementsToI18nizableText(profileLabel);
    }

    public static I18nizableText groupsToI18nizableText(Set<Group> groups) {
        List<String> groupLabel = groups.stream().map(Group::getLabel).sorted().collect(Collectors.toList());
        return AccessExplanation.elementsToI18nizableText(groupLabel);
    }

    public static I18nizableText elementsToI18nizableText(List<String> elements) {
        if (elements.size() == 1) {
            return new I18nizableText(elements.get(0));
        }
        String elementsExceptLast = StringUtils.join(elements.subList(0, elements.size() - 1), (String)", ");
        String lastElement = elements.get(elements.size() - 1);
        return new I18nizableText("plugin.core", "PLUGINS_CORE_RIGHTS_EXPLAIN_TOOL_LIST_OF_ELEMENTS", Map.of("elementsExceptLast", new I18nizableText(elementsExceptLast), "lastElement", new I18nizableText(lastElement)));
    }

    @Override
    public int compareTo(AccessExplanation o) {
        int diff = this.accessResult().compareTo(o.accessResult());
        if (diff != 0) {
            return diff;
        }
        return o.accessControllerId().compareTo(o.accessControllerId());
    }
}

