/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.right;

import java.util.Map;
import java.util.Set;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.AccessController;
import org.ametys.core.ui.right.ProfileAssignmentsToolClientSideElement;
import org.ametys.core.user.UserIdentity;
import org.ametys.runtime.plugin.component.Prioritizable;
import org.ametys.runtime.plugin.component.Supporter;

public interface ProfileAssignmentStorage
extends Prioritizable,
Supporter<Object> {
    public static final int MIN_PRIORITY = Integer.MAX_VALUE;
    public static final int MAX_PRIORITY = 0;

    public Set<String> hasAnonymousAnyAllowedProfile(Set<? extends Object> var1, Set<String> var2);

    public Set<String> hasAnyConnectedAnyAllowedProfile(Set<? extends Object> var1, Set<String> var2);

    public Set<String> hasUserAnyAllowedProfile(Set<? extends Object> var1, UserIdentity var2, Set<String> var3);

    public Set<String> hasGroupAnyAllowedProfile(Set<? extends Object> var1, Set<GroupIdentity> var2, Set<String> var3);

    public Map<Object, Map<AnonymousOrAnyConnectedKeys, Set<String>>> getAllProfilesForAnonymousAndAnyConnectedUser(Set<? extends Object> var1);

    public Map<Object, Map<UserOrGroup, Set<String>>> getAllProfilesForUser(Set<? extends Object> var1, UserIdentity var2);

    public Map<Object, Map<GroupIdentity, Map<UserOrGroup, Set<String>>>> getAllProfilesForGroups(Set<? extends Object> var1, Set<GroupIdentity> var2);

    public Map<Object, Set<AnonymousOrAnyConnectedKeys>> getAllAssignmentsForAnonymousAndAnyConnectedUser(Set<? extends Object> var1, String var2);

    public Map<Object, Map<GroupIdentity, Set<UserOrGroup>>> getAllAssignmentsForGroups(Set<? extends Object> var1, String var2);

    public Map<Object, Map<UserIdentity, Set<UserOrGroup>>> getAllAssignmentsForUsers(Set<? extends Object> var1, String var2);

    public Map<AnonymousOrAnyConnectedKeys, Set<String>> getProfilesForAnonymousAndAnyConnectedUser(Object var1);

    public Map<UserIdentity, Map<UserOrGroup, Set<String>>> getProfilesForUsers(Object var1, UserIdentity var2);

    public Map<GroupIdentity, Map<UserOrGroup, Set<String>>> getProfilesForGroups(Object var1, Set<GroupIdentity> var2);

    public boolean isRootContextSupported(Object var1);

    public boolean isInheritanceDisallowed(Object var1);

    public static enum UserOrGroup {
        ALLOWED,
        DENIED;


        AccessController.AccessResult toAccessResult(ProfileAssignmentsToolClientSideElement.TargetType targetType) {
            if (ProfileAssignmentsToolClientSideElement.TargetType.USER == targetType) {
                if (ALLOWED == this) {
                    return AccessController.AccessResult.USER_ALLOWED;
                }
                return AccessController.AccessResult.USER_DENIED;
            }
            if (ProfileAssignmentsToolClientSideElement.TargetType.GROUP == targetType) {
                if (ALLOWED == this) {
                    return AccessController.AccessResult.GROUP_ALLOWED;
                }
                return AccessController.AccessResult.GROUP_DENIED;
            }
            return AccessController.AccessResult.UNKNOWN;
        }
    }

    public static enum AnonymousOrAnyConnectedKeys {
        ANONYMOUS_ALLOWED,
        ANONYMOUS_DENIED,
        ANYCONNECTEDUSER_ALLOWED,
        ANYCONNECTEDUSER_DENIED;


        AccessController.AccessResult toAccessResult() {
            switch (this.ordinal()) {
                case 0: {
                    return AccessController.AccessResult.ANONYMOUS_ALLOWED;
                }
                case 1: {
                    return AccessController.AccessResult.ANONYMOUS_DENIED;
                }
                case 2: {
                    return AccessController.AccessResult.ANY_CONNECTED_ALLOWED;
                }
                case 3: {
                    return AccessController.AccessResult.ANY_CONNECTED_DENIED;
                }
            }
            return AccessController.AccessResult.UNKNOWN;
        }
    }
}

