/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.right;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.AccessController;
import org.ametys.core.right.ModifiableProfileAssignmentStorage;
import org.ametys.core.right.ProfileAssignmentStorage;
import org.ametys.core.ui.right.ProfileAssignmentsToolClientSideElement;
import org.ametys.core.user.UserIdentity;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentPrioritizableSupporterExtensionPoint;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ProfileAssignmentStorageExtensionPoint
extends AbstractThreadSafeComponentPrioritizableSupporterExtensionPoint<ProfileAssignmentStorage, Object> {
    public static final String ROLE = ProfileAssignmentStorageExtensionPoint.class.getName();

    public Map<String, AccessController.AccessResult> getPermissions(UserIdentity user, Set<GroupIdentity> userGroups, Set<String> profileIds, Object object) {
        this.getLogger().debug("Try to determine permissions for user '{}' and groups {} on context {} for profiles [{}]", new Object[]{user, userGroups, object, profileIds});
        HashMap<String, AccessController.AccessResult> results = new HashMap<String, AccessController.AccessResult>();
        Map<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys, Set<String>> profilesForAnonymousAndAnyConnectedUser = this.getProfilesForAnonymousAndAnyConnectedUser(object);
        Optional.ofNullable(profilesForAnonymousAndAnyConnectedUser.get((Object)ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_ALLOWED)).orElse(Set.of()).stream().filter(profileIds::contains).forEach(p -> results.putIfAbsent((String)p, AccessController.AccessResult.ANONYMOUS_ALLOWED));
        if (results.size() == profileIds.size()) {
            this._logResult(user, userGroups, object, results);
            return results;
        }
        Map<UserIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> profilesForUsers = this.getProfilesForUsers(object, user);
        Optional.ofNullable(profilesForUsers.get(user)).map(a -> (Set)a.get((Object)ProfileAssignmentStorage.UserOrGroup.DENIED)).orElse(Set.of()).stream().filter(profileIds::contains).forEach(p -> results.putIfAbsent((String)p, AccessController.AccessResult.USER_DENIED));
        if (results.size() == profileIds.size()) {
            this._logResult(user, userGroups, object, results);
            return results;
        }
        Optional.ofNullable(profilesForUsers.get(user)).map(a -> (Set)a.get((Object)ProfileAssignmentStorage.UserOrGroup.ALLOWED)).orElse(Set.of()).stream().filter(profileIds::contains).forEach(p -> results.putIfAbsent((String)p, AccessController.AccessResult.USER_ALLOWED));
        if (results.size() == profileIds.size()) {
            this._logResult(user, userGroups, object, results);
            return results;
        }
        Map<GroupIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> profilesForGroups = this.getProfilesForGroups(object, userGroups);
        for (GroupIdentity userGroup : userGroups) {
            Optional.ofNullable(profilesForGroups.get(userGroup)).map(a -> (Set)a.get((Object)ProfileAssignmentStorage.UserOrGroup.DENIED)).orElse(Set.of()).stream().filter(profileIds::contains).forEach(p -> results.putIfAbsent((String)p, AccessController.AccessResult.GROUP_DENIED));
        }
        if (results.size() == profileIds.size()) {
            this._logResult(user, userGroups, object, results);
            return results;
        }
        for (GroupIdentity userGroup : userGroups) {
            Optional.ofNullable(profilesForGroups.get(userGroup)).map(a -> (Set)a.get((Object)ProfileAssignmentStorage.UserOrGroup.ALLOWED)).orElse(Set.of()).stream().filter(profileIds::contains).forEach(p -> results.putIfAbsent((String)p, AccessController.AccessResult.GROUP_ALLOWED));
        }
        if (results.size() == profileIds.size()) {
            this._logResult(user, userGroups, object, results);
            return results;
        }
        Optional.ofNullable(profilesForAnonymousAndAnyConnectedUser.get((Object)ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_DENIED)).orElse(Set.of()).stream().filter(profileIds::contains).forEach(p -> results.putIfAbsent((String)p, AccessController.AccessResult.ANY_CONNECTED_DENIED));
        if (results.size() == profileIds.size()) {
            this._logResult(user, userGroups, object, results);
            return results;
        }
        Optional.ofNullable(profilesForAnonymousAndAnyConnectedUser.get((Object)ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_ALLOWED)).orElse(Set.of()).stream().filter(profileIds::contains).forEach(p -> results.putIfAbsent((String)p, AccessController.AccessResult.ANY_CONNECTED_ALLOWED));
        if (results.size() == profileIds.size()) {
            this._logResult(user, userGroups, object, results);
            return results;
        }
        Optional.ofNullable(profilesForAnonymousAndAnyConnectedUser.get((Object)ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_DENIED)).orElse(Set.of()).stream().filter(profileIds::contains).forEach(p -> results.putIfAbsent((String)p, AccessController.AccessResult.ANONYMOUS_DENIED));
        if (results.size() == profileIds.size()) {
            this._logResult(user, userGroups, object, results);
            return results;
        }
        for (String profileId : profileIds) {
            results.putIfAbsent(profileId, AccessController.AccessResult.UNKNOWN);
        }
        this._logResult(user, userGroups, object, results);
        return results;
    }

    public Map<Object, Map<AccessResultInfo, Set<String>>> getAllPermissions(Set<? extends Object> rootContexts, UserIdentity user, Set<GroupIdentity> userGroups) {
        this.getLogger().debug("Try to determine all stored permissions for user '{}' and its groups {}", (Object)user, userGroups);
        List sortedPas = this.getExtensionsIds().stream().map(this::getExtension).collect(Collectors.toList());
        HashMap<Object, Map<AccessResultInfo, Set<String>>> userPermissions = new HashMap<Object, Map<AccessResultInfo, Set<String>>>();
        for (ProfileAssignmentStorage profileAssignmentStorage : sortedPas) {
            Map<Object, Map<AccessResultInfo, Set<String>>> pasStoredPermissions = this._getUserPermission(rootContexts, profileAssignmentStorage, user, userGroups);
            pasStoredPermissions.keySet().stream().forEach(context -> userPermissions.computeIfAbsent(context, k -> (Map)pasStoredPermissions.get(k)));
        }
        this.getLogger().debug("Found {} context with stored permissions for user '{}' and groups {} with profiles {}", new Object[]{userPermissions.keySet().size(), user, userGroups});
        return userPermissions;
    }

    private Map<Object, Map<AccessResultInfo, Set<String>>> _getUserPermission(Set<? extends Object> rootContexts, ProfileAssignmentStorage profileAssignmentStorage, UserIdentity user, Set<GroupIdentity> userGroups) {
        HashMap<Object, Map<AccessResultInfo, Set<String>>> result = new HashMap<Object, Map<AccessResultInfo, Set<String>>>();
        Map<Object, Map<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys, Set<String>>> anonymousProfiles = profileAssignmentStorage.getAllProfilesForAnonymousAndAnyConnectedUser(rootContexts);
        Map<Object, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> userProfiles = profileAssignmentStorage.getAllProfilesForUser(rootContexts, user);
        Map<Object, Map<GroupIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>>> groupsProfiles = profileAssignmentStorage.getAllProfilesForGroups(rootContexts, userGroups);
        Stream.of(anonymousProfiles.keySet().stream(), userProfiles.keySet().stream(), groupsProfiles.keySet().stream()).flatMap(i -> i).distinct().forEach(context -> {
            Map map;
            Map contextUserProfiles;
            HashMap<AccessResultInfo, Set> contextResult = new HashMap<AccessResultInfo, Set>();
            Map contextAnonymousProfiles = (Map)anonymousProfiles.get(context);
            if (contextAnonymousProfiles != null) {
                for (Map.Entry entry : contextAnonymousProfiles.entrySet()) {
                    AccessController.AccessResult accessResult = ((ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys)((Object)((Object)entry.getKey()))).toAccessResult();
                    AccessResultInfo resultInfo = new AccessResultInfo(accessResult, null);
                    contextResult.put(resultInfo, (Set)entry.getValue());
                }
            }
            if ((contextUserProfiles = (Map)userProfiles.get(context)) != null) {
                for (Map.Entry entry : contextUserProfiles.entrySet()) {
                    AccessController.AccessResult accessResult = ((ProfileAssignmentStorage.UserOrGroup)((Object)((Object)entry.getKey()))).toAccessResult(ProfileAssignmentsToolClientSideElement.TargetType.USER);
                    AccessResultInfo resultInfo = new AccessResultInfo(accessResult, user);
                    contextResult.put(resultInfo, (Set)entry.getValue());
                }
            }
            if ((map = (Map)groupsProfiles.get(context)) != null) {
                for (Map.Entry groupProfiles : map.entrySet()) {
                    for (Map.Entry profiles : ((Map)groupProfiles.getValue()).entrySet()) {
                        AccessController.AccessResult accessResult = ((ProfileAssignmentStorage.UserOrGroup)((Object)((Object)profiles.getKey()))).toAccessResult(ProfileAssignmentsToolClientSideElement.TargetType.GROUP);
                        AccessResultInfo resultInfo = new AccessResultInfo(accessResult, groupProfiles.getKey());
                        contextResult.put(resultInfo, (Set)profiles.getValue());
                    }
                }
            }
            result.put(context, contextResult);
        });
        return result;
    }

    private void _logResult(UserIdentity user, Set<GroupIdentity> userGroups, Object object, Map<String, AccessController.AccessResult> accessResultsByProfile) {
        this.getLogger().debug("Access result found for {} and groups {} on context '{}' are {}", new Object[]{user, userGroups, object, accessResultsByProfile});
    }

    public Map<Object, List<AccessResultInfo>> getAllProfileAssignments(String profileId, Set<? extends Object> rootContexts) {
        this.getLogger().debug("Trying to determine all profile assignments for profile '{}' on rootContexts '{}'", (Object)profileId, rootContexts);
        List sortedPas = this.getExtensionsIds().stream().map(this::getExtension).collect(Collectors.toList());
        HashMap<Object, List<AccessResultInfo>> assignments = new HashMap<Object, List<AccessResultInfo>>();
        HashSet<? extends Object> remainingRootsToTest = new HashSet<Object>(rootContexts);
        for (ProfileAssignmentStorage profileAssignmentStorage : sortedPas) {
            if (remainingRootsToTest.isEmpty()) continue;
            Set filteredContexts = remainingRootsToTest.stream().filter(profileAssignmentStorage::isRootContextSupported).collect(Collectors.toSet());
            if (filteredContexts.isEmpty()) continue;
            Map<Object, List<AccessResultInfo>> pasAssignments = this._getAllProfileAssignments(profileAssignmentStorage, filteredContexts, profileId);
            pasAssignments.entrySet().stream().forEach(e -> assignments.putIfAbsent(e.getKey(), (List)e.getValue()));
            remainingRootsToTest.removeAll(filteredContexts);
        }
        this.getLogger().debug("Found {} usage(s) for profile '{}' with root contexts '{}'", new Object[]{assignments.size(), profileId, rootContexts});
        return assignments;
    }

    private Map<Object, List<AccessResultInfo>> _getAllProfileAssignments(ProfileAssignmentStorage profileAssignmentStorage, Set<? extends Object> rootContexts, String profileId) {
        HashMap<Object, List<AccessResultInfo>> result = new HashMap<Object, List<AccessResultInfo>>();
        Map<Object, Set<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys>> anonymousAssignments = profileAssignmentStorage.getAllAssignmentsForAnonymousAndAnyConnectedUser(rootContexts, profileId);
        Map<Object, Map<GroupIdentity, Set<ProfileAssignmentStorage.UserOrGroup>>> allGroupsAssignments = profileAssignmentStorage.getAllAssignmentsForGroups(rootContexts, profileId);
        Map<Object, Map<UserIdentity, Set<ProfileAssignmentStorage.UserOrGroup>>> allUsersAssignments = profileAssignmentStorage.getAllAssignmentsForUsers(rootContexts, profileId);
        Stream.of(anonymousAssignments.keySet().stream(), allUsersAssignments.keySet().stream(), allGroupsAssignments.keySet().stream()).flatMap(i -> i).distinct().forEach(context -> {
            ArrayList<AccessResultInfo> contextAssignments = new ArrayList<AccessResultInfo>();
            Set contextAnonymousAssignments = anonymousAssignments.getOrDefault(context, Set.of());
            for (Object permission : contextAnonymousAssignments) {
                AccessController.AccessResult accessResult = ((ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys)((Object)((Object)permission))).toAccessResult();
                AccessResultInfo resultInfo = new AccessResultInfo(accessResult, null);
                contextAssignments.add(resultInfo);
            }
            Map contextUsersAssignments = allUsersAssignments.getOrDefault(context, Map.of());
            for (Map.Entry entry : contextUsersAssignments.entrySet()) {
                for (ProfileAssignmentStorage.UserOrGroup assignment : (Set)entry.getValue()) {
                    AccessController.AccessResult accessResult = assignment.toAccessResult(ProfileAssignmentsToolClientSideElement.TargetType.USER);
                    AccessResultInfo resultInfo = new AccessResultInfo(accessResult, entry.getKey());
                    contextAssignments.add(resultInfo);
                }
            }
            Map contextGroupsAssignments = allGroupsAssignments.getOrDefault(context, Map.of());
            for (Map.Entry groupAssignments : contextGroupsAssignments.entrySet()) {
                for (ProfileAssignmentStorage.UserOrGroup assignment : (Set)groupAssignments.getValue()) {
                    AccessController.AccessResult accessResult = assignment.toAccessResult(ProfileAssignmentsToolClientSideElement.TargetType.GROUP);
                    AccessResultInfo resultInfo = new AccessResultInfo(accessResult, groupAssignments.getKey());
                    contextAssignments.add(resultInfo);
                }
            }
            result.put(context, contextAssignments);
        });
        return result;
    }

    public Set<String> hasUserAnyPermission(Set<? extends Object> rootContexts, UserIdentity user, Set<GroupIdentity> userGroups, Set<String> profileIds) {
        this.getLogger().debug("Try to determine permissions on any context for user '{}' and groups {} with profiles {}", new Object[]{user, userGroups, profileIds});
        List sortedPas = this.getExtensionsIds().stream().map(this::getExtension).collect(Collectors.toList());
        HashSet<? extends Object> remainingRootsToTest = new HashSet<Object>(rootContexts);
        for (ProfileAssignmentStorage profileAssignmentStorage : sortedPas) {
            Set<String> hasUserAnyPermission;
            if (remainingRootsToTest.isEmpty()) continue;
            Set filteredContexts = remainingRootsToTest.stream().filter(profileAssignmentStorage::isRootContextSupported).collect(Collectors.toSet());
            if (!filteredContexts.isEmpty() && !(hasUserAnyPermission = this._hasUserAnyPermission(profileAssignmentStorage, filteredContexts, user, userGroups, profileIds)).isEmpty()) {
                this.getLogger().debug("Find permission on any context for user '{}' and groups {} with profiles {}", new Object[]{user, userGroups, profileIds});
                return hasUserAnyPermission;
            }
            remainingRootsToTest.removeAll(filteredContexts);
        }
        this.getLogger().debug("Find no permission on any context for user '{}' and groups {} with profiles {}", new Object[]{user, userGroups, profileIds});
        return Set.of();
    }

    private Set<String> _hasUserAnyPermission(ProfileAssignmentStorage profileAssignmentStorage, Set<? extends Object> rootContexts, UserIdentity user, Set<GroupIdentity> userGroups, Set<String> profileIds) {
        if (profileIds.isEmpty() || rootContexts.isEmpty()) {
            return Set.of();
        }
        Set<String> hasAnonymousAnyAllowedProfile = profileAssignmentStorage.hasAnonymousAnyAllowedProfile(rootContexts, profileIds);
        if (!hasAnonymousAnyAllowedProfile.isEmpty()) {
            return hasAnonymousAnyAllowedProfile;
        }
        Set<String> hasUserAnyAllowedProfile = profileAssignmentStorage.hasUserAnyAllowedProfile(rootContexts, user, profileIds);
        if (!hasUserAnyAllowedProfile.isEmpty()) {
            return hasUserAnyAllowedProfile;
        }
        Set<String> hasGroupAnyAllowedProfile = profileAssignmentStorage.hasGroupAnyAllowedProfile(rootContexts, userGroups, profileIds);
        if (!hasGroupAnyAllowedProfile.isEmpty()) {
            return hasGroupAnyAllowedProfile;
        }
        Set<String> hasAnyConnectedAnyAllowedProfile = profileAssignmentStorage.hasAnyConnectedAnyAllowedProfile(rootContexts, profileIds);
        if (!hasAnyConnectedAnyAllowedProfile.isEmpty()) {
            return hasAnyConnectedAnyAllowedProfile;
        }
        return Set.of();
    }

    public Set<String> hasAnonymousAnyPermission(Set<? extends Object> rootContexts, Set<String> profileIds) {
        this.getLogger().debug("Try to determine permissions on any context for anonymous with profiles {}", profileIds);
        List sortedPas = this.getExtensionsIds().stream().map(this::getExtension).collect(Collectors.toList());
        HashSet<? extends Object> remainingRootsToTest = new HashSet<Object>(rootContexts);
        for (ProfileAssignmentStorage profileAssignmentStorage : sortedPas) {
            Set<String> hasAnonymousAnyPermission;
            if (remainingRootsToTest.isEmpty()) continue;
            Set filteredContexts = remainingRootsToTest.stream().filter(profileAssignmentStorage::isRootContextSupported).collect(Collectors.toSet());
            if (!filteredContexts.isEmpty() && !(hasAnonymousAnyPermission = this._hasAnonymousAnyPermission(profileAssignmentStorage, filteredContexts, profileIds)).isEmpty()) {
                this.getLogger().debug("Find permission on any context for anonymous with profiles {}", profileIds);
                return hasAnonymousAnyPermission;
            }
            remainingRootsToTest.removeAll(filteredContexts);
        }
        this.getLogger().debug("Find no permission on any context for anonymous with profiles {}", profileIds);
        return Set.of();
    }

    private Set<String> _hasAnonymousAnyPermission(ProfileAssignmentStorage profileAssignmentStorage, Set<? extends Object> rootContexts, Set<String> profileIds) {
        if (profileIds.isEmpty() || rootContexts.isEmpty()) {
            return Set.of();
        }
        return profileAssignmentStorage.hasAnonymousAnyAllowedProfile(rootContexts, profileIds);
    }

    public Set<String> hasAnyConnectedUserAnyPermission(Set<? extends Object> rootContexts, Set<String> profileIds) {
        this.getLogger().debug("Try to determine permissions on any context for any connected user with profiles {}", profileIds);
        List sortedPas = this.getExtensionsIds().stream().map(this::getExtension).collect(Collectors.toList());
        HashSet<? extends Object> remainingRootsToTest = new HashSet<Object>(rootContexts);
        for (ProfileAssignmentStorage profileAssignmentStorage : sortedPas) {
            Set<String> hasAnyConnectedUserAnyPermission;
            if (remainingRootsToTest.isEmpty()) continue;
            Set filteredContexts = remainingRootsToTest.stream().filter(profileAssignmentStorage::isRootContextSupported).collect(Collectors.toSet());
            if (!filteredContexts.isEmpty() && !(hasAnyConnectedUserAnyPermission = this._hasAnyConnectedUserAnyPermission(profileAssignmentStorage, filteredContexts, profileIds)).isEmpty()) {
                this.getLogger().debug("Find permission on any context for any connected user with profiles {}", profileIds);
                return hasAnyConnectedUserAnyPermission;
            }
            remainingRootsToTest.removeAll(filteredContexts);
        }
        this.getLogger().debug("Find no permission on any context for any connected user with profiles {}", profileIds);
        return Set.of();
    }

    private Set<String> _hasAnyConnectedUserAnyPermission(ProfileAssignmentStorage profileAssignmentStorage, Set<? extends Object> rootContexts, Set<String> profileIds) {
        if (profileIds.isEmpty() || rootContexts.isEmpty()) {
            return Set.of();
        }
        Set<String> hasAnonymousAnyAllowedProfile = profileAssignmentStorage.hasAnonymousAnyAllowedProfile(rootContexts, profileIds);
        if (!hasAnonymousAnyAllowedProfile.isEmpty()) {
            return hasAnonymousAnyAllowedProfile;
        }
        Set<String> hasAnyConnectedAnyAllowedProfile = profileAssignmentStorage.hasAnyConnectedAnyAllowedProfile(rootContexts, profileIds);
        if (!hasAnyConnectedAnyAllowedProfile.isEmpty()) {
            return hasAnyConnectedAnyAllowedProfile;
        }
        return Set.of();
    }

    public Map<String, AccessController.AccessResult> getPermissionsByProfile(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        this.getLogger().debug("Try to determine permissions for each profile on context {} for user '{}' and groups {}", new Object[]{object, user, userGroups});
        HashMap<String, AccessController.AccessResult> result = new HashMap<String, AccessController.AccessResult>();
        Map<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys, Set<String>> profilesForAnonymousAndAnyConnectedUser = this.getProfilesForAnonymousAndAnyConnectedUser(object);
        Set anonymousAllowed = Optional.ofNullable(profilesForAnonymousAndAnyConnectedUser.get((Object)ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_ALLOWED)).orElse(Set.of());
        Set anonymousDenied = Optional.ofNullable(profilesForAnonymousAndAnyConnectedUser.get((Object)ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_DENIED)).orElse(Set.of());
        CollectionUtils.removeAll(anonymousAllowed, anonymousDenied).forEach(profile -> result.putIfAbsent((String)profile, AccessController.AccessResult.ANONYMOUS_ALLOWED));
        Map<UserIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> profilesForUsers = this.getProfilesForUsers(object, user);
        Optional.ofNullable(profilesForUsers.get(user)).map(a -> (Set)a.get((Object)ProfileAssignmentStorage.UserOrGroup.DENIED)).orElse(Set.of()).forEach(profile -> result.putIfAbsent((String)profile, AccessController.AccessResult.USER_DENIED));
        Optional.ofNullable(profilesForUsers.get(user)).map(a -> (Set)a.get((Object)ProfileAssignmentStorage.UserOrGroup.ALLOWED)).orElse(Set.of()).forEach(profile -> result.putIfAbsent((String)profile, AccessController.AccessResult.USER_ALLOWED));
        Map<GroupIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> profilesForGroups = this.getProfilesForGroups(object, userGroups);
        for (GroupIdentity userGroup : userGroups) {
            Optional.ofNullable(profilesForGroups.get(userGroup)).map(a -> (Set)a.get((Object)ProfileAssignmentStorage.UserOrGroup.DENIED)).orElse(Set.of()).forEach(profile -> result.putIfAbsent((String)profile, AccessController.AccessResult.GROUP_DENIED));
        }
        for (GroupIdentity userGroup : userGroups) {
            Optional.ofNullable(profilesForGroups.get(userGroup)).map(a -> (Set)a.get((Object)ProfileAssignmentStorage.UserOrGroup.ALLOWED)).orElse(Set.of()).forEach(profile -> result.putIfAbsent((String)profile, AccessController.AccessResult.GROUP_ALLOWED));
        }
        Optional.ofNullable(profilesForAnonymousAndAnyConnectedUser.get((Object)ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_DENIED)).orElse(Set.of()).forEach(profile -> result.putIfAbsent((String)profile, AccessController.AccessResult.ANY_CONNECTED_DENIED));
        Optional.ofNullable(profilesForAnonymousAndAnyConnectedUser.get((Object)ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_ALLOWED)).orElse(Set.of()).forEach(profile -> result.putIfAbsent((String)profile, AccessController.AccessResult.ANY_CONNECTED_ALLOWED));
        anonymousDenied.forEach(profile -> result.putIfAbsent((String)profile, AccessController.AccessResult.ANONYMOUS_DENIED));
        this.getLogger().debug("The permissions by profile on context {} for user '{}' and groups {} are : {}", new Object[]{object, user, userGroups, result});
        return result;
    }

    public AccessController.AccessResult getPermissionForAnonymous(Set<String> profileIds, Object object) {
        this.getLogger().debug("Try to determine permission for Anonymous on context {} and profiles {}", object, profileIds);
        Map<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys, Set<String>> profilesForAnonymousAndAnyConnectedUser = this.getProfilesForAnonymousAndAnyConnectedUser(object);
        Set deniedProfiles = Optional.ofNullable(profilesForAnonymousAndAnyConnectedUser.get((Object)ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_DENIED)).orElse(Set.of());
        Set allowedProfiles = Optional.ofNullable(profilesForAnonymousAndAnyConnectedUser.get((Object)ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_ALLOWED)).orElse(Set.of());
        AccessController.AccessResult result = AccessController.AccessResult.UNKNOWN;
        for (String profileId : profileIds) {
            if (deniedProfiles.contains(profileId)) {
                return AccessController.AccessResult.ANONYMOUS_DENIED;
            }
            if (!allowedProfiles.contains(profileId)) continue;
            result = AccessController.AccessResult.ANONYMOUS_ALLOWED;
        }
        return result;
    }

    public AccessController.AccessResult getPermissionForAnyConnectedUser(Set<String> profileIds, Object object) {
        this.getLogger().debug("Try to determine permission for AnyConnectedUser on context {} and profiles {}", object, profileIds);
        Map<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys, Set<String>> profilesForAnonymousAndAnyConnectedUser = this.getProfilesForAnonymousAndAnyConnectedUser(object);
        Set deniedProfiles = Optional.ofNullable(profilesForAnonymousAndAnyConnectedUser.get((Object)ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_DENIED)).orElse(Set.of());
        Set allowedProfiles = Optional.ofNullable(profilesForAnonymousAndAnyConnectedUser.get((Object)ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_ALLOWED)).orElse(Set.of());
        AccessController.AccessResult result = AccessController.AccessResult.UNKNOWN;
        for (String profileId : profileIds) {
            if (deniedProfiles.contains(profileId)) {
                return AccessController.AccessResult.ANY_CONNECTED_DENIED;
            }
            if (!allowedProfiles.contains(profileId)) continue;
            result = AccessController.AccessResult.ANY_CONNECTED_ALLOWED;
        }
        return result;
    }

    private AccessController.AccessResult _getPermissionsByUser(Map<ProfileAssignmentStorage.UserOrGroup, Set<String>> userProfiles, Set<String> profileIds) {
        if (userProfiles != null) {
            Set<String> deniedProfiles = userProfiles.get((Object)ProfileAssignmentStorage.UserOrGroup.DENIED);
            if (deniedProfiles != null && deniedProfiles.stream().anyMatch(p -> profileIds.contains(p))) {
                return AccessController.AccessResult.USER_DENIED;
            }
            Set<String> allowedProfiles = userProfiles.get((Object)ProfileAssignmentStorage.UserOrGroup.ALLOWED);
            if (allowedProfiles != null && allowedProfiles.stream().anyMatch(p -> profileIds.contains(p))) {
                return AccessController.AccessResult.USER_ALLOWED;
            }
        }
        return null;
    }

    public Map<UserIdentity, AccessController.AccessResult> getPermissionsByUser(Set<String> profileIds, Object object) {
        this.getLogger().debug("Try to determine permissions by users on context {} and profiles {}", object, profileIds);
        Map<UserIdentity, AccessController.AccessResult> result = this.getProfilesForUsers(object, null).entrySet().stream().map(entry -> Pair.of((Object)((UserIdentity)entry.getKey()), (Object)((Object)this._getPermissionsByUser((Map)entry.getValue(), profileIds)))).filter(pair -> pair.getRight() != null).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        this.getLogger().debug("The permissions by users on context {} and profiles {} are: {}", new Object[]{object, profileIds, result});
        return result;
    }

    private AccessController.AccessResult _getPermissionsByGroup(Map<ProfileAssignmentStorage.UserOrGroup, Set<String>> groupProfiles, Set<String> profileIds) {
        if (groupProfiles != null) {
            Set<String> deniedProfiles = groupProfiles.get((Object)ProfileAssignmentStorage.UserOrGroup.DENIED);
            if (deniedProfiles != null && deniedProfiles.stream().anyMatch(p -> profileIds.contains(p))) {
                return AccessController.AccessResult.GROUP_DENIED;
            }
            Set<String> allowedProfiles = groupProfiles.get((Object)ProfileAssignmentStorage.UserOrGroup.ALLOWED);
            if (allowedProfiles != null && allowedProfiles.stream().anyMatch(p -> profileIds.contains(p))) {
                return AccessController.AccessResult.GROUP_ALLOWED;
            }
        }
        return null;
    }

    public Map<GroupIdentity, AccessController.AccessResult> getPermissionsByGroup(Set<String> profileIds, Object object) {
        this.getLogger().debug("Try to determine permissions by groups on context {} and profiles {}", object, profileIds);
        Map<GroupIdentity, AccessController.AccessResult> result = this.getProfilesForGroups(object, null).entrySet().stream().map(entry -> Pair.of((Object)((GroupIdentity)entry.getKey()), (Object)((Object)this._getPermissionsByGroup((Map)entry.getValue(), profileIds)))).filter(pair -> pair.getRight() != null).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        this.getLogger().debug("The permissions by groups on context {} and profiles {} are: ", new Object[]{object, profileIds, result});
        return result;
    }

    public Map<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys, Set<String>> getProfilesForAnonymousAndAnyConnectedUser(Object context) {
        return this.getFirstSupportingExtension(context).map(pas -> pas.getProfilesForAnonymousAndAnyConnectedUser(context)).orElse(Map.of());
    }

    public Map<UserIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> getProfilesForUsers(Object context, UserIdentity user) {
        return this.getFirstSupportingExtension(context).map(pas -> pas.getProfilesForUsers(context, user)).orElse(Map.of());
    }

    public Map<GroupIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> getProfilesForGroups(Object context, Set<GroupIdentity> groups) {
        return this.getFirstSupportingExtension(context).map(pas -> pas.getProfilesForGroups(context, groups)).orElse(Map.of());
    }

    public void allowProfileToAnyConnectedUser(String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.addAllowedProfilesForAnyConnectedUser(context, Collections.singleton(profileId)));
    }

    public void denyProfileToAnyConnectedUser(String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.addDeniedProfilesForAnyConnectedUser(context, Collections.singleton(profileId)));
    }

    public void removeAllowedProfileFromAnyConnectedUser(String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.removeAllowedProfilesForAnyConnectedUser(context, Collections.singleton(profileId)));
    }

    public void removeDeniedProfileFromAnyConnectedUser(String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.removeDeniedProfilesForAnyConnectedUser(context, Collections.singleton(profileId)));
    }

    public void allowProfileToAnonymous(String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.addAllowedProfilesForAnonymous(context, Collections.singleton(profileId)));
    }

    public void denyProfileToAnonymous(String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.addDeniedProfilesForAnonymous(context, Collections.singleton(profileId)));
    }

    public void removeAllowedProfileFromAnonymous(String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.removeAllowedProfilesForAnonymous(context, Collections.singleton(profileId)));
    }

    public void removeDeniedProfileFromAnonymous(String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.removeDeniedProfilesForAnonymous(context, Collections.singleton(profileId)));
    }

    public void allowProfileToUser(UserIdentity user, String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.addAllowedUsers(Collections.singleton(user), context, profileId));
    }

    public void denyProfileToUser(UserIdentity user, String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.addDeniedUsers(Collections.singleton(user), context, profileId));
    }

    public void removeAllowedProfileFromUser(UserIdentity user, String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.removeAllowedUsers(Collections.singleton(user), context, profileId));
    }

    public void removeDeniedProfileFromUser(UserIdentity user, String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.removeDeniedUsers(Collections.singleton(user), context, profileId));
    }

    public void allowProfileToGroup(GroupIdentity group, String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.addAllowedGroups(Collections.singleton(group), context, profileId));
    }

    public void denyProfileToGroup(GroupIdentity group, String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.addDeniedGroups(Collections.singleton(group), context, profileId));
    }

    public void removeAllowedProfileFromGroup(GroupIdentity group, String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.removeAllowedGroups(Collections.singleton(group), context, profileId));
    }

    public void removeDeniedProfileFromGroup(GroupIdentity group, String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.removeDeniedGroups(Collections.singleton(group), context, profileId));
    }

    public boolean isInheritanceDisallowed(Object context) {
        return this.getFirstSupportingExtension(context).map(pas -> pas.isInheritanceDisallowed(context)).orElse(Boolean.FALSE);
    }

    public void disallowInheritance(Object context, boolean disallow) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.disallowInheritance(context, disallow));
    }

    private Optional<ModifiableProfileAssignmentStorage> _getFirstModifiableProfileAssignmentStorage(Object object) {
        return this.getSupportingExtensions(object).stream().filter(ModifiableProfileAssignmentStorage.class::isInstance).map(ModifiableProfileAssignmentStorage.class::cast).findFirst();
    }

    public record AccessResultInfo(AccessController.AccessResult accessResult, Object target) implements Comparable<AccessResultInfo>
    {
        @Override
        public int compareTo(AccessResultInfo o) {
            return this.accessResult.compareTo(o.accessResult());
        }
    }
}

