/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.right;

import java.util.Map;
import java.util.stream.Stream;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.core.right.ModifiableProfileAssignmentStorage;
import org.ametys.core.right.Profile;
import org.ametys.core.right.ProfileAssignmentStorageExtensionPoint;
import org.ametys.core.user.UserIdentity;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class ProfileAssignmentStorageObserver
implements Serviceable,
Observer {
    private ProfileAssignmentStorageExtensionPoint _profileAssignmentStorageEP;

    public void service(ServiceManager manager) throws ServiceException {
        this._profileAssignmentStorageEP = (ProfileAssignmentStorageExtensionPoint)manager.lookup(ProfileAssignmentStorageExtensionPoint.ROLE);
    }

    @Override
    public boolean supports(Event event) {
        return event.getId().equals("profile.deleted") || event.getId().equals("user.deleted") || event.getId().equals("group.deleted");
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        String id = event.getId();
        if (id.equals("profile.deleted")) {
            this._onProfileRemoved(event);
        } else if (id.equals("user.deleted")) {
            this._onUserRemoved(event);
        } else if (id.equals("group.deleted")) {
            this._onGroupRemoved(event);
        }
    }

    private void _onProfileRemoved(Event event) {
        Map<String, Object> arguments = event.getArguments();
        Profile profile = (Profile)arguments.get("profile");
        this._getModifiableProfileAssignmentStorages().forEach(pas -> pas.removeProfile(profile.getId()));
    }

    private void _onUserRemoved(Event event) {
        Map<String, Object> arguments = event.getArguments();
        UserIdentity user = (UserIdentity)arguments.get("user");
        this._getModifiableProfileAssignmentStorages().forEach(pas -> pas.removeUser(user));
    }

    private void _onGroupRemoved(Event event) {
        Map<String, Object> arguments = event.getArguments();
        GroupIdentity group = (GroupIdentity)arguments.get("group");
        this._getModifiableProfileAssignmentStorages().forEach(pas -> pas.removeGroup(group));
    }

    private Stream<ModifiableProfileAssignmentStorage> _getModifiableProfileAssignmentStorages() {
        return this._profileAssignmentStorageEP.getExtensionsIds().stream().map(this._profileAssignmentStorageEP::getExtension).filter(ModifiableProfileAssignmentStorage.class::isInstance).map(ModifiableProfileAssignmentStorage.class::cast);
    }
}

