/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.right;

import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.core.right.Profile;
import org.ametys.core.right.RightProfilesDAO;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class ProfilesEnumerator
implements Enumerator<String>,
Serviceable,
Component {
    public static final String ROLE = ProfilesEnumerator.class.getName();
    private RightProfilesDAO _rightProfilesDAO;
    private ServiceManager _manager;

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
    }

    private RightProfilesDAO getRightProfilesDAO() {
        if (this._rightProfilesDAO == null) {
            try {
                this._rightProfilesDAO = (RightProfilesDAO)this._manager.lookup(RightProfilesDAO.ROLE);
            }
            catch (ServiceException e) {
                return null;
            }
        }
        return this._rightProfilesDAO;
    }

    @Override
    public I18nizableText getEntry(String value) throws Exception {
        RightProfilesDAO rightProfilesDAO = this.getRightProfilesDAO();
        if (rightProfilesDAO != null) {
            return new I18nizableText(rightProfilesDAO.getProfile(value).getLabel());
        }
        return new I18nizableText(value);
    }

    @Override
    public Map<String, I18nizableText> getEntries() throws Exception {
        RightProfilesDAO rightProfilesDAO = this.getRightProfilesDAO();
        if (rightProfilesDAO != null) {
            return rightProfilesDAO.getProfiles().stream().collect(Collectors.toMap(Profile::getId, p -> new I18nizableText(p.getLabel())));
        }
        return Map.of();
    }
}

