/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.right;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.group.GroupDirectoryDAO;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.GroupManager;
import org.ametys.core.right.AccessController;
import org.ametys.core.right.AccessControllerExtensionPoint;
import org.ametys.core.right.AccessExplanation;
import org.ametys.core.right.AllowedUsers;
import org.ametys.core.right.Right;
import org.ametys.core.right.RightContextConvertorExtensionPoint;
import org.ametys.core.right.RightProfilesDAO;
import org.ametys.core.right.RightsException;
import org.ametys.core.right.RightsExtensionPoint;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.plugins.core.impl.cache.AbstractCacheKey;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class RightManager
extends AbstractLogEnabled
implements Serviceable,
Configurable,
ThreadSafe,
Component,
Contextualizable,
Initializable {
    public static final String ROLE = RightManager.class.getName();
    public static final String READER_PROFILE_ID = "READER";
    protected static final UserIdentity __ANONYMOUS_USER_IDENTITY = new UserIdentity(null, null);
    protected static final UserIdentity __ANY_CONNECTED_USER_IDENTITY = new UserIdentity("", "");
    private static final String CACHE_1 = RightManager.class.getName() + "$Cache-1";
    private static final String CACHE_2 = RightManager.class.getName() + "$Cache-2";
    protected ServiceManager _manager;
    protected SourceResolver _resolver;
    protected RightsExtensionPoint _rightsEP;
    protected RightContextConvertorExtensionPoint _rightContextConvertorEP;
    protected AccessControllerExtensionPoint _accessControllerEP;
    protected UserManager _userManager;
    protected GroupManager _groupManager;
    protected UserPopulationDAO _userPopulationDAO;
    protected GroupDirectoryDAO _groupDirectoryDAO;
    protected CurrentUserProvider _currentUserProvider;
    protected RightProfilesDAO _profilesDAO;
    protected AbstractCacheManager _cacheManager;
    private Context _context;
    private List<String> _webinfRights = new ArrayList<String>();

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._groupManager = (GroupManager)manager.lookup(GroupManager.ROLE);
        this._userPopulationDAO = (UserPopulationDAO)manager.lookup(UserPopulationDAO.ROLE);
        this._groupDirectoryDAO = (GroupDirectoryDAO)manager.lookup(GroupDirectoryDAO.ROLE);
        this._rightsEP = (RightsExtensionPoint)manager.lookup(RightsExtensionPoint.ROLE);
        this._rightContextConvertorEP = (RightContextConvertorExtensionPoint)manager.lookup(RightContextConvertorExtensionPoint.ROLE);
        this._accessControllerEP = (AccessControllerExtensionPoint)manager.lookup(AccessControllerExtensionPoint.ROLE);
        this._resolver = (SourceResolver)this._manager.lookup(SourceResolver.ROLE);
        this._currentUserProvider = (CurrentUserProvider)this._manager.lookup(CurrentUserProvider.ROLE);
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
    }

    public void initialize() throws Exception {
        this._cacheManager.createRequestCache(CACHE_1, new I18nizableText("plugin.core", "PLUGINS_CORE_RIGHT_MANAGER_CACHE_1_LABEL"), new I18nizableText("plugin.core", "PLUGINS_CORE_RIGHT_MANAGER_CACHE_1_DESCRIPTION"), true);
        this._cacheManager.createRequestCache(CACHE_2, new I18nizableText("plugin.core", "PLUGINS_CORE_RIGHT_MANAGER_CACHE_2_LABEL"), new I18nizableText("plugin.core", "PLUGINS_CORE_RIGHT_MANAGER_CACHE_2_DESCRIPTION"), true);
    }

    protected RightProfilesDAO _getProfileDAO() {
        try {
            if (this._profilesDAO == null) {
                this._profilesDAO = (RightProfilesDAO)this._manager.lookup(RightProfilesDAO.ROLE);
            }
            return this._profilesDAO;
        }
        catch (ServiceException e) {
            throw new RuntimeException("Failed to retrieve the DAO for profiles", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration rightsConfiguration = configuration.getChild("rights");
        String externalFile = rightsConfiguration.getAttribute("config", null);
        if (externalFile != null) {
            Source source = null;
            try {
                source = this._resolver.resolveURI("context://" + externalFile);
                if (source.exists()) {
                    Configuration externalConfiguration;
                    try (InputStream is = source.getInputStream();){
                        externalConfiguration = new DefaultConfigurationBuilder().build(is);
                    }
                    this.configureRights(externalConfiguration);
                    return;
                }
                if (!this.getLogger().isInfoEnabled()) return;
                this.getLogger().info("The optional external rights file '" + externalFile + "' is missing.");
                return;
            }
            catch (Exception e) {
                String message = "An error occured while retriving external file '" + externalFile + "'";
                this.getLogger().error(message, (Throwable)e);
                throw new ConfigurationException(message, configuration, (Throwable)e);
            }
            finally {
                if (source != null) {
                    this._resolver.release(source);
                }
            }
        }
        this.configureRights(rightsConfiguration);
    }

    private void configureRights(Configuration configuration) throws ConfigurationException {
        Configuration[] rights;
        for (Configuration rightConf : rights = configuration.getChildren("right")) {
            Right right = this._rightsEP.addRight("application", rightConf);
            this._webinfRights.add(right.getId());
        }
    }

    public List<String> getExternalRightIds() {
        return this._webinfRights;
    }

    public void addExternalRight(String id, String label, String description, String category) {
        this._rightsEP.addRight(id, new I18nizableText(label), new I18nizableText(description), new I18nizableText("application", category));
        this._webinfRights.add(id);
    }

    public void removeExternalRight(String id) {
        this._rightsEP.removeRight(id);
        this._webinfRights.remove(id);
    }

    public RightResult currentUserHasRight(String rightId, Object object) throws RightsException {
        return this.hasRight(this._currentUserProvider.getUser(), rightId, object);
    }

    public RightResult hasRight(UserIdentity userIdentity, String rightId, Object object) throws RightsException {
        UserIdentity objectUserIdentity = userIdentity == null ? __ANONYMOUS_USER_IDENTITY : userIdentity;
        return this._hasRight(objectUserIdentity, rightId, object);
    }

    public RightResult hasAnonymousRight(String rightId, Object object) {
        return this._hasRight(__ANONYMOUS_USER_IDENTITY, rightId, object);
    }

    public RightResult hasAnyConnectedUserRight(String rightId, Object object) {
        return this._hasRight(__ANY_CONNECTED_USER_IDENTITY, rightId, object);
    }

    private RightResult _hasRight(UserIdentity userIdentity, String rightId, Object object) {
        this.getLogger().debug("Try to determine if user {} has the right '{}' on the object context {}", new Object[]{userIdentity, rightId, object});
        if (StringUtils.isBlank((CharSequence)rightId)) {
            throw new RightsException("The rightId cannot be null");
        }
        return this._hasRightOrRead(userIdentity, rightId, object);
    }

    private RightResult _hasRightOrRead(UserIdentity userIdentity, String rightId, Object object) {
        if (object == null) {
            return this._hasRightOrRead(userIdentity, rightId);
        }
        RightResult cacheResult = this._hasRightResultInFirstCache(userIdentity, rightId, object);
        if (cacheResult != null) {
            return cacheResult;
        }
        Set<GroupIdentity> groups = this._getGroups(userIdentity);
        Set<Object> objects = this._rightContextConvertorEP.getConvertedObjects(object);
        Set<AccessController.AccessResult> accessResults = this._getAccessResults(userIdentity, groups, rightId, objects);
        AccessController.AccessResult access = AccessController.AccessResult.merge(accessResults);
        RightResult rightResult = access.toRightResult();
        this._putInFirstCache(userIdentity, rightId, object, rightResult);
        return rightResult;
    }

    private RightResult _hasRightOrRead(UserIdentity userIdentity, String rightId) {
        Set<Object> workspacesContexts = this._rightContextConvertorEP.getConvertedObjects("/${WorkspaceName}");
        RightResult cacheResult = this._hasRightResultInSecondCache(workspacesContexts, userIdentity, rightId);
        if (cacheResult != null) {
            return cacheResult;
        }
        Set<GroupIdentity> groups = this._getGroups(userIdentity);
        RightResult rightResult = RightResult.RIGHT_UNKNOWN;
        for (String controllerId : this._accessControllerEP.getExtensionsIds()) {
            AccessController accessController = (AccessController)this._accessControllerEP.getExtension(controllerId);
            try {
                if (userIdentity == __ANONYMOUS_USER_IDENTITY) {
                    if (!(rightId == null ? accessController.hasAnonymousAnyReadAccessPermissionOnWorkspace(workspacesContexts) : accessController.hasAnonymousAnyPermissionOnWorkspace(workspacesContexts, rightId))) continue;
                    rightResult = RightResult.RIGHT_ALLOW;
                    break;
                }
                if (userIdentity == __ANY_CONNECTED_USER_IDENTITY) {
                    if (!(rightId == null ? accessController.hasAnyConnectedUserAnyReadAccessPermissionOnWorkspace(workspacesContexts) : accessController.hasAnyConnectedUserAnyPermissionOnWorkspace(workspacesContexts, rightId))) continue;
                    rightResult = RightResult.RIGHT_ALLOW;
                    break;
                }
                if (!(rightId == null ? accessController.hasUserAnyReadAccessPermissionOnWorkspace(workspacesContexts, userIdentity, groups) : accessController.hasUserAnyPermissionOnWorkspace(workspacesContexts, userIdentity, groups, rightId))) continue;
                rightResult = RightResult.RIGHT_ALLOW;
                break;
            }
            catch (Exception e) {
                this.getLogger().error("An error occured with controller '{}'. Thus, this controller will be ignored.", (Object)controllerId, (Object)e);
            }
        }
        this.getLogger().debug("Right result found for [{}, {}, {}] => {}", new Object[]{workspacesContexts, userIdentity, rightId, rightResult});
        this._putInSecondCache(workspacesContexts, userIdentity, rightId, rightResult);
        return rightResult;
    }

    private Set<AccessController.AccessResult> _getAccessResults(UserIdentity userIdentity, Set<GroupIdentity> groups, String rightId, Set<Object> objects) {
        HashSet<AccessController.AccessResult> accessResults = new HashSet<AccessController.AccessResult>();
        for (Object obj : objects) {
            for (AccessController accessController : this._accessControllerEP.getSupportingExtensions(obj)) {
                try {
                    if (userIdentity == __ANONYMOUS_USER_IDENTITY) {
                        accessResults.add(rightId == null ? accessController.getReadAccessPermissionForAnonymous(obj) : accessController.getPermissionForAnonymous(rightId, obj));
                        continue;
                    }
                    if (userIdentity == __ANY_CONNECTED_USER_IDENTITY) {
                        accessResults.add(rightId == null ? accessController.getReadAccessPermissionForAnyConnectedUser(obj) : accessController.getPermissionForAnyConnectedUser(rightId, obj));
                        continue;
                    }
                    accessResults.add(rightId == null ? accessController.getReadAccessPermission(userIdentity, groups, obj) : accessController.getPermission(userIdentity, groups, rightId, obj));
                }
                catch (Exception e) {
                    this.getLogger().error("An error occured with controller '{}' for object {}. Thus, this controller will be ignored.", new Object[]{accessController.getId(), obj, e});
                }
            }
        }
        return accessResults;
    }

    public boolean currentUserHasReadAccess(Object object) {
        return this.hasReadAccess(this._currentUserProvider.getUser(), object);
    }

    public boolean hasReadAccess(UserIdentity userIdentity, Object object) {
        UserIdentity objectUserIdentity = userIdentity == null ? __ANONYMOUS_USER_IDENTITY : userIdentity;
        return this._hasRightOrRead(objectUserIdentity, null, object) == RightResult.RIGHT_ALLOW;
    }

    public boolean hasAnonymousReadAccess(Object object) {
        return this._hasRightOrRead(__ANONYMOUS_USER_IDENTITY, null, object) == RightResult.RIGHT_ALLOW;
    }

    public boolean hasAnyConnectedUserReadAccess(Object object) {
        return this._hasRightOrRead(__ANY_CONNECTED_USER_IDENTITY, null, object) == RightResult.RIGHT_ALLOW;
    }

    public AllowedUsers getAllowedUsers(String rightId, Object object) {
        if (StringUtils.isBlank((CharSequence)rightId)) {
            throw new RightsException("The rightId cannot be null");
        }
        return this._getAllowedUsers(rightId, object);
    }

    public AllowedUsers getReadAccessAllowedUsers(Object object) {
        return this._getAllowedUsers(null, object);
    }

    private AllowedUsers _getAllowedUsers(String rightId, Object object) {
        Optional.ofNullable(object).orElseThrow(() -> new RightsException("The object cannot be null"));
        Set<Object> objects = this._rightContextConvertorEP.getConvertedObjects(object);
        Boolean isAnyConnectedAllowed = null;
        HashSet<UserIdentity> allAllowedUsers = new HashSet<UserIdentity>();
        HashSet<UserIdentity> allDeniedUsers = new HashSet<UserIdentity>();
        HashSet<GroupIdentity> allAllowedGroups = new HashSet<GroupIdentity>();
        HashSet<GroupIdentity> allDeniedGroups = new HashSet<GroupIdentity>();
        for (Object obj : objects) {
            for (AccessController accessController : this._accessControllerEP.getSupportingExtensions(obj)) {
                try {
                    AccessController.AccessResult permissionForAnyConnectedUser;
                    if ((rightId == null ? accessController.getReadAccessPermissionForAnonymous(obj) : accessController.getPermissionForAnonymous(rightId, obj)) == AccessController.AccessResult.ANONYMOUS_ALLOWED) {
                        return new AllowedUsers(true, false, null, null, null, null, this._userManager, this._groupManager, null);
                    }
                    AccessController.AccessResult accessResult = permissionForAnyConnectedUser = rightId == null ? accessController.getReadAccessPermissionForAnyConnectedUser(obj) : accessController.getPermissionForAnyConnectedUser(rightId, obj);
                    if (permissionForAnyConnectedUser == AccessController.AccessResult.ANY_CONNECTED_DENIED) {
                        isAnyConnectedAllowed = Boolean.FALSE;
                    } else if (isAnyConnectedAllowed == null && permissionForAnyConnectedUser == AccessController.AccessResult.ANY_CONNECTED_ALLOWED) {
                        isAnyConnectedAllowed = Boolean.TRUE;
                    }
                    Map<UserIdentity, AccessController.AccessResult> permissionsByUser = rightId == null ? accessController.getReadAccessPermissionByUser(obj) : accessController.getPermissionByUser(rightId, obj);
                    Set allowedUsersOnObj = permissionsByUser.entrySet().stream().filter(entry -> AccessController.AccessResult.USER_ALLOWED.equals(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
                    allAllowedUsers.addAll(allowedUsersOnObj);
                    Set deniedUsersOnObj = permissionsByUser.entrySet().stream().filter(entry -> AccessController.AccessResult.USER_DENIED.equals(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
                    allDeniedUsers.addAll(deniedUsersOnObj);
                    Map<GroupIdentity, AccessController.AccessResult> permissionsByGroup = rightId == null ? accessController.getReadAccessPermissionByGroup(obj) : accessController.getPermissionByGroup(rightId, obj);
                    Set allowedGroupsOnObj = permissionsByGroup.entrySet().stream().filter(entry -> AccessController.AccessResult.GROUP_ALLOWED.equals(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
                    allAllowedGroups.addAll(allowedGroupsOnObj);
                    Set deniedGroupsOnObj = permissionsByGroup.entrySet().stream().filter(entry -> AccessController.AccessResult.GROUP_DENIED.equals(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
                    allDeniedGroups.addAll(deniedGroupsOnObj);
                }
                catch (Exception e) {
                    this.getLogger().error("An error occured with controller '{}' for object {}. Thus, this controller will be ignored.", new Object[]{accessController.getId(), obj, e});
                }
            }
        }
        Request request = ContextHelper.getRequest((Context)this._context);
        List populationContexts = (List)request.getAttribute("populationContexts");
        return new AllowedUsers(false, isAnyConnectedAllowed != null && isAnyConnectedAllowed != false, allAllowedUsers, allDeniedUsers, allAllowedGroups, allDeniedGroups, this._userManager, this._groupManager, populationContexts != null ? new HashSet<String>(populationContexts) : new HashSet());
    }

    public Set<String> getUserRights(UserIdentity userIdentity, Object object) throws RightsException {
        if (userIdentity == null) {
            throw new RightsException("The userIdentity cannot be null");
        }
        if (object == null) {
            throw new RightsException("The object cannot be null");
        }
        Set<Object> objects = this._rightContextConvertorEP.getConvertedObjects(object);
        Set<GroupIdentity> groups = this._groupManager.getUserGroups(userIdentity);
        Map<String, AccessController.AccessResult> accessResultsByRight = this._getAccessResultByRight(userIdentity, groups, objects);
        Set<String> allowedRights = accessResultsByRight.entrySet().stream().filter(entry -> ((AccessController.AccessResult)((Object)((Object)entry.getValue()))).toRightResult() == RightResult.RIGHT_ALLOW).map(entry -> (String)entry.getKey()).collect(Collectors.toSet());
        return allowedRights;
    }

    public void clearCaches() {
        Request request = ContextHelper.getRequest((Context)this._context);
        Enumeration attrNames = request.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            Cache cache;
            String attrName = (String)attrNames.nextElement();
            if (attrName == null || !attrName.startsWith(AbstractCacheManager.ROLE + "$" + ROLE + "$") || (cache = (Cache)request.getAttribute(attrName)) == null) continue;
            cache.invalidateAll();
        }
    }

    private Map<String, AccessController.AccessResult> _getAccessResultByRight(UserIdentity userIdentity, Set<GroupIdentity> groups, Set<Object> objects) {
        HashMap<String, AccessController.AccessResult> result = new HashMap<String, AccessController.AccessResult>();
        for (Object obj : objects) {
            for (AccessController accessController : this._accessControllerEP.getSupportingExtensions(obj)) {
                try {
                    Map<String, AccessController.AccessResult> permissionsByRight = accessController.getPermissionByRight(userIdentity, groups, obj);
                    for (String rightId : permissionsByRight.keySet()) {
                        result.put(rightId, AccessController.AccessResult.merge((AccessController.AccessResult)((Object)result.get(rightId)), permissionsByRight.get(rightId)));
                    }
                }
                catch (Exception e) {
                    this.getLogger().error("An error occured with controller '{}' for object {}. Thus, this controller will be ignored.", new Object[]{accessController.getId(), obj, e});
                }
            }
        }
        return result;
    }

    private Set<GroupIdentity> _getGroups(UserIdentity userIdentity) {
        if (userIdentity == __ANONYMOUS_USER_IDENTITY || userIdentity == __ANY_CONNECTED_USER_IDENTITY) {
            return Collections.EMPTY_SET;
        }
        Set<GroupIdentity> userGroups = this._groupManager.getUserGroups(userIdentity);
        return userGroups;
    }

    private RightResult _hasRightResultInFirstCache(UserIdentity userIdentity, String rightId, Object object) {
        Cache1Key key;
        Cache mapCache = this._cacheManager.get(CACHE_1);
        if (mapCache.hasKey(key = Cache1Key.of(userIdentity, rightId, object))) {
            RightResult cacheResult = (RightResult)((Object)mapCache.get(key));
            this.getLogger().debug("Find entry in cache for [{}, {}, {}] => {}", new Object[]{userIdentity, rightId, object, cacheResult});
            return cacheResult;
        }
        this.getLogger().debug("Did not find entry in cache for [{}, {}, {}]", new Object[]{userIdentity, rightId, object});
        return null;
    }

    private void _putInFirstCache(UserIdentity userIdentity, String rightId, Object object, RightResult rightResult) {
        Cache<Cache1Key, RightResult> mapCache = this._cacheManager.get(CACHE_1);
        if (mapCache != null) {
            mapCache.put(Cache1Key.of(userIdentity, rightId, object), rightResult);
        }
    }

    private RightResult _hasRightResultInSecondCache(Set<Object> workspacesContexts, UserIdentity userIdentity, String rightId) {
        Cache mapCache = this._cacheManager.get(CACHE_2);
        Cache2Key key = Cache2Key.of(userIdentity, rightId, workspacesContexts);
        if (mapCache != null && mapCache.hasKey(key)) {
            RightResult cacheResult = (RightResult)((Object)mapCache.get(key));
            this.getLogger().debug("Find entry in cache2 for [{}, {}, {}] => {}", new Object[]{workspacesContexts, userIdentity, rightId, cacheResult});
            return cacheResult;
        }
        this.getLogger().debug("Did not find entry in cache2 for [{}, {}, {}]", new Object[]{workspacesContexts, userIdentity, rightId});
        return null;
    }

    private void _putInSecondCache(Set<Object> workspacesContexts, UserIdentity userIdentity, String rightId, RightResult rightResult) {
        Cache<Cache2Key, RightResult> mapCache = this._cacheManager.get(CACHE_2);
        if (mapCache != null) {
            mapCache.put(Cache2Key.of(userIdentity, rightId, workspacesContexts), rightResult);
        }
    }

    public List<AccessExplanation> explain(UserIdentity userIdentity, String rightId, Object object) {
        UserIdentity objectUserIdentity;
        UserIdentity userIdentity2 = objectUserIdentity = userIdentity == null ? __ANONYMOUS_USER_IDENTITY : userIdentity;
        if (object == null) {
            throw new RightsException("The object cannot be null");
        }
        Set<GroupIdentity> groups = this._getGroups(objectUserIdentity);
        Set<Object> objects = this._rightContextConvertorEP.getConvertedObjects(object);
        return this._explainAccessResults(objectUserIdentity, groups, rightId, objects);
    }

    private List<AccessExplanation> _explainAccessResults(UserIdentity userIdentity, Set<GroupIdentity> groups, String rightId, Set<Object> objects) {
        ArrayList<AccessExplanation> accessExplanations = new ArrayList<AccessExplanation>();
        for (Object object : objects) {
            for (AccessController accessController : this._accessControllerEP.getSupportingExtensions(object)) {
                try {
                    AccessExplanation explanation = this._getAccessControllerExplanation(accessController, userIdentity, groups, rightId, object);
                    accessExplanations.add(explanation);
                }
                catch (Exception e) {
                    this.getLogger().error("An error occured with controller '{}' for object {}. Thus, this controller will be ignored.", new Object[]{accessController.getId(), object, e});
                }
            }
        }
        return accessExplanations;
    }

    public Map<AccessController.ExplanationObject, Map<AccessController.Permission, List<AccessExplanation>>> getAllPermissions(UserIdentity userIdentity) {
        Set<Object> workspacesContexts = this._rightContextConvertorEP.getConvertedObjects("/${WorkspaceName}");
        Set<GroupIdentity> groups = this._groupManager.getUserGroups(userIdentity);
        HashMap<AccessController.ExplanationObject, Map<AccessController.Permission, List<AccessExplanation>>> permissionsForUser = new HashMap<AccessController.ExplanationObject, Map<AccessController.Permission, List<AccessExplanation>>>();
        for (String controllerId : this._accessControllerEP.getExtensionsIds()) {
            AccessController accessController = (AccessController)this._accessControllerEP.getExtension(controllerId);
            try {
                Map<AccessController.ExplanationObject, Map<AccessController.Permission, AccessExplanation>> controllerPermissionsForUser = accessController.explainAllPermissions(userIdentity, groups, workspacesContexts);
                for (AccessController.ExplanationObject context : controllerPermissionsForUser.keySet()) {
                    Map contextExplanations = permissionsForUser.computeIfAbsent(context, o -> new HashMap());
                    Map<AccessController.Permission, AccessExplanation> contextPermissions = controllerPermissionsForUser.get(context);
                    for (AccessController.Permission permission : contextPermissions.keySet()) {
                        List rightExplanation = contextExplanations.computeIfAbsent(permission, str -> new ArrayList());
                        rightExplanation.add(contextPermissions.get(permission));
                    }
                }
            }
            catch (Exception e) {
                this.getLogger().error("An error occured while retrieving the permission for the controller '" + controllerId + "'. The controller will be ignored.", (Throwable)e);
            }
        }
        return permissionsForUser;
    }

    private AccessExplanation _getAccessControllerExplanation(AccessController accessController, UserIdentity userIdentity, Set<GroupIdentity> groups, String rightId, Object object) {
        AccessExplanation explanation;
        try {
            explanation = userIdentity == __ANONYMOUS_USER_IDENTITY ? (rightId == null ? accessController.explainReadAccessPermissionForAnonymous(object) : accessController.explainPermissionForAnonymous(rightId, object)) : (userIdentity == __ANY_CONNECTED_USER_IDENTITY ? (rightId == null ? accessController.explainReadAccessPermissionForAnyConnectedUser(object) : accessController.explainPermissionForAnyConnectedUser(rightId, object)) : (rightId == null ? accessController.explainReadAccessPermission(userIdentity, groups, object) : accessController.explainPermission(userIdentity, groups, rightId, object)));
        }
        catch (Exception e) {
            AccessController.AccessResult result = userIdentity == __ANONYMOUS_USER_IDENTITY ? (rightId == null ? accessController.getReadAccessPermissionForAnonymous(object) : accessController.getPermissionForAnonymous(rightId, object)) : (userIdentity == __ANY_CONNECTED_USER_IDENTITY ? (rightId == null ? accessController.getReadAccessPermissionForAnyConnectedUser(object) : accessController.getPermissionForAnyConnectedUser(rightId, object)) : (rightId == null ? accessController.getReadAccessPermission(userIdentity, groups, object) : accessController.getPermission(userIdentity, groups, rightId, object)));
            explanation = AccessController.getDefaultAccessExplanation(accessController.getId(), result);
            this.getLogger().warn("An error occured while explaining access with controller '{}' for object {}. A generic explanation was returned.", new Object[]{accessController.getId(), object, e});
        }
        return explanation;
    }

    public ContextPermissions explainAllPermissions(Object object) {
        HashMap<AccessController.Permission, List<AccessExplanation>> permissionsForAnonymous = new HashMap<AccessController.Permission, List<AccessExplanation>>();
        HashMap<AccessController.Permission, List<AccessExplanation>> permissionsForAnyConnected = new HashMap<AccessController.Permission, List<AccessExplanation>>();
        HashMap<UserIdentity, Map<AccessController.Permission, List<AccessExplanation>>> permissionsByUser = new HashMap<UserIdentity, Map<AccessController.Permission, List<AccessExplanation>>>();
        HashMap<GroupIdentity, Map<AccessController.Permission, List<AccessExplanation>>> permissionsByGroup = new HashMap<GroupIdentity, Map<AccessController.Permission, List<AccessExplanation>>>();
        Set<Object> objects = this._rightContextConvertorEP.getConvertedObjects(object);
        for (Object objectToCheck : objects) {
            for (String controllerId : this._accessControllerEP.getExtensionsIds()) {
                AccessController accessController = (AccessController)this._accessControllerEP.getExtension(controllerId);
                try {
                    Object permission32;
                    if (!accessController.supports(objectToCheck)) continue;
                    Map<AccessController.Permission, AccessExplanation> controllerPermissionsForAnonymous = accessController.explainAllPermissionsForAnonymous(objectToCheck);
                    for (AccessController.Permission permission : controllerPermissionsForAnonymous.keySet()) {
                        List rightExplanation = permissionsForAnonymous.computeIfAbsent(permission, str -> new ArrayList());
                        rightExplanation.add(controllerPermissionsForAnonymous.get(permission));
                    }
                    Map<AccessController.Permission, AccessExplanation> controllerPermissionsForAnyConnected = accessController.explainAllPermissionsForAnyConnected(objectToCheck);
                    for (Object permission32 : controllerPermissionsForAnyConnected.keySet()) {
                        List rightExplanation = permissionsForAnyConnected.computeIfAbsent((AccessController.Permission)permission32, str -> new ArrayList());
                        rightExplanation.add(controllerPermissionsForAnyConnected.get(permission32));
                    }
                    Map<UserIdentity, Map<AccessController.Permission, AccessExplanation>> map = accessController.explainAllPermissionsByUser(objectToCheck);
                    permission32 = map.keySet().iterator();
                    while (permission32.hasNext()) {
                        UserIdentity user = (UserIdentity)permission32.next();
                        Map permissionsForUser = permissionsByUser.computeIfAbsent(user, u -> new HashMap());
                        Map<AccessController.Permission, AccessExplanation> controllerPermissionsForUser = map.get(user);
                        for (AccessController.Permission permission4 : controllerPermissionsForUser.keySet()) {
                            List rightExplanation = permissionsForUser.computeIfAbsent(permission4, str -> new ArrayList());
                            rightExplanation.add(controllerPermissionsForUser.get(permission4));
                        }
                    }
                    Map<GroupIdentity, Map<AccessController.Permission, AccessExplanation>> controllerPermissionsByGroup = accessController.explainAllPermissionsByGroup(objectToCheck);
                    for (GroupIdentity group : controllerPermissionsByGroup.keySet()) {
                        Map permissionsForUser = permissionsByGroup.computeIfAbsent(group, u -> new HashMap());
                        Map<AccessController.Permission, AccessExplanation> controllerPermissionsForGroup = controllerPermissionsByGroup.get(group);
                        for (AccessController.Permission permission5 : controllerPermissionsForGroup.keySet()) {
                            List rightExplanation = permissionsForUser.computeIfAbsent(permission5, str -> new ArrayList());
                            rightExplanation.add(controllerPermissionsForGroup.get(permission5));
                        }
                    }
                }
                catch (Exception e) {
                    this.getLogger().error("An error occured with controller '{}' while explaining permission for '{}'. Thus, this controller will be ignored.", new Object[]{controllerId, objectToCheck.toString(), e});
                }
            }
        }
        return new ContextPermissions(permissionsForAnonymous, permissionsForAnyConnected, permissionsByUser, permissionsByGroup);
    }

    public static enum RightResult {
        RIGHT_ALLOW,
        RIGHT_DENY,
        RIGHT_UNKNOWN;

    }

    static class Cache1Key
    extends AbstractCacheKey {
        Cache1Key(UserIdentity userIdentity, String rightId, Object object) {
            super(userIdentity, rightId, object);
        }

        static Cache1Key of(UserIdentity userIdentity, String rightId, Object object) {
            return new Cache1Key(userIdentity, StringUtils.defaultString((String)rightId), object);
        }
    }

    static class Cache2Key
    extends AbstractCacheKey {
        Cache2Key(UserIdentity userIdentity, String rightId, Set<Object> workspacesContexts) {
            super(userIdentity, rightId, workspacesContexts);
        }

        static Cache2Key of(UserIdentity userIdentity, String rightId, Set<Object> workspacesContexts) {
            return new Cache2Key(userIdentity, StringUtils.defaultString((String)rightId), workspacesContexts);
        }
    }

    public record ContextPermissions(Map<AccessController.Permission, List<AccessExplanation>> permissionsForAnonymous, Map<AccessController.Permission, List<AccessExplanation>> permissionsForAnyConnected, Map<UserIdentity, Map<AccessController.Permission, List<AccessExplanation>>> permissionsByUser, Map<GroupIdentity, Map<AccessController.Permission, List<AccessExplanation>>> permissionsByGroup) {
    }
}

