/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.right;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.datasource.AbstractMyBatisDAO;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.right.Profile;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.ibatis.session.SqlSession;

public class RightProfilesDAO
extends AbstractMyBatisDAO
implements Initializable {
    public static final String ROLE = RightProfilesDAO.class.getName();
    private static final String PROFILES_CACHE = ROLE + "$profiles";
    private static final String PROFILE_RIGHTS_CACHE = ROLE + "$profileRigths";
    private ServiceManager _smanager;
    private ObservationManager _observationManager;
    private CurrentUserProvider _currentUserProvider;
    private AbstractCacheManager _cacheManager;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        this._smanager = smanager;
        super.service(smanager);
        this._cacheManager = (AbstractCacheManager)smanager.lookup(AbstractCacheManager.ROLE);
    }

    public void initialize() throws Exception {
        this._cacheManager.createMemoryCache(PROFILES_CACHE, new I18nizableText("plugin.core", "PLUGINS_CORE_RIGHT_PROFILES_CACHE_LABEL"), new I18nizableText("plugin.core", "PLUGINS_CORE_RIGHT_PROFILES_CACHE_DESCRIPTION"), true, null);
        this._cacheManager.createMemoryCache(PROFILE_RIGHTS_CACHE, new I18nizableText("plugin.core", "PLUGINS_CORE_RIGHT_PROFILE_RIGHTS_CACHE_LABEL"), new I18nizableText("plugin.core", "PLUGINS_CORE_RIGHT_PROFILE_RIGHTS_CACHE_DESCRIPTION"), true, null);
    }

    public synchronized void clearCache() {
        this._getProfilesCache().invalidateAll();
        this._getProfileRightsCache().invalidateAll();
    }

    private synchronized Cache<String, Profile> _getProfilesCache() {
        Cache<String, Profile> cache = this._cacheManager.get(PROFILES_CACHE);
        if (!cache.isInitialized()) {
            try (SqlSession session = this.getSession();){
                Map<Object, Object> profilesMap = new HashMap();
                List profiles = session.selectList("Profiles.getProfiles");
                profilesMap = profiles.stream().collect(Collectors.toMap(Profile::getId, p -> p));
                cache.putAll(profilesMap);
            }
        }
        return cache;
    }

    private synchronized Cache<String, List<String>> _getProfileRightsCache() {
        Cache<String, List<String>> cache = this._cacheManager.get(PROFILE_RIGHTS_CACHE);
        if (!cache.isInitialized()) {
            try (SqlSession session = this.getSession();){
                Map<Object, Object> profileRightsMap = new HashMap();
                List rightAssociations = session.selectList("Profiles.getProfileRights");
                profileRightsMap = rightAssociations.stream().collect(Collectors.groupingBy(rightAssociation -> (String)rightAssociation.get("profileId"), Collectors.mapping(rightAssociation -> (String)rightAssociation.get("rightId"), Collectors.toList())));
                cache.putAll(profileRightsMap);
            }
        }
        return cache;
    }

    public List<Profile> getProfiles() {
        Collection<Profile> profiles = this._getProfilesCache().asMap().values();
        return new ArrayList<Profile>(profiles);
    }

    public List<Profile> getProfiles(String context) {
        return this._getProfilesCache().asMap().values().stream().filter(p -> Strings.CS.equals(p.getContext(), context)).collect(Collectors.toList());
    }

    public Profile getProfile(String id) {
        return this._getProfilesCache().get(id);
    }

    public Set<String> getProfilesWithRight(String rightId) {
        return this._getProfileRightsCache().asMap().entrySet().stream().filter(e -> ((List)e.getValue()).contains(rightId)).map(e -> (String)e.getKey()).collect(Collectors.toSet());
    }

    public Profile addProfile(String label) {
        return this.addProfile(label, null);
    }

    public Profile addProfile(String label, String context) {
        String id = this._generateUniqueId(label);
        Profile profile = new Profile(id, label, context);
        this.addProfile(profile);
        return profile;
    }

    private String _generateUniqueId(String label) {
        String value = label.toLowerCase().trim().replaceAll("[\\W_]", "-").replaceAll("-+", "-").replaceAll("^-", "");
        int i = 2;
        Object suffixedValue = value;
        while (this.getProfile((String)suffixedValue) != null) {
            suffixedValue = value + i;
            ++i;
        }
        return suffixedValue;
    }

    public Profile addProfile(String id, String label, String context) {
        Profile profile = new Profile(id, label, context);
        this.addProfile(profile);
        return profile;
    }

    public void addProfile(Profile profile, boolean silent) {
        try (SqlSession session = this.getSession(true);){
            session.insert("Profiles.addProfile", (Object)profile);
            this.clearCache();
            if (!silent) {
                this._notifyEvent(profile, "profile.added");
            }
        }
    }

    public void addProfile(Profile profile) {
        this.addProfile(profile, false);
    }

    public void renameProfile(Profile profile, String newLabel) {
        this.renameProfile(profile, newLabel, false);
    }

    public void renameProfile(Profile profile, String newLabel, boolean silent) {
        try (SqlSession session = this.getSession(true);){
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("id", profile.getId());
            params.put("label", newLabel);
            session.update("Profiles.renameProfile", params);
            this.clearCache();
            if (!silent) {
                this._notifyEvent(profile, "profile.updated");
            }
        }
    }

    public List<String> getRights(String profileId) {
        List<String> list;
        if (!StringUtils.isEmpty((CharSequence)profileId) && (list = this._getProfileRightsCache().get(profileId)) != null) {
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public List<String> getRights(Profile profile) {
        if (profile == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getRights(profile.getId());
    }

    public void addRight(Profile profile, String rightId) {
        try (SqlSession session = this.getSession(true);){
            this._addRight(session, profile, rightId);
        }
        this.clearCache();
    }

    public void addRights(Profile profile, List<String> rightIds) {
        try (SqlSession session = this.getSession();){
            for (String rightId : rightIds) {
                this._addRight(session, profile, rightId);
            }
            session.commit();
        }
        this.clearCache();
    }

    public void updateRights(Profile profile, List<String> rights) {
        this.updateRights(profile, rights, false);
    }

    public void updateRights(Profile profile, List<String> rights, boolean silent) {
        try (SqlSession session = this.getSession();){
            session.delete("Profiles.deleteProfileRights", (Object)profile.getId());
            if (rights != null) {
                for (String rightId : rights) {
                    this._addRight(session, profile, rightId);
                }
            }
            session.commit();
            this.clearCache();
            if (!silent) {
                this._notifyEvent(profile, "profile.updated");
            }
        }
    }

    private void _addRight(SqlSession session, Profile profile, String rightId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("profileId", profile.getId());
        params.put("rightId", rightId);
        session.insert("Profiles.addRight", params);
    }

    public void removeRights(Profile profile) {
        this.removeRights(profile, false);
    }

    public void removeRights(Profile profile, boolean silent) {
        try (SqlSession session = this.getSession(true);){
            session.delete("Profiles.deleteProfileRights", (Object)profile.getId());
            this.clearCache();
            if (!silent) {
                this._notifyEvent(profile, "profile.updated");
            }
        }
    }

    public void removeRight(Profile profile, String rightId) {
        this.removeRight(profile, rightId, false);
    }

    public void removeRight(Profile profile, String rightId, boolean silent) {
        try (SqlSession session = this.getSession(true);){
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("profileId", profile.getId());
            params.put("rightId", rightId);
            session.delete("Profiles.deleteProfileRight", params);
            this.clearCache();
            if (!silent) {
                this._notifyEvent(profile, "profile.updated");
            }
        }
        this.clearCache();
    }

    public void deleteProfile(Profile profile) {
        this.deleteProfile(profile, false);
    }

    public void deleteProfile(Profile profile, boolean silent) {
        try (SqlSession session = this.getSession();){
            session.delete("Profiles.deleteProfile", (Object)profile.getId());
            session.delete("Profiles.deleteProfileRights", (Object)profile.getId());
            session.commit();
            this.clearCache();
            if (!silent) {
                this._notifyEvent(profile, "profile.deleted");
            }
        }
    }

    private void _notifyEvent(Profile profile, String eventId) {
        try {
            if (this._observationManager == null) {
                this._observationManager = (ObservationManager)((Object)this._smanager.lookup(ObservationManager.ROLE));
            }
            if (this._currentUserProvider == null) {
                this._currentUserProvider = (CurrentUserProvider)this._smanager.lookup(CurrentUserProvider.ROLE);
            }
            HashMap<String, Object> eventParams = new HashMap<String, Object>();
            eventParams.put("profile", profile);
            this._observationManager.notify(new Event(eventId, this._currentUserProvider.getUser(), eventParams));
        }
        catch (ServiceException e) {
            this.getLogger().error("Fail to notify observers for event '" + eventId + "'", (Throwable)e);
        }
    }
}

