/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.right;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ametys.core.right.Right;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.ExtensionPoint;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class RightsExtensionPoint
extends AbstractLogEnabled
implements ExtensionPoint<Right>,
Initializable,
ThreadSafe,
Component {
    public static final String ROLE = RightsExtensionPoint.class.getName();
    protected Map<String, Right> _rights;

    public void initialize() throws Exception {
        this._rights = new HashMap<String, Right>();
    }

    @Override
    public boolean hasExtension(String id) {
        return this._rights.containsKey(id);
    }

    @Override
    public void addExtension(String id, String pluginName, String pluginId, Configuration configuration) throws ConfigurationException {
        Configuration[] rightsConfigurations;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Adding rights from plugin " + pluginName + "/" + pluginId);
        }
        for (Configuration rightConfiguration : rightsConfigurations = configuration.getChildren("right")) {
            try {
                this.addRight("plugin." + pluginName, rightConfiguration, "Declared by plugin '" + pluginName + "'");
            }
            catch (ConfigurationException e) {
                if (!this.getLogger().isWarnEnabled()) continue;
                this.getLogger().warn("The plugin '" + pluginName + "." + pluginId + "' has a rights extension but has an incorrect configuration", (Throwable)e);
            }
        }
    }

    protected Right addRight(String defaultCatalog, Configuration configuration, String message) throws ConfigurationException {
        String id = configuration.getAttribute("id", "");
        if (id.length() == 0) {
            throw new ConfigurationException("Right declaration is incorrect since no 'Id' attribute is specified (or may be empty)", configuration);
        }
        I18nizableText i18nLabel = I18nizableText.parseI18nizableText(configuration.getChild("label", false), defaultCatalog);
        if (i18nLabel == null) {
            throw new ConfigurationException("Right declaration is incorrect since no 'label' element is specified (or may be empty)", configuration);
        }
        I18nizableText i18nDescription = I18nizableText.parseI18nizableText(configuration.getChild("description", false), defaultCatalog);
        if (i18nDescription == null) {
            throw new ConfigurationException("Right declaration is incorrect since no 'description' element is specified (or may be empty)", configuration);
        }
        I18nizableText i18nCategory = I18nizableText.parseI18nizableText(configuration.getChild("category", false), defaultCatalog);
        if (i18nCategory == null) {
            throw new ConfigurationException("Right declaration is incorrect since no 'category' element is specified (or may be empty)", configuration);
        }
        if (this._rights.containsKey(id)) {
            Right right = this._rights.get(id);
            throw new ConfigurationException("Right with id '" + id + "' is already declared : '" + right.getDeclaration() + "'. This second declaration is ignored.", configuration);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Adding right ID : " + id);
        }
        Right right = new Right(id, i18nLabel, i18nDescription, i18nCategory, message);
        if (this._rights.containsKey(id)) {
            Right oldright = this._rights.get(id);
            throw new IllegalArgumentException("Right with id '" + id + "' is already declared : '" + oldright.getDeclaration() + "'. This second declaration is ignored.");
        }
        this._rights.put(id, right);
        return right;
    }

    public Right addRight(String defaultCatalog, Configuration configuration) throws ConfigurationException {
        return this.addRight(defaultCatalog, configuration, "Declared by API");
    }

    public Right addRight(String id, I18nizableText labelKey, I18nizableText descriptionKey, I18nizableText categoryKey) throws IllegalArgumentException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Adding right from API with ID : " + id);
        }
        if (this._rights.containsKey(id)) {
            Right right = this._rights.get(id);
            throw new IllegalArgumentException("Right with id '" + id + "' is already declared : '" + right.getDeclaration() + "'. The application cannot be run.");
        }
        Right right = new Right(id, labelKey, descriptionKey, categoryKey, "Declared by API");
        this._rights.put(id, right);
        return right;
    }

    public void removeRight(String id) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Removing right with ID : " + id + "from API");
        }
        this._rights.remove(id);
    }

    @Override
    public Right getExtension(String id) {
        return this._rights.get(id);
    }

    @Override
    public Set<String> getExtensionsIds() {
        return new HashSet<String>(this._rights.keySet());
    }

    @Override
    public void initializeExtensions() throws Exception {
    }

    public void toSAX(ContentHandler handler) throws SAXException {
        for (String id : this._rights.keySet()) {
            Right right = this._rights.get(id);
            right.toSAX(handler);
        }
    }
}

