/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.right;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.ametys.core.right.AccessController;
import org.ametys.core.right.AccessExplanation;
import org.ametys.core.right.Profile;
import org.ametys.core.right.Right;
import org.ametys.core.right.RightProfilesDAO;
import org.ametys.core.right.RightsExtensionPoint;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class UserPermissionsToolClientSideElement
extends StaticClientSideElement {
    private UserHelper _userHelper;
    private UserManager _userManager;
    private RightProfilesDAO _profileDAO;
    private RightsExtensionPoint _rightsEP;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._profileDAO = (RightProfilesDAO)manager.lookup(RightProfilesDAO.ROLE);
        this._rightsEP = (RightsExtensionPoint)manager.lookup(RightsExtensionPoint.ROLE);
        this._userHelper = (UserHelper)manager.lookup(UserHelper.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
    }

    @Callable(rights={"Runtime_Rights_SeeUserProfiles"})
    public Map<String, Object> getUserPermissions(String login, String populationId) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        UserIdentity user = new UserIdentity(login, populationId);
        Map<AccessController.ExplanationObject, Map<AccessController.Permission, List<AccessExplanation>>> permissionsForUser = this._rightManager.getAllPermissions(user);
        if (permissionsForUser.isEmpty()) {
            return Map.of();
        }
        HashSet<AccessController.Permission> allPermissions = new HashSet<AccessController.Permission>();
        for (AccessController.ExplanationObject context : permissionsForUser.keySet()) {
            allPermissions.addAll(permissionsForUser.get(context).keySet());
            Map<String, Object> jsonAssignments = this._contextPermissionsToJSON(permissionsForUser.get(context));
            jsonAssignments.put("label", context.label());
            jsonAssignments.put("category", context.category());
            jsonAssignments.put("order", context.order());
            result.add(jsonAssignments);
        }
        List<Map> jsonPermissions = allPermissions.stream().map(this::_permissionToJSON).filter(Objects::nonNull).toList();
        return Map.of("data", result, "metaData", Map.of("permissions", jsonPermissions));
    }

    private Map<String, Object> _contextPermissionsToJSON(Map<AccessController.Permission, List<AccessExplanation>> contextPermissions) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<AccessController.Permission, List<AccessExplanation>> entry : contextPermissions.entrySet()) {
            List<AccessExplanation> explanations = entry.getValue();
            if (explanations.isEmpty()) continue;
            explanations.sort(Comparator.naturalOrder());
            AccessController.Permission permission = entry.getKey();
            result.put(permission.toString(), Map.of("accessResult", explanations.get(0).accessResult(), "accessExplanations", explanations));
        }
        return result;
    }

    @Callable(rights={"Runtime_Rights_SeeUserProfiles"})
    public Map<String, Object> getUser(String login, String populationId) {
        return this._userHelper.user2json(this._userManager.getUser(populationId, login), true);
    }

    private Map<String, Object> _permissionToJSON(AccessController.Permission permission) {
        switch (permission.type()) {
            case READ: {
                return Map.of("key", permission.toString(), "type", permission.type().name(), "label", new I18nizableText("plugin.core", "PLUGINS_CORE_RIGHTS_READER_LABEL"), "rights", List.of());
            }
            case ALL_RIGHTS: {
                return Map.of("key", permission.toString(), "type", permission.type().name(), "label", new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_TOOL_USER_PROFILES_ALL_RIGHTS_COLUMN_LABEL"), "rights", List.of());
            }
            case PROFILE: {
                Profile profile = this._profileDAO.getProfile(permission.id());
                if (profile != null) {
                    return Map.of("key", permission.toString(), "id", permission.id(), "type", permission.type().name(), "label", profile.getLabel(), "rights", this._profileDAO.getRights(permission.id()));
                }
                this.getLogger().info("No profile with id '" + permission.id() + "'. The permission is ignored.");
                return null;
            }
            case RIGHT: {
                Right right = this._rightsEP.getExtension(permission.id());
                if (right != null) {
                    return Map.of("key", permission.toString(), "id", permission.id(), "type", permission.type().name(), "label", right.getLabel(), "rights", List.of(permission.id()));
                }
                this.getLogger().info("No right with id '" + permission.id() + "'. The permission is ignored.");
                return null;
            }
        }
        return null;
    }
}

