/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.schedule.progression;

import java.util.Map;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.schedule.progression.ProgressionTracker;
import org.ametys.core.schedule.progression.ProgressionTrackerFactory;
import org.ametys.core.schedule.progression.SimpleProgressionTracker;
import org.ametys.runtime.i18n.I18nizableText;
import org.slf4j.Logger;

public abstract sealed class AbstractProgressionTracker
implements ProgressionTracker
permits SimpleProgressionTracker, ContainerProgressionTracker {
    protected ProgressionTrackerFactory _factory;
    protected I18nizableText _label;
    protected ContainerProgressionTracker _parent;
    private Logger _logger;
    private String _id;

    protected AbstractProgressionTracker(String id, I18nizableText label, ProgressionTrackerFactory factory, Logger logger, ContainerProgressionTracker parent) {
        this._id = id != null ? id : (String)(parent != null ? parent.getId() + "-" : "") + label.toString();
        this._label = label;
        this._factory = factory;
        this._logger = logger;
        this._parent = parent;
    }

    @Override
    public ContainerProgressionTracker getParent() {
        return this._parent;
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public Map<String, Object> toJSON() {
        double percentage = this.asPercentage();
        return Map.of("id", this.getId(), "label", this.getLabel(), "index", this.getIndex(), "size", this.getSize(), "progression", percentage, "running", this._parent == null ? true : this._parent.getCurrentStep() == this);
    }

    protected String _getLogPrefix() {
        return "[Step '" + this._getHierarchicalLabel() + "']";
    }

    protected String _getHierarchicalLabel() {
        if (this._parent != null) {
            return this._parent._getHierarchicalLabel() + " / " + this._factory.getI18nUtils().translate(this._label, "en");
        }
        return this._factory.getI18nUtils().translate(this._label, "en");
    }

    protected Logger _getLogger() {
        return this._logger;
    }

    @Override
    public String getId() {
        return this._id;
    }
}

