/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.schedule.progression;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.schedule.progression.AbstractProgressionTracker;
import org.ametys.core.schedule.progression.ProgressionTracker;
import org.ametys.core.schedule.progression.ProgressionTrackerFactory;
import org.ametys.core.schedule.progression.SimpleProgressionTracker;
import org.ametys.runtime.i18n.I18nizableText;
import org.slf4j.Logger;

public final class ContainerProgressionTracker
extends AbstractProgressionTracker {
    private static final String __UNIQUE_STEP_ID = "unique-step";
    private List<ProgressionTrackerWithWeight> _stepsWithWeight = new ArrayList<ProgressionTrackerWithWeight>();
    private double _totalStepsWeight;
    private int _currentStepIndex;

    ContainerProgressionTracker(String id, I18nizableText label, ProgressionTrackerFactory factory, Logger logger, ContainerProgressionTracker parent) {
        super(id, label, factory, logger, parent);
    }

    @Override
    public long getIndex() {
        return this._currentStepIndex + 1;
    }

    @Override
    public long getSize() {
        return this._stepsWithWeight.size();
    }

    @Override
    public double asPercentage() {
        double progression = 0.0;
        if (this._totalStepsWeight != 0.0) {
            for (ProgressionTrackerWithWeight progressionTrackerWithWeight : this._stepsWithWeight) {
                progression += progressionTrackerWithWeight.progressionTracker().asPercentage() * progressionTrackerWithWeight.weight();
            }
            progression /= this._totalStepsWeight;
        }
        return progression;
    }

    public ProgressionTracker getStep(int index) throws IllegalArgumentException {
        if (index >= 0 && (long)index < this.getSize()) {
            return this._stepsWithWeight.get(index).progressionTracker();
        }
        throw new IllegalArgumentException("No progression tracker was found at index " + index + "' for parent of id '" + this.getId() + "'");
    }

    public <T extends ProgressionTracker> T getCurrentStep() throws IllegalArgumentException {
        if (this._currentStepIndex < this._stepsWithWeight.size()) {
            return (T)this._stepsWithWeight.get(this._currentStepIndex).progressionTracker();
        }
        throw new IllegalArgumentException("There is no steps under parent of id '" + this.getId() + "'");
    }

    void ensureCurrentStep(ProgressionTracker progressionTracker) {
        int index = 0;
        for (ProgressionTrackerWithWeight stepWithWeight : this._stepsWithWeight) {
            if (progressionTracker == stepWithWeight.progressionTracker()) {
                this._currentStepIndex = index;
                break;
            }
            ++index;
        }
        this._ensureCurrentStep();
    }

    private void _ensureCurrentStep() {
        if (this._parent != null) {
            this._parent.ensureCurrentStep(this);
        }
    }

    void nextStep() {
        this._ensureCurrentStep();
        if (this._parent != null && this._currentStepIndex == this._stepsWithWeight.size() - 1) {
            if (this._getLogger().isInfoEnabled()) {
                this._getLogger().info(this._getLogPrefix() + " Finished");
            }
            this._parent.nextStep();
        } else if (this._currentStepIndex == this._stepsWithWeight.size() - 1) {
            if (this._getLogger().isInfoEnabled()) {
                this._getLogger().info(this._getLogPrefix() + " Finished");
            }
        } else {
            ++this._currentStepIndex;
            if (this._getLogger().isInfoEnabled()) {
                this._getLogger().info(this._getLogPrefix() + " Starting step " + (this._currentStepIndex + 1) + ": " + this._factory.getI18nUtils().translate(this.getCurrentStep().getLabel(), "en"));
            }
        }
    }

    public SimpleProgressionTracker addSimpleStep(String id, I18nizableText label) {
        return this.addSimpleStep(id, label, 1.0);
    }

    public SimpleProgressionTracker addSimpleStep(String id, I18nizableText label, double weight) {
        SimpleProgressionTracker step = ProgressionTrackerFactory.createSimpleProgressionTracker(id, label, this._getLogger(), this);
        this._addStep(step, weight);
        return step;
    }

    public ContainerProgressionTracker addContainerStep(String id, I18nizableText label) {
        return this.addContainerStep(id, label, 1.0);
    }

    public ContainerProgressionTracker addContainerStep(String id, I18nizableText label, double weight) {
        ContainerProgressionTracker step = ProgressionTrackerFactory.createContainerProgressionTracker(id, label, this._getLogger(), this);
        this._addStep(step, weight);
        return step;
    }

    private void _addStep(ProgressionTracker step, double weight) {
        if (this._stepsWithWeight.size() == 0 && this._getLogger().isInfoEnabled()) {
            this._getLogger().info(this._getLogPrefix() + " Starting step 1: " + this._factory.getI18nUtils().translate(step.getLabel(), "en"));
        }
        this._totalStepsWeight += weight;
        this._stepsWithWeight.add(new ProgressionTrackerWithWeight(step, weight));
    }

    @Override
    public Map<String, Object> toJSON() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(super.toJSON());
        List<Map> stepsToJSON = this._stepsWithWeight.stream().map(ProgressionTrackerWithWeight::progressionTracker).map(ProgressionTracker::toJSON).toList();
        result.put("steps", stepsToJSON);
        return result;
    }

    public <T extends ProgressionTracker> T getStep(String id) throws IllegalArgumentException {
        for (ProgressionTrackerWithWeight stepWithWeight : this._stepsWithWeight) {
            ProgressionTracker progressionTracker = stepWithWeight.progressionTracker();
            if (!progressionTracker.getId().equals(id)) continue;
            return (T)progressionTracker;
        }
        throw new IllegalArgumentException("No progression tracker was found for id '" + id + "' of parent of id '" + this.getId() + "'");
    }

    public <T extends ProgressionTracker> T findStep(String id) throws IllegalArgumentException {
        try {
            return this.getStep(id);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            for (ProgressionTrackerWithWeight stepWithWeight : this._stepsWithWeight) {
                ProgressionTracker progressionTracker = stepWithWeight.progressionTracker();
                if (!(progressionTracker instanceof ContainerProgressionTracker)) continue;
                ContainerProgressionTracker stepContainer = (ContainerProgressionTracker)progressionTracker;
                try {
                    return stepContainer.findStep(id);
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                }
            }
            throw new IllegalArgumentException("No progression tracker was found for id '" + id + "' of parent of id '" + this.getId() + "'");
        }
    }

    public void setSteps(List<Map<String, Object>> steps) {
        for (Map<String, Object> stepMap : steps) {
            I18nizableText ilabel;
            Double weight = ((Number)stepMap.getOrDefault("weight", 1)).doubleValue();
            Object label = stepMap.get("label");
            I18nizableText i18nlabel = label instanceof I18nizableText ? (ilabel = (I18nizableText)label) : new I18nizableText(label.toString());
            String id = (String)stepMap.get("id");
            AbstractProgressionTracker step = stepMap.containsKey("children") ? this.addContainerStep(id, i18nlabel, weight) : this.addSimpleStep(id, i18nlabel, weight);
            if (!(step instanceof ContainerProgressionTracker)) continue;
            AbstractProgressionTracker containerStep = step;
            ((ContainerProgressionTracker)containerStep).setSteps((List)stepMap.get("children"));
        }
    }

    public void setSize(long size) throws IllegalArgumentException {
        this.setSize(size, "Unique step");
    }

    public void setSize(long size, String label) throws IllegalArgumentException {
        this.setSize(size, new I18nizableText(label));
    }

    public void setSize(long size, I18nizableText label) throws IllegalArgumentException {
        if (this._stepsWithWeight.size() > 0) {
            throw new IllegalArgumentException("Cannot call setSize(long size) when the steps are already initialized");
        }
        SimpleProgressionTracker uniqueStep = this.addSimpleStep(__UNIQUE_STEP_ID, label);
        uniqueStep.setSize(size);
    }

    public void setSize(String id, long size) throws IllegalArgumentException {
        Object step = this.findStep(id);
        if (!(step instanceof SimpleProgressionTracker)) {
            throw new IllegalArgumentException("The progression tracker of id '" + id + "' is not a SimpleProgressionTracker");
        }
        SimpleProgressionTracker simpleStep = (SimpleProgressionTracker)step;
        simpleStep.setSize(size);
    }

    public void increment() throws IllegalArgumentException {
        this.increment(__UNIQUE_STEP_ID, 1L);
    }

    public void increment(long increment) throws IllegalArgumentException {
        this.increment(__UNIQUE_STEP_ID, increment);
    }

    public void increment(String id) throws IllegalArgumentException {
        this.increment(id, 1L);
    }

    public void increment(String id, long increment) throws IllegalArgumentException {
        Object step = this.findStep(id);
        if (!(step instanceof SimpleProgressionTracker)) {
            throw new IllegalArgumentException("The progression tracker of id '" + id + "' is not a SimpleProgressionTracker or does not exist");
        }
        SimpleProgressionTracker simpleStep = (SimpleProgressionTracker)step;
        simpleStep.increment(increment);
    }

    private record ProgressionTrackerWithWeight(ProgressionTracker progressionTracker, double weight) {
    }
}

