/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.schedule.progression;

import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.schedule.progression.SimpleProgressionTracker;
import org.ametys.core.util.I18nUtils;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.slf4j.Logger;

public class ProgressionTrackerFactory
implements Component,
Serviceable {
    public static final String ROLE = ProgressionTrackerFactory.class.getName();
    private static I18nUtils _i18nUtils;
    private static ProgressionTrackerFactory _instance;

    public ProgressionTrackerFactory() {
        _instance = this;
    }

    public void service(ServiceManager manager) throws ServiceException {
        _i18nUtils = (I18nUtils)((Object)manager.lookup(I18nUtils.ROLE));
    }

    public static SimpleProgressionTracker createSimpleProgressionTracker(String label, Logger logger) {
        return ProgressionTrackerFactory.createSimpleProgressionTracker(null, new I18nizableText(label), logger, null);
    }

    public static SimpleProgressionTracker createSimpleProgressionTracker(I18nizableText label, Logger logger) {
        return ProgressionTrackerFactory.createSimpleProgressionTracker(null, label, logger, null);
    }

    static SimpleProgressionTracker createSimpleProgressionTracker(String id, I18nizableText label, Logger logger, ContainerProgressionTracker parent) {
        return new SimpleProgressionTracker(id, label, _instance, logger, parent);
    }

    public static ContainerProgressionTracker createContainerProgressionTracker(String label, Logger logger) {
        return ProgressionTrackerFactory.createContainerProgressionTracker(null, new I18nizableText(label), logger, null);
    }

    public static ContainerProgressionTracker createContainerProgressionTracker(I18nizableText label, Logger logger) {
        return ProgressionTrackerFactory.createContainerProgressionTracker(null, label, logger, null);
    }

    static ContainerProgressionTracker createContainerProgressionTracker(String id, I18nizableText label, Logger logger, ContainerProgressionTracker parent) {
        return new ContainerProgressionTracker(id, label, _instance, logger, parent);
    }

    I18nUtils getI18nUtils() {
        return _i18nUtils;
    }
}

