/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.schedule.progression;

import org.ametys.core.schedule.progression.AbstractProgressionTracker;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.schedule.progression.ProgressionTrackerFactory;
import org.ametys.runtime.i18n.I18nizableText;
import org.slf4j.Logger;

public final class SimpleProgressionTracker
extends AbstractProgressionTracker {
    private long _index;
    private long _size = 1L;
    private int _loggerGranularity = 500;

    SimpleProgressionTracker(String id, I18nizableText label, ProgressionTrackerFactory factory, Logger logger, ContainerProgressionTracker parent) {
        super(id, label, factory, logger, parent);
    }

    public SimpleProgressionTracker withLoggerGranularity(int loggerGranularity) {
        this._loggerGranularity = loggerGranularity;
        return this;
    }

    protected void complete() {
        if (this._parent != null) {
            this._parent.nextStep();
        }
    }

    @Override
    public long getIndex() {
        return this._index;
    }

    @Override
    public long getSize() {
        return this._size;
    }

    public void setSize(long size) {
        this._size = size;
        if (size == 0L) {
            this.complete();
        }
    }

    public void increment() {
        this.increment(1L);
    }

    public synchronized void increment(long increment) {
        long newCurrentGraduation = this._index + increment;
        this._ensureCurrentStep();
        if (newCurrentGraduation < this._size) {
            if (this._getLogger().isInfoEnabled() && (newCurrentGraduation - 1L) / (long)this._loggerGranularity != (this._index - 1L) / (long)this._loggerGranularity) {
                this._getLogger().info(this._getLogPrefix() + " The incremental progression is now " + this._index + " out of " + this._size + " graduations.");
            }
            this._index = newCurrentGraduation;
        } else {
            this._index = this._size;
            this.complete();
            if (newCurrentGraduation > this._size && this._getLogger().isWarnEnabled()) {
                this._getLogger().warn("[Step of id '" + this.getId() + "'] The incrementation of the progression has tried to exceed the maximum.");
            }
        }
    }

    private void _ensureCurrentStep() {
        if (this._parent != null) {
            this._parent.ensureCurrentStep(this);
        }
    }

    @Override
    public double asPercentage() {
        if (this._size == 0L) {
            return 100.0;
        }
        if (this._index < 0L) {
            return 0.0;
        }
        return (double)this._index / (double)this._size * 100.0;
    }
}

