/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.script;

import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.ametys.core.datasource.ConnectionHelper;
import org.apache.commons.io.IOUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SQLScriptHelper {
    public static final String DEFAULT_SEPARATOR = ";";
    public static final String IGNORE_EXCEPTIONS_COMMAND = "_ignore_exceptions_=";
    public static final String CHANGE_SEPARATOR_COMMAND = "_separator_=";
    protected static final Logger __LOGGER = LoggerFactory.getLogger(SQLScriptHelper.class);

    private SQLScriptHelper() {
    }

    public static boolean createTableIfNotExists(String datasourceId, String tableNameToCheck, String location, SourceResolver sourceResolver) throws SQLException, IOException {
        return SQLScriptHelper.createTableIfNotExists(datasourceId, tableNameToCheck, location, sourceResolver, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createTableIfNotExists(String datasourceId, String tableNameToCheck, String location, SourceResolver sourceResolver, Map<String, String> replace) throws SQLException, IOException {
        Connection connection = null;
        try {
            connection = ConnectionHelper.getConnection(datasourceId);
            boolean bl = SQLScriptHelper.createTableIfNotExists(connection, tableNameToCheck, location, sourceResolver, replace);
            return bl;
        }
        finally {
            ConnectionHelper.cleanup(connection);
        }
    }

    public static boolean createTableIfNotExists(Connection connection, String tableNameToCheck, String location, SourceResolver sourceResolver) throws SQLException, IOException {
        return SQLScriptHelper.createTableIfNotExists(connection, tableNameToCheck, location, sourceResolver, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createTableIfNotExists(Connection connection, String tableNameToCheck, String location, SourceResolver sourceResolver, Map<String, String> replace) throws SQLException, IOException {
        if (SQLScriptHelper.tableExists(connection, tableNameToCheck)) {
            return false;
        }
        String finalLocation = String.format(location, ConnectionHelper.getDatabaseType(connection));
        Source source = null;
        try {
            source = sourceResolver.resolveURI(finalLocation);
            try (InputStream is = source.getInputStream();){
                String script = IOUtils.toString((InputStream)is, (String)"UTF-8");
                if (replace != null) {
                    for (String replaceKey : replace.keySet()) {
                        script = script.replaceAll(replaceKey, replace.get(replaceKey));
                    }
                }
                SQLScriptHelper.runScript(connection, script);
            }
        }
        finally {
            sourceResolver.release(source);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tableExists(Connection connection, String tableName) throws SQLException {
        String name;
        DatabaseMetaData metaData;
        ResultSet rs;
        block13: {
            boolean bl;
            rs = null;
            metaData = connection.getMetaData();
            name = tableName;
            if (metaData.storesLowerCaseIdentifiers()) {
                name = tableName.toLowerCase();
            } else if (metaData.storesUpperCaseIdentifiers()) {
                name = tableName.toUpperCase();
            }
            try {
                rs = metaData.getTables(connection.getCatalog(), connection.getSchema(), name, null);
                if (!rs.next()) break block13;
                bl = true;
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(rs);
                throw throwable;
            }
            ConnectionHelper.cleanup(rs);
            return bl;
        }
        ConnectionHelper.cleanup(rs);
        String quotedName = tableName;
        if (metaData.storesLowerCaseQuotedIdentifiers()) {
            quotedName = tableName.toLowerCase();
        } else if (metaData.storesUpperCaseQuotedIdentifiers()) {
            quotedName = tableName.toUpperCase();
        }
        if (!quotedName.equals(name)) {
            try {
                rs = metaData.getTables(connection.getCatalog(), connection.getSchema(), quotedName, null);
                if (rs.next()) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                ConnectionHelper.cleanup(rs);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runScript(Connection connection, String script) throws IOException, SQLException {
        ScriptContext scriptContext = new ScriptContext();
        StringBuilder command = new StringBuilder();
        try {
            LineNumberReader lineReader = new LineNumberReader(new StringReader(script));
            String line = null;
            while ((line = lineReader.readLine()) != null) {
                if (__LOGGER.isDebugEnabled()) {
                    __LOGGER.debug(String.format("Reading line: '%s'", line));
                }
                boolean processCommand = false;
                String trimmedLine = line.trim();
                if (trimmedLine.length() <= 0 || !(processCommand = SQLScriptHelper.processScriptLine(trimmedLine, command, scriptContext))) continue;
                SQLScriptHelper._processCommand(connection, command, lineReader.getLineNumber(), scriptContext);
            }
            if (command.length() > 0) {
                SQLScriptHelper._processCommand(connection, command, lineReader.getLineNumber(), scriptContext);
            }
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        finally {
            if (!connection.getAutoCommit()) {
                try {
                    connection.rollback();
                }
                catch (SQLException s) {
                    __LOGGER.error("Error while rollbacking connection", (Throwable)s);
                }
            }
        }
    }

    public static void runScript(Connection connection, InputStream is) throws IOException, SQLException {
        try {
            String script = IOUtils.toString((InputStream)is, (String)"UTF-8");
            SQLScriptHelper.runScript(connection, script);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    protected static boolean processScriptLine(String line, StringBuilder commandBuffer, ScriptContext scriptContext) {
        boolean processCommand = false;
        if (line.startsWith("//") || line.startsWith("--")) {
            String currentSeparator = scriptContext.getSeparator();
            if (line.contains(CHANGE_SEPARATOR_COMMAND)) {
                String newSeparator = line.substring(line.indexOf(CHANGE_SEPARATOR_COMMAND) + CHANGE_SEPARATOR_COMMAND.length()).trim();
                scriptContext.setSeparator(newSeparator);
                if (__LOGGER.isDebugEnabled()) {
                    __LOGGER.debug(String.format("Changing separator to: '%s'", newSeparator));
                }
            } else if (line.contains(IGNORE_EXCEPTIONS_COMMAND)) {
                String ignoreStr = line.substring(line.indexOf(IGNORE_EXCEPTIONS_COMMAND) + IGNORE_EXCEPTIONS_COMMAND.length()).trim();
                boolean ignoreExceptions = "on".equals(ignoreStr);
                scriptContext.setIgnoreExceptions(ignoreExceptions);
                if (__LOGGER.isDebugEnabled()) {
                    __LOGGER.debug(String.format("Ignore exceptions: '%s'", ignoreExceptions ? "on" : "off"));
                }
            }
            if (line.contains(currentSeparator) && commandBuffer.length() > 0) {
                processCommand = true;
            }
        } else if (line.endsWith(scriptContext.getSeparator())) {
            processCommand = true;
            commandBuffer.append(line.substring(0, line.lastIndexOf(scriptContext.getSeparator())));
        } else {
            commandBuffer.append(line);
            commandBuffer.append(" ");
        }
        return processCommand;
    }

    private static void _processCommand(Connection connection, StringBuilder command, int lineNumber, ScriptContext scriptContext) throws SQLException {
        if (__LOGGER.isInfoEnabled()) {
            __LOGGER.info(String.format("Executing SQL command: '%s'", command));
        }
        SQLScriptHelper._execute(connection, command.toString(), lineNumber, scriptContext);
        command.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _execute(Connection connection, String command, int lineNumber, ScriptContext scriptContext) throws SQLException {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute(command);
        }
        catch (SQLException e) {
            if (!scriptContext.ignoreExceptions()) {
                String message = String.format("Unable to execute SQL: '%s' at line %d", command, lineNumber);
                __LOGGER.error(message, (Throwable)e);
                throw new SQLException(message, e);
            }
        }
        finally {
            ConnectionHelper.cleanup(statement);
        }
    }

    protected static class ScriptContext {
        protected String _separator;
        protected boolean _ignoreExceptions;

        public ScriptContext() {
            this(SQLScriptHelper.DEFAULT_SEPARATOR, false);
        }

        public ScriptContext(String separator, boolean ignoreExceptions) {
            this._separator = separator;
            this._ignoreExceptions = ignoreExceptions;
        }

        public String getSeparator() {
            return this._separator;
        }

        public void setSeparator(String separator) {
            this._separator = separator;
        }

        public boolean ignoreExceptions() {
            return this._ignoreExceptions;
        }

        public void setIgnoreExceptions(boolean ignoreExceptions) {
            this._ignoreExceptions = ignoreExceptions;
        }
    }
}

