/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.servletwrapper.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Redirector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletWrapperResponse
implements HttpServletResponse {
    private HttpServletResponse _response;
    private Redirector _redirect;
    private Logger _logger = LoggerFactory.getLogger(ServletWrapperResponse.class);

    public ServletWrapperResponse(HttpServletResponse req, Redirector redirect) {
        this._response = req;
        this._redirect = redirect;
        if (this._response == null) {
            throw new IllegalArgumentException("Response can not be null");
        }
    }

    public void addHeader(String name, String value) {
        this._response.addHeader(name, value);
    }

    public void addDateHeader(String name, long date) {
        this._response.addDateHeader(name, date);
    }

    public void setIntHeader(String name, int value) {
        this._response.setIntHeader(name, value);
    }

    public void setDateHeader(String name, long date) {
        this._response.setDateHeader(name, date);
    }

    public String getHeader(String name) {
        return this._response.getHeader(name);
    }

    public Collection<String> getHeaders(String name) {
        return this._response.getHeaders(name);
    }

    public Collection<String> getHeaderNames() {
        return this._response.getHeaderNames();
    }

    public void setContentType(String type) {
        this._response.setContentType(type);
    }

    public String encodeURL(String url) {
        return this._response.encodeURL(url);
    }

    @Deprecated
    public String encodeUrl(String url) {
        return this._response.encodeUrl(url);
    }

    public String encodeRedirectURL(String url) {
        return this._response.encodeRedirectURL(url);
    }

    @Deprecated
    public String encodeRedirectUrl(String url) {
        return this._response.encodeRedirectUrl(url);
    }

    public String getCharacterEncoding() {
        return this._response.getCharacterEncoding();
    }

    public void setContentLength(int length) {
        this._response.setContentLength(length);
    }

    public void setContentLengthLong(long len) {
        this._response.setContentLengthLong(len);
    }

    public boolean isCommitted() {
        return false;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this._response.getOutputStream();
    }

    public void setStatus(int sc) {
        this._response.setStatus(sc);
    }

    @Deprecated
    public void setStatus(int sc, String sm) {
        this._response.setStatus(sc, sm);
    }

    public int getStatus() {
        return this._response.getStatus();
    }

    public void reset() {
        this._response.reset();
    }

    public int getBufferSize() {
        return this._response.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        this._response.flushBuffer();
    }

    public void setBufferSize(int size) {
        this._response.setBufferSize(size);
    }

    public void sendRedirect(String location) throws IOException {
        try {
            this._redirect.redirect(false, location);
        }
        catch (ProcessingException pe) {
            this._logger.error(pe.getMessage(), (Throwable)pe);
            throw new IOException(pe.getMessage());
        }
    }

    public void setHeader(String name, String value) {
        this._response.setHeader(name, value);
    }

    public Locale getLocale() {
        return this._response.getLocale();
    }

    public void setLocale(Locale loc) {
        this._response.setLocale(loc);
    }

    public void sendError(int sc) throws IOException {
        this._response.sendError(sc);
    }

    public void sendError(int sc, String sm) throws IOException {
        this._response.sendError(sc, sm);
    }

    public boolean containsHeader(String name) {
        return this._response.containsHeader(name);
    }

    public void addIntHeader(String name, int value) {
        this._response.addIntHeader(name, value);
    }

    public PrintWriter getWriter() throws IOException {
        return this._response.getWriter();
    }

    public void addCookie(Cookie cookie) {
        this._response.addCookie(cookie);
    }

    public String getContentType() {
        throw new UnsupportedOperationException("This method is not supported.");
    }

    public void resetBuffer() {
        throw new UnsupportedOperationException("This method is not supported.");
    }

    public void setCharacterEncoding(String arg0) {
        throw new UnsupportedOperationException("This method is not supported.");
    }
}

