/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.ametys.core.source.ViewSelector;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class DefaultViewSelector
extends AbstractLogEnabled
implements ViewSelector,
Serviceable {
    protected SourceResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    @Override
    public Source getSource(String pluginName, String fileLocation) throws IOException {
        for (String uri : this.getLocations(pluginName, fileLocation)) {
            try {
                Source source = this._resolver.resolveURI(uri);
                if (!source.exists()) {
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug("Failed to find a stylesheet at '" + source.getURI() + "'.");
                    continue;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Using source located at '" + source.getURI() + "'.");
                }
                return source;
            }
            catch (IOException e) {
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("Resolving protocol failed for resolving '" + fileLocation + "'.");
            }
        }
        throw new IOException("Can't find a stylesheet for: " + fileLocation);
    }

    protected List<String> getLocations(String pluginName, String filePath) {
        ArrayList<String> locations = new ArrayList<String>();
        locations.add("context://WEB-INF/param/view/" + filePath);
        if (pluginName != null) {
            locations.add("plugin:" + pluginName + "://" + filePath);
        }
        locations.addAll(this._getDefaultSourceURIs(pluginName, filePath));
        return locations;
    }

    protected List<String> _getDefaultSourceURIs(String pluginName, String filePath) {
        return new ArrayList<String>();
    }
}

