/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.source;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.core.source.OptionalSourceFallback;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.excalibur.source.SourceUtil;

public class StaticOptionalSourceFallback
implements OptionalSourceFallback,
Component,
Configurable,
PluginAware {
    private Fallbacks _fallbacks;
    private String _pluginName;

    public void configure(Configuration configuration) throws ConfigurationException {
        this._fallbacks = StaticOptionalSourceFallback.configureFallbacks(configuration, "plugin:" + this._pluginName + "://");
    }

    @Override
    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public static Fallbacks configureFallbacks(Configuration configuration, String baseUri) throws ConfigurationException {
        LinkedHashMap<String, String> stringFallbacks = new LinkedHashMap<String, String>();
        LinkedHashMap<Pattern, String> patternFallbacks = new LinkedHashMap<Pattern, String>();
        for (Configuration fallback : configuration.getChildren("fallback")) {
            String uri = fallback.getChild("uri").getValue();
            String value = fallback.getChild("fallback").getValue();
            boolean isRegexp = fallback.getChild("uri").getAttributeAsBoolean("regexp", false);
            if (isRegexp) {
                patternFallbacks.put(Pattern.compile(uri), value);
                continue;
            }
            stringFallbacks.put(uri, value);
        }
        return new Fallbacks(baseUri, stringFallbacks, patternFallbacks);
    }

    @Override
    public String fallback(String uri) {
        return StaticOptionalSourceFallback.applyFallbacks(uri, this._fallbacks);
    }

    public static String applyFallbacks(String uri, Fallbacks fallbacks) {
        if (fallbacks.stringFallbacks().containsKey(uri)) {
            return fallbacks.stringFallbacks().get(uri);
        }
        for (Map.Entry<Pattern, String> patternFallback : fallbacks.patternFallbacks().entrySet()) {
            Matcher matcher = patternFallback.getKey().matcher(uri);
            if (!matcher.matches()) continue;
            String value = patternFallback.getValue();
            for (int g = 1; g <= matcher.groupCount(); ++g) {
                value = value.replace("$" + g, matcher.group(g));
            }
            return SourceUtil.absolutize((String)fallbacks.baseUri(), (String)value);
        }
        return fallbacks.patternFallbacks().entrySet().stream().filter(e -> ((Pattern)e.getKey()).matcher(uri).matches()).findFirst().map(e -> SourceUtil.absolutize((String)fallbacks.baseUri(), (String)((String)e.getValue()))).orElse(null);
    }

    public record Fallbacks(String baseUri, Map<String, String> stringFallbacks, Map<Pattern, String> patternFallbacks) {
    }
}

