/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.source;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.core.source.ViewSelector;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceFactory;

public class ViewSourceFactory
extends AbstractLogEnabled
implements SourceFactory,
Serviceable,
Contextualizable {
    private static final Pattern __SOURCE_PATTERN = Pattern.compile("^[\\w]+:([^:]+:)?//(.*)$");
    protected ViewSelector _viewSelector;
    protected Context _context;

    public void service(ServiceManager manager) throws ServiceException {
        this._viewSelector = (ViewSelector)manager.lookup(ViewSelector.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public Source getSource(String location, Map parameters) throws IOException, MalformedURLException {
        Matcher m = __SOURCE_PATTERN.matcher(location);
        if (!m.matches()) {
            throw new MalformedURLException("URI must be like protocol://path/to/resource. Location was '" + location + "'");
        }
        Request request = ContextHelper.getRequest((Context)this._context);
        String pluginName = m.group(1);
        if (pluginName == null) {
            pluginName = request.getParameter("pluginName");
            if (pluginName == null) {
                pluginName = (String)request.getAttribute("pluginName");
            }
        } else {
            pluginName = pluginName.substring(0, pluginName.length() - 1);
        }
        String fileLocation = m.group(2);
        return this._viewSelector.getSource(pluginName, fileLocation);
    }

    public void release(Source source) {
    }
}

