/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.trace;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.StringUtils;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForensicLogger
implements Observer,
Contextualizable {
    private static final String __DEFAULT_LOG_FORMAT = "[{}] [{}] {} ({}) ({})";
    private static final String __DEFAULT_ARGS_SEPARATOR = "|";
    private static final List<String> __REQUEST_HEADER_NAME = List.of("origin", "referer", "user-agent", "host");
    private static final String __NO_REQUEST = "No Request";
    private static final String __UNKNOWN_ISSUER = "Unknown Issuer";
    private static final String __UNKNOWN_IP = "Unknown IP";
    private static Map<String, Logger> _loggers = new HashMap<String, Logger>();
    private static Context _context;

    public void contextualize(Context context) throws ContextException {
        _context = context;
    }

    public static synchronized Logger getLogger(String eventId) {
        return _loggers.computeIfAbsent(eventId, key -> LoggerFactory.getLogger((String)(ForensicLogger.class.getName() + "." + key)));
    }

    @Override
    public boolean supports(Event event) {
        return ForensicLogger.getLogger(event.getId()).isInfoEnabled();
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        ForensicLogger.info(event.getId(), event.getArguments(), event.getIssuer());
    }

    public static void info(String eventId, Map<String, Object> eventArgs, UserIdentity issuer) {
        Logger logger = ForensicLogger.getLogger(eventId);
        if (logger.isInfoEnabled()) {
            logger.info(__DEFAULT_LOG_FORMAT, new Object[]{ForensicLogger.getIP(), ForensicLogger.eventIssuer(issuer), eventId, ForensicLogger.eventArguments(eventArgs), ForensicLogger.requestHeaders()});
        }
    }

    public static void warn(String eventId, Map<String, Object> eventArgs, UserIdentity issuer) {
        Logger logger = ForensicLogger.getLogger(eventId);
        if (logger.isWarnEnabled()) {
            logger.warn(__DEFAULT_LOG_FORMAT, new Object[]{ForensicLogger.getIP(), ForensicLogger.eventIssuer(issuer), eventId, ForensicLogger.eventArguments(eventArgs), ForensicLogger.requestHeaders()});
        }
    }

    public static String getIP() {
        try {
            Request request = ContextHelper.getRequest((Context)_context);
            if (request != null) {
                return Optional.of("X-Forwarded-For").map(arg_0 -> ((Request)request).getHeader(arg_0)).map(StringUtils::stringToCollection).map(Collection::stream).orElseGet(() -> Stream.of(new String[0])).findFirst().orElseGet(() -> ((Request)request).getRemoteAddr());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return __UNKNOWN_IP;
    }

    public static String requestHeaders() {
        try {
            Request request = ContextHelper.getRequest((Context)_context);
            if (request != null) {
                Enumeration headerNames = request.getHeaderNames();
                Stream headerNamesAsStream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(headerNames.asIterator(), 16), false);
                return headerNamesAsStream.filter(name -> __REQUEST_HEADER_NAME.contains(name)).map(name -> name + "::" + request.getHeader(name)).collect(Collectors.joining(__DEFAULT_ARGS_SEPARATOR));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return __NO_REQUEST;
    }

    public static String eventIssuer(UserIdentity user) {
        return Optional.ofNullable(user).map(UserIdentity::userIdentityToString).orElse(__UNKNOWN_ISSUER);
    }

    public static String eventArguments(Map<String, Object> arguments) {
        if (MapUtils.isNotEmpty(arguments)) {
            return arguments.entrySet().stream().map(e -> (String)e.getKey() + "::" + String.valueOf(e.getValue())).collect(Collectors.joining(__DEFAULT_ARGS_SEPARATOR));
        }
        return "";
    }
}

