/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.MutableConfiguration;
import org.apache.avalon.framework.service.ServiceException;

public abstract class AbstractClientSideExtensionPoint<T extends ClientSideElement>
extends AbstractThreadSafeComponentExtensionPoint<T> {
    private Map<String, Configuration> _configurations = new HashMap<String, Configuration>();
    private Map<String, String> _configurationPlugins = new HashMap<String, String>();
    private List<AbstractClientSideExtensionPoint<T>> _registeredManagers = new ArrayList<AbstractClientSideExtensionPoint<T>>();
    private List<ReferencingExtension> _referencingExtensions = new ArrayList<ReferencingExtension>();
    private boolean _initialized;

    @Override
    public void addExtension(String id, String pluginName, String featureName, Configuration configuration) throws ConfigurationException {
        if (configuration.getAttribute("ref-id", null) != null) {
            if (this._initialized) {
                this._addReferencingExtension(id, pluginName, featureName, configuration);
            } else {
                this._referencingExtensions.add(new ReferencingExtension(this, id, pluginName, featureName, configuration));
            }
        } else {
            this._configurations.put(id, configuration);
            this._configurationPlugins.put(id, pluginName);
            super.addExtension(id, pluginName, featureName, configuration);
        }
    }

    private void _addReferencingExtension(String id, String pluginName, String featureName, Configuration configuration) throws ConfigurationException {
        try {
            String refId = configuration.getAttribute("ref-id");
            String extensionPoint = configuration.getAttribute("point");
            AbstractClientSideExtensionPoint clientSideElementManager = (AbstractClientSideExtensionPoint)this._cocoonManager.lookup(extensionPoint);
            Configuration baseConfiguration = clientSideElementManager._getConfiguration(refId);
            if (baseConfiguration == null) {
                throw new ConfigurationException("Unknow ref-id '" + refId + "' for the extension point '" + extensionPoint + "'", configuration);
            }
            DefaultConfiguration mergedConfiguration = new DefaultConfiguration(baseConfiguration, true);
            this._getMerdedChildsConfiguration(configuration, (MutableConfiguration)mergedConfiguration);
            mergedConfiguration.setAttribute("ref-id", null);
            this._configurations.put(id, (Configuration)mergedConfiguration);
            this._configurationPlugins.put(id, pluginName);
            super.addExtension(id, pluginName, featureName, (Configuration)mergedConfiguration);
        }
        catch (ServiceException e) {
            throw new ConfigurationException("Invalid id referenced by the attribute 'ref-id'", configuration);
        }
    }

    private Configuration _getConfiguration(String id) throws ConfigurationException {
        Configuration configuration = this._configurations.get(id);
        if (configuration != null) {
            return this._getContexutalizedConfiguration(configuration, this._configurationPlugins.get(id));
        }
        for (AbstractClientSideExtensionPoint<T> manager : this._registeredManagers) {
            configuration = manager._getConfiguration(id);
            if (configuration == null) continue;
            return configuration;
        }
        return null;
    }

    private Configuration _getContexutalizedConfiguration(Configuration configuration, String pluginName) throws ConfigurationException {
        DefaultConfiguration contextualizedConfiguration = new DefaultConfiguration(configuration);
        this._contexutalizeConfiguration((MutableConfiguration)contextualizedConfiguration, pluginName);
        return contextualizedConfiguration;
    }

    private void _contexutalizeConfiguration(MutableConfiguration configuration, String pluginName) throws ConfigurationException {
        for (MutableConfiguration child : configuration.getMutableChildren()) {
            if ((child.getName().equals("file") || child.getAttributeAsBoolean("file", false) || "file".equals(child.getAttribute("type", null))) && child.getAttribute("plugin", null) == null) {
                child.setAttribute("plugin", pluginName);
            } else if (("true".equals(child.getAttribute("i18n", "false")) || "i18n".equals(child.getAttribute("type", null))) && child.getValue().indexOf(":") < 0 && child.getValue().length() > 0) {
                child.setValue("plugin." + pluginName + ":" + child.getValue());
            }
            this._contexutalizeConfiguration(child, pluginName);
        }
    }

    private void _getMerdedChildsConfiguration(Configuration configuration, MutableConfiguration base) throws ConfigurationException {
        base.addAllAttributes(configuration);
        for (Configuration child : configuration.getChildren()) {
            String tagName = child.getName();
            MutableConfiguration baseChild = base.getMutableChild(tagName);
            if ("scripts".equals(tagName) || "css".equals(tagName)) {
                for (Configuration fileChild : child.getChildren()) {
                    baseChild.addChild(fileChild);
                }
                continue;
            }
            this._mergeChildsConfiguration(child, baseChild);
        }
    }

    private void _mergeChildsConfiguration(Configuration configuration, MutableConfiguration base) throws ConfigurationException {
        String value = configuration.getValue(null);
        if (value != null) {
            base.setValue(value);
        }
        base.addAllAttributes(configuration);
        Set childrenToProcess = Arrays.stream(configuration.getChildren()).map(Configuration::getName).collect(Collectors.toSet());
        for (String childName : childrenToProcess) {
            Configuration[] newChildren;
            MutableConfiguration[] baseChildren = base.getMutableChildren(childName);
            if (baseChildren.length == (newChildren = configuration.getChildren(childName)).length) {
                for (int i = 0; i < baseChildren.length; ++i) {
                    this._mergeChildsConfiguration(newChildren[i], baseChildren[i]);
                }
                continue;
            }
            for (MutableConfiguration mutableConfiguration : baseChildren) {
                base.removeChild((Configuration)mutableConfiguration);
            }
            for (MutableConfiguration mutableConfiguration : newChildren) {
                base.addChild((Configuration)mutableConfiguration);
            }
        }
    }

    @Override
    public void initializeExtensions() throws Exception {
        Map<String, ReferencingExtension> refExtIds = this._referencingExtensions.stream().collect(Collectors.toMap(ReferencingExtension::getId, Function.identity()));
        ArrayList<String> processing = new ArrayList<String>();
        for (ReferencingExtension refExt : this._referencingExtensions) {
            this._lazyInitializeReferencingExtension(refExt, refExtIds, processing);
        }
        super.initializeExtensions();
        this._initialized = true;
    }

    private void _lazyInitializeReferencingExtension(ReferencingExtension ext, Map<String, ReferencingExtension> refExtIds, List<String> processing) throws ConfigurationException {
        if (!processing.contains(ext.getId())) {
            processing.add(ext.getId());
            if (refExtIds.containsKey(ext.getRefId())) {
                this._lazyInitializeReferencingExtension(refExtIds.get(ext.getRefId()), refExtIds, processing);
            }
            this._addReferencingExtension(ext.getId(), ext.getPluginName(), ext.getFeatureName(), ext.getConfiguration());
        }
    }

    public void registerRibbonManager(AbstractClientSideExtensionPoint<T> manager) {
        this._registeredManagers.add(manager);
    }

    public void unregisterRibbonManager(AbstractClientSideExtensionPoint<T> manager) {
        this._registeredManagers.remove(manager);
    }

    @Override
    public T getExtension(String id) {
        Object extension = (ClientSideElement)super.getExtension(id);
        if (extension == null) {
            for (AbstractClientSideExtensionPoint<T> manager : this._registeredManagers) {
                extension = manager.getExtension(id);
                if (extension == null) continue;
                return (T)extension;
            }
        }
        return (T)extension;
    }

    @Override
    public Set<String> getExtensionsIds() {
        Set<String> extensionsIds = super.getExtensionsIds();
        for (AbstractClientSideExtensionPoint<T> manager : this._registeredManagers) {
            extensionsIds.addAll(manager.getExtensionsIds());
        }
        return extensionsIds;
    }

    public List<ClientSideElement> findDependency(String pattern) {
        Object extension = this.getExtension(pattern);
        if (extension == null) {
            throw new IllegalArgumentException("Unable to find dependency with id : " + pattern + ".");
        }
        ArrayList<ClientSideElement> result = new ArrayList<ClientSideElement>();
        result.add((ClientSideElement)extension);
        return result;
    }

    private class ReferencingExtension {
        private String _id;
        private String _pluginName;
        private String _featureName;
        private Configuration _configuration;
        private String _refId;

        public ReferencingExtension(AbstractClientSideExtensionPoint abstractClientSideExtensionPoint, String id, String pluginName, String featureName, Configuration configuration) throws ConfigurationException {
            this._id = id;
            this._pluginName = pluginName;
            this._featureName = featureName;
            this._configuration = configuration;
            this._refId = configuration.getAttribute("ref-id");
        }

        public String getId() {
            return this._id;
        }

        public String getPluginName() {
            return this._pluginName;
        }

        public String getFeatureName() {
            return this._featureName;
        }

        public Configuration getConfiguration() {
            return this._configuration;
        }

        public String getRefId() {
            return this._refId;
        }
    }
}

