/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.schedule.AmetysJob;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.plugins.core.schedule.Scheduler;
import org.ametys.plugins.core.ui.log.LogManager;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.quartz.SchedulerException;

public class AddTaskClientSideElement
extends StaticClientSideElement
implements Contextualizable {
    protected Context _context;
    protected Scheduler _scheduler;
    protected LogManager _logManager;
    private String _schedulableId;
    private List<String> _logCategories;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._scheduler = (Scheduler)smanager.lookup(Scheduler.ROLE);
        this._logManager = (LogManager)smanager.lookup(LogManager.ROLE);
    }

    @Callable(rights={""})
    public List<Map<String, Object>> getEvents(Long timestamp, List<String> categories) {
        if (!this.hasRight(this.getRights(Map.of()))) {
            throw new AccessDeniedException("The user '" + String.valueOf(this._currentUserProvider.getUser()) + "' try to get logs without sufficient rights");
        }
        List<String> allowedCategories = categories.stream().filter(c -> this._logCategories.isEmpty() || this._logCategories.contains(c)).toList();
        return this._logManager.getEvents(timestamp, allowedCategories.isEmpty() ? this._logCategories : allowedCategories);
    }

    @Override
    protected String _configureClass(Configuration configuration) throws ConfigurationException {
        return "Ametys.plugins.coreui.schedule.AddTaskButtonController";
    }

    @Override
    protected Map<String, Object> configureInitialParameters(Configuration configuration) throws ConfigurationException {
        Map<String, Object> initialParameters = super.configureInitialParameters(configuration);
        this._schedulableId = (String)initialParameters.get("schedulable");
        initialParameters.put("action", this._configureClass(configuration) + ".act");
        this._logCategories = new ArrayList<String>();
        String jobLogCategory = AmetysJob.class.getName() + "$" + this._schedulableId;
        this._logCategories.add(jobLogCategory);
        if (initialParameters.containsKey("log-category")) {
            Object initialLogCategory = initialParameters.get("log-category");
            if (initialLogCategory instanceof String) {
                this._logCategories.add((String)initialLogCategory);
            } else if (initialLogCategory instanceof List) {
                this._logCategories.addAll((List)initialLogCategory);
            }
        }
        initialParameters.put("log-category", this._logCategories);
        return initialParameters;
    }

    @Override
    protected ClientSideElement.Script _configureScript(Configuration configuration) throws ConfigurationException {
        List<ClientSideElement.ScriptFile> scriptsImports = this._configureImports(configuration.getChild("scripts"));
        scriptsImports.add(new ClientSideElement.ScriptFile("/plugins/core-ui/resources/js/Ametys/plugins/coreui/schedule/AddTaskButtonController.js"));
        List<ClientSideElement.ScriptFile> cssImports = this._configureImports(configuration.getChild("css"));
        String jsClassName = this._configureClass(configuration.getChild("class"));
        Map<String, Object> initialParameters = this.configureInitialParameters(configuration);
        return new ClientSideElement.Script(this.getId(), jsClassName, scriptsImports, cssImports, initialParameters);
    }

    @Override
    protected Map<String, List<String>> _configureDependencies(Configuration configuration) throws ConfigurationException {
        Map<String, List<String>> dependencies = super._configureDependencies(configuration);
        List importDependencies = dependencies.computeIfAbsent("org.ametys.core.ui.StaticFileImportsManager", __ -> new ArrayList());
        importDependencies.add("org.ametys.core.schedule.Scheduler");
        List uitoolsDependencies = dependencies.computeIfAbsent("org.ametys.core.ui.UIToolsFactoriesManager", __ -> new ArrayList());
        uitoolsDependencies.add("uitool-server-logs");
        return dependencies;
    }

    @Override
    public Map<String, List<String>> getDependencies() {
        Request request = ContextHelper.getRequest((Context)this._context);
        String workspaceName = (String)request.getAttribute("workspaceName");
        if ("admin".equals(workspaceName)) {
            HashMap<String, List<String>> clonedDependencies = new HashMap<String, List<String>>(this._dependencies);
            ArrayList<String> uitoolsDependencies = new ArrayList<String>();
            if (clonedDependencies.containsKey("org.ametys.core.ui.UIToolsFactoriesManager")) {
                uitoolsDependencies.addAll((Collection)clonedDependencies.get("org.ametys.core.ui.UIToolsFactoriesManager"));
            }
            uitoolsDependencies.add("uitool-scheduled-tasks");
            clonedDependencies.put("org.ametys.core.ui.UIToolsFactoriesManager", uitoolsDependencies);
            return clonedDependencies;
        }
        return this._dependencies;
    }

    @Callable(rights={""})
    public Map<String, Object> add(String label, String description, String fireProcess, String cron, String schedulableId, Map<String, Object> params) throws SchedulerException {
        if (this.hasRight(this.getRights(null)) && schedulableId.equals(this._schedulableId)) {
            return this._scheduler.add(label, description, fireProcess, cron, schedulableId, params);
        }
        throw new AccessDeniedException(String.valueOf(this._currentUserProvider.getUser()) + "' tried to execute schedulable '" + schedulableId + "' without any of the following rights: " + String.valueOf(this.getRights(null)));
    }

    @Callable(rights={""})
    public Map<String, Object> getParameters(String schedulableId) throws Exception {
        if (this.hasRight(this.getRights(null)) && schedulableId.equals(this._schedulableId)) {
            return this._scheduler.getParameters(this._schedulableId);
        }
        throw new AccessDeniedException(String.valueOf(this._currentUserProvider.getUser()) + "' tried to fetch the schedulable " + this._schedulableId + " parameters without any of the following rights: " + String.valueOf(this.getRights(null)));
    }
}

