/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.plugins.core.ui.util.ConfigurationHelper;

public interface ClientSideElement {
    public String getId();

    public List<Script> getScripts(Map<String, Object> var1);

    public List<Script> getScripts(boolean var1, Map<String, Object> var2);

    public Map<String, String> getRights(Map<String, Object> var1);

    public String getPluginName();

    public Map<String, List<String>> getDependencies();

    public static class Script {
        protected String _id;
        protected String _classname;
        protected List<ScriptFile> _scriptFiles;
        protected List<ScriptFile> _cssFiles;
        protected Map<String, Object> _parameters;
        protected String _serverId;

        public Script(String id, String classname, List<ScriptFile> scriptFiles, List<ScriptFile> cssFiles, Map<String, Object> parameters) {
            this(id, id, classname, scriptFiles, cssFiles, parameters);
        }

        public Script(String id, String serverId, String classname, List<ScriptFile> scriptFiles, List<ScriptFile> cssFiles, Map<String, Object> parameters) {
            this._id = id;
            this._serverId = serverId;
            this._classname = classname;
            this._scriptFiles = scriptFiles;
            this._cssFiles = cssFiles;
            this._parameters = parameters;
        }

        public Script(Script script) {
            this._id = script._id;
            this._serverId = script._serverId;
            this._classname = script._classname;
            this._scriptFiles = new ArrayList<ScriptFile>(script._scriptFiles);
            this._cssFiles = new ArrayList<ScriptFile>(script._cssFiles);
            this._parameters = ConfigurationHelper.clonePluginParameters(script._parameters);
        }

        public String getId() {
            return this._id;
        }

        public String getServerId() {
            return this._serverId;
        }

        public String getScriptClassname() {
            return this._classname;
        }

        public List<ScriptFile> getScriptFiles() {
            return this._scriptFiles;
        }

        public List<ScriptFile> getCSSFiles() {
            return this._cssFiles;
        }

        public Map<String, Object> getParameters() {
            return this._parameters;
        }
    }

    public static class ScriptFile {
        private String _rtlMode;
        private boolean _langMode;
        private String _path;
        private Map<String, String> _langPaths;
        private String _defaultLang;

        public ScriptFile(String path) {
            this._path = path;
            this._langMode = false;
        }

        public ScriptFile(String rtl, String path) {
            this._rtlMode = rtl;
            this._path = path;
            this._langMode = false;
        }

        public ScriptFile(Map<String, String> langPaths, String defaultLang) {
            this._langPaths = langPaths;
            this._defaultLang = defaultLang;
            this._langMode = true;
        }

        public ScriptFile(ScriptFile scriptFile) {
            this._defaultLang = scriptFile._defaultLang;
            this._langMode = scriptFile._langMode;
            this._langPaths = new HashMap<String, String>();
            this._langPaths.putAll(scriptFile._langPaths);
        }

        public String getRtlMode() {
            return this._rtlMode;
        }

        public boolean isLangSpecific() {
            return this._langMode;
        }

        public String getPath() {
            return this._path;
        }

        public Map<String, String> getLangPaths() {
            return this._langPaths;
        }

        public String getDefaultLang() {
            return this._defaultLang;
        }

        public String toString() {
            return this._path;
        }
    }
}

