/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui;

import java.util.ArrayList;
import java.util.List;
import org.ametys.core.ui.AbstractClientSideExtensionPoint;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.ClientSideRelation;
import org.ametys.core.ui.MessageTargetFactoriesManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;

public class RelationsManager
extends AbstractClientSideExtensionPoint<ClientSideRelation> {
    public static final String ROLE = RelationsManager.class.getName();

    @Override
    public List<ClientSideElement> findDependency(String pattern) {
        if (!Strings.CS.startsWith((CharSequence)pattern, (CharSequence)"source:") && !Strings.CS.startsWith((CharSequence)pattern, (CharSequence)"target:")) {
            throw new IllegalArgumentException("Invalid dependency : " + pattern + ", the prefix 'source:' or 'target:' is mandatory.");
        }
        if (Strings.CS.startsWith((CharSequence)pattern, (CharSequence)"source:")) {
            return this._findSourceDependencies(StringUtils.substring((String)pattern, (int)"source:".length()));
        }
        if (Strings.CS.startsWith((CharSequence)pattern, (CharSequence)"target:")) {
            return this._findTargetDependencies(StringUtils.substring((String)pattern, (int)"target:".length()));
        }
        return null;
    }

    private List<ClientSideElement> _findSourceDependencies(String pattern) {
        ArrayList<ClientSideElement> result = new ArrayList<ClientSideElement>();
        for (String extensionId : this.getExtensionsIds()) {
            ClientSideRelation extension = (ClientSideRelation)this.getExtension(extensionId);
            if (!extension.getSourceRelationType().contains(pattern)) continue;
            result.add(extension);
        }
        result.add(this._getMessageTargetFactory(pattern));
        return result;
    }

    private List<ClientSideElement> _findTargetDependencies(String pattern) {
        ArrayList<ClientSideElement> result = new ArrayList<ClientSideElement>();
        for (String extensionId : this.getExtensionsIds()) {
            ClientSideRelation extension = (ClientSideRelation)this.getExtension(extensionId);
            if (!extension.getTargetRelationType().contains(pattern)) continue;
            result.add(extension);
        }
        ClientSideElement messageTargetFactory = this._getMessageTargetFactory(pattern);
        if (messageTargetFactory != null) {
            result.add(messageTargetFactory);
        }
        return result;
    }

    private ClientSideElement _getMessageTargetFactory(String pattern) {
        try {
            MessageTargetFactoriesManager messageTargetFactoriesManager = (MessageTargetFactoriesManager)this._cocoonManager.lookup(MessageTargetFactoriesManager.ROLE);
            return messageTargetFactoriesManager.hasExtension(pattern) ? messageTargetFactoriesManager.getExtension(pattern) : null;
        }
        catch (ServiceException e) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Unable to retrieve the MessageTargetFactoriesManager", (Throwable)e);
            }
            return null;
        }
    }
}

