/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.ui.RibbonControlsManager;
import org.ametys.core.ui.RibbonManager;
import org.ametys.core.ui.RibbonTabsManager;
import org.ametys.core.ui.ribbonconfiguration.RibbonConfiguration;
import org.ametys.core.ui.ribbonconfiguration.RibbonConfigurationSource;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.ExtensionDefinition;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginsComponentManager;
import org.ametys.runtime.plugin.component.ThreadSafeComponentManager;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.WrapperComponentManager;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.excalibur.source.SourceResolver;

public class RibbonManagerCache
extends AbstractLogEnabled
implements Contextualizable,
Serviceable,
Component,
Initializable {
    public static final String ROLE = RibbonManagerCache.class.getName();
    private Map<RibbonManager, Map<String, Long>> _ribbonManagerCacheValidity = new HashMap<RibbonManager, Map<String, Long>>();
    private Map<RibbonManager, Integer> _ribbonManagerUsageCache = new HashMap<RibbonManager, Integer>();
    private Map<RibbonManager, RibbonConfiguration> _ribbonConfigurationCache = new HashMap<RibbonManager, RibbonConfiguration>();
    private Map<RibbonManager, ThreadSafeComponentManager<Object>> _ribbonServiceManagers = new HashMap<RibbonManager, ThreadSafeComponentManager<Object>>();
    private Context _context;
    private ServiceManager _cocoonManager;
    private RibbonControlsManager _ribbonControlsManager;
    private RibbonTabsManager _ribbonTabsManager;
    private SourceResolver _resolver;
    private AbstractCacheManager _cacheManager;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._cocoonManager = manager;
        this._ribbonControlsManager = (RibbonControlsManager)manager.lookup(RibbonControlsManager.ROLE);
        this._ribbonTabsManager = (RibbonTabsManager)manager.lookup(RibbonTabsManager.ROLE);
        this._resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
    }

    public void initialize() throws Exception {
        this._cacheManager.createMemoryCache(ROLE, new I18nizableText("plugin.core", "PLUGINS_CORE_CACHE_RIBBON_MANAGER_LABEL"), new I18nizableText("plugin.core", "PLUGINS_CORE_CACHE_RIBBON_MANAGER_DESCRIPTION"), false, null);
    }

    public void invalidate() {
        this._getRibbonManagerCache().invalidateAll();
    }

    public synchronized RibbonManager getManager(String uri) throws Exception {
        RibbonManager ribbonManager = this._getRibbonManagerCache().get(uri);
        if (ribbonManager != null) {
            if (this._isRibbonManagerStillValid(ribbonManager)) {
                this._increaseUsage(ribbonManager);
                return ribbonManager;
            }
            this._ribbonManagerCacheValidity.remove(ribbonManager);
            this._decreaseUsage(ribbonManager, true);
        }
        ribbonManager = this._createRibbonManager();
        this._getRibbonManagerCache().put(uri, ribbonManager);
        this._ribbonManagerCacheValidity.put(ribbonManager, null);
        this._increaseUsage(ribbonManager);
        return ribbonManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _isRibbonManagerStillValid(RibbonManager ribbonManager) {
        Map<String, Long> validity = this._ribbonManagerCacheValidity.get(ribbonManager);
        if (validity == null) {
            return false;
        }
        for (Map.Entry<String, Long> entry : validity.entrySet()) {
            RibbonConfigurationSource ribbonConfigurationEntry = null;
            try {
                ribbonConfigurationEntry = RibbonConfigurationSource.createFromUri(entry.getKey(), this._resolver);
                if (this._isRibbonEntryStillValid(entry.getValue(), ribbonConfigurationEntry)) continue;
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (ribbonConfigurationEntry == null) continue;
                this._resolver.release(ribbonConfigurationEntry.getSource());
            }
        }
        return true;
    }

    private boolean _isRibbonEntryStillValid(Long cachedValidity, RibbonConfigurationSource ribbonEntrySource) {
        boolean entryExists = ribbonEntrySource.getSource().exists();
        if (cachedValidity == 0L && entryExists) {
            return false;
        }
        if (cachedValidity > 0L && !entryExists) {
            return false;
        }
        return ribbonEntrySource.getLastModified().equals(cachedValidity);
    }

    private RibbonManager _createRibbonManager() throws Exception {
        PluginsComponentManager ribbonServiceManager = new PluginsComponentManager((ComponentManager)new WrapperComponentManager(this._cocoonManager));
        ribbonServiceManager.contextualize(this._context);
        ribbonServiceManager.service(this._cocoonManager);
        ribbonServiceManager.setLogger(this.getLogger());
        ribbonServiceManager.addExtensionPoint("core-ui", RibbonManager.ROLE, RibbonManager.class, null, new ArrayList<ExtensionDefinition>());
        ribbonServiceManager.initialize();
        RibbonManager ribbonManager = (RibbonManager)ribbonServiceManager.lookup(RibbonManager.ROLE);
        ribbonManager.initialize();
        this._ribbonServiceManagers.put(ribbonManager, ribbonServiceManager);
        this._ribbonControlsManager.registerRibbonManager(ribbonManager);
        this._ribbonTabsManager.registerRibbonManager(ribbonManager);
        return ribbonManager;
    }

    public void dispose(RibbonManager ribbonManager) {
        if (ribbonManager != null) {
            this._decreaseUsage(ribbonManager, false);
        }
    }

    private synchronized void _increaseUsage(RibbonManager ribbonManager) {
        Integer usage = this._ribbonManagerUsageCache.get(ribbonManager);
        this._ribbonManagerUsageCache.put(ribbonManager, usage != null ? usage + 1 : 1);
    }

    private synchronized void _decreaseUsage(RibbonManager ribbonManager, boolean forceRemove) {
        Integer usage = this._ribbonManagerUsageCache.get(ribbonManager);
        if (forceRemove || usage != null) {
            if (!forceRemove && usage > 1) {
                this._ribbonManagerUsageCache.put(ribbonManager, usage - 1);
            } else {
                this._ribbonManagerUsageCache.remove(ribbonManager);
                if (!this._ribbonManagerCacheValidity.containsKey(ribbonManager)) {
                    this._ribbonConfigurationCache.remove(ribbonManager);
                    ThreadSafeComponentManager<Object> serviceManager = this._ribbonServiceManagers.get(ribbonManager);
                    this._ribbonServiceManagers.remove(ribbonManager);
                    this._ribbonControlsManager.unregisterRibbonManager(ribbonManager);
                    this._ribbonTabsManager.unregisterRibbonManager(ribbonManager);
                    serviceManager.dispose();
                }
            }
        }
    }

    public RibbonConfiguration getCachedConfiguration(RibbonManager ribbonManager) {
        return this._ribbonConfigurationCache.get(ribbonManager);
    }

    public void addCachedConfiguration(RibbonManager ribbonManager, RibbonConfiguration configuration, Map<String, Long> importsValidity) {
        this._ribbonConfigurationCache.put(ribbonManager, configuration);
        this._ribbonManagerCacheValidity.put(ribbonManager, importsValidity);
    }

    private Cache<String, RibbonManager> _getRibbonManagerCache() {
        return this._cacheManager.get(ROLE);
    }
}

