/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.MenuClientSideElement;
import org.ametys.core.ui.RibbonControlsManager;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.ThreadSafeComponentManager;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class SimpleMenu
extends StaticClientSideElement
implements MenuClientSideElement {
    protected ThreadSafeComponentManager<ClientSideElement> _menuItemManager;
    protected RibbonControlsManager _ribbonControlManager;
    protected ServiceManager _smanager;
    protected List<ClientSideElement> _menuItems;
    protected List<GalleryItem> _galleryItems;
    protected ClientSideElement _primaryMenuItem;
    protected List<UnresolvedItem> _unresolvedMenuItems;
    private ThreadSafeComponentManager<ClientSideElement> _galleryItemManager;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._smanager = smanager;
        this._ribbonControlManager = (RibbonControlsManager)smanager.lookup(RibbonControlsManager.ROLE);
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        this._menuItemManager = new ThreadSafeComponentManager();
        this._menuItemManager.setLogger(LoggerFactory.getLogger((String)"cms.plugin.threadsafecomponent"));
        this._menuItemManager.service(this._smanager);
        this._initializeGalleryItemManager();
        super.configure(configuration);
        this._galleryItems = new ArrayList<GalleryItem>();
        this._menuItems = new ArrayList<ClientSideElement>();
        this._unresolvedMenuItems = new ArrayList<UnresolvedItem>();
        this._configureGalleries(configuration);
        this._configureItemsMenu(configuration);
    }

    @Override
    protected String _configureClass(Configuration configuration) throws ConfigurationException {
        String jsClassName = configuration.getAttribute("name", "");
        if (StringUtils.isNotEmpty((CharSequence)jsClassName) && this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Js class configured is '" + jsClassName + "'");
        }
        return jsClassName;
    }

    protected void _initializeGalleryItemManager() {
        if (this._galleryItemManager != null) {
            this._galleryItemManager.dispose();
        }
        this._galleryItemManager = new ThreadSafeComponentManager();
        this._galleryItemManager.setLogger(LoggerFactory.getLogger((String)"cms.plugin.threadsafecomponent"));
        this._galleryItemManager.service(this._smanager);
    }

    protected ThreadSafeComponentManager<ClientSideElement> _getGalleryItemManager() {
        return this._galleryItemManager;
    }

    protected List<GalleryItem> _getGalleryItems() {
        return this._galleryItems;
    }

    @Override
    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        try {
            this._resolveMenuItems();
            this._resolveGalleryItems();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to lookup client side element local components", e);
        }
        if (ignoreRights || this.hasRight(this.getRights(contextParameters))) {
            List<ClientSideElement.Script> scripts = super.getScripts(ignoreRights, contextParameters);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            ArrayList<ClientSideElement.ScriptFile> cssFiles = new ArrayList<ClientSideElement.ScriptFile>();
            ArrayList<ClientSideElement.ScriptFile> scriptFiles = new ArrayList<ClientSideElement.ScriptFile>();
            for (ClientSideElement.Script script : scripts) {
                cssFiles.addAll(script.getCSSFiles());
                scriptFiles.addAll(script.getScriptFiles());
                parameters.putAll(script.getParameters());
            }
            String scriptClassName = this._script.getScriptClassname();
            if (this._primaryMenuItem != null) {
                List<ClientSideElement.Script> itemScripts = this._primaryMenuItem.getScripts(ignoreRights, contextParameters);
                for (ClientSideElement.Script script : itemScripts) {
                    Map<String, Object> primaryParameters = script.getParameters();
                    parameters.put("primary-menu-item-id", script.getId());
                    for (String paramId : primaryParameters.keySet()) {
                        if (parameters.containsKey(paramId)) continue;
                        parameters.put(paramId, primaryParameters.get(paramId));
                    }
                    if (!StringUtils.isEmpty((CharSequence)scriptClassName)) continue;
                    scriptClassName = script.getScriptClassname();
                }
            }
            if (StringUtils.isNotBlank((CharSequence)scriptClassName)) {
                this._getGalleryItems(parameters, contextParameters);
                this._getMenuItems(parameters, contextParameters);
                ArrayList<ClientSideElement.Script> result = new ArrayList<ClientSideElement.Script>();
                result.add(new ClientSideElement.Script(this.getId(), scriptClassName, scriptFiles, cssFiles, parameters));
                return result;
            }
        }
        return new ArrayList<ClientSideElement.Script>();
    }

    @Override
    public Map<String, String> getRights(Map<String, Object> contextParameters) {
        Map<String, String> rights = super.getRights(contextParameters);
        if (rights.size() == 0 && this._primaryMenuItem != null) {
            return this._primaryMenuItem.getRights(contextParameters);
        }
        return rights;
    }

    protected void _getGalleryItems(Map<String, Object> parameters, Map<String, Object> contextualParameters) {
        List<GalleryItem> galleryItems = this._getGalleryItems();
        if (galleryItems.size() > 0) {
            parameters.put("gallery-item", new LinkedHashMap());
            for (GalleryItem galleryItem : galleryItems) {
                Map galleryItemsParams = (Map)parameters.get("gallery-item");
                galleryItemsParams.put("gallery-groups", new ArrayList());
                for (GalleryGroup galleryGp : galleryItem.getGroups()) {
                    List galleryGroups = (List)galleryItemsParams.get("gallery-groups");
                    LinkedHashMap<String, Object> groupParams = new LinkedHashMap<String, Object>();
                    I18nizableText label = galleryGp.getLabel();
                    groupParams.put("label", label);
                    ArrayList<String> gpItems = new ArrayList<String>();
                    for (ClientSideElement element : galleryGp.getItems()) {
                        gpItems.add(element.getId());
                    }
                    groupParams.put("items", gpItems);
                    galleryGroups.add(groupParams);
                }
            }
        }
    }

    protected void _getMenuItems(Map<String, Object> parameters, Map<String, Object> contextualParameters) {
        if (this._menuItems.size() > 0) {
            ArrayList<String> menuItems = new ArrayList<String>();
            for (ClientSideElement element : this._menuItems) {
                menuItems.add(element.getId());
            }
            parameters.put("menu-items", menuItems);
        }
    }

    @Override
    public List<ClientSideElement> getReferencedClientSideElements(Map<String, Object> contextParameters) {
        ArrayList<ClientSideElement> result = new ArrayList<ClientSideElement>();
        if (this.hasRight(this.getRights(contextParameters))) {
            result.addAll(this._menuItems);
            this._getGalleryItems().stream().map(GalleryItem::getGroups).flatMap(Collection::stream).map(GalleryGroup::getItems).forEach(result::addAll);
        }
        return result;
    }

    protected void _configureGalleries(Configuration configuration) throws ConfigurationException {
        for (Configuration galleryConfiguration : configuration.getChildren("gallery-item")) {
            GalleryItem galleryItem = new GalleryItem(this);
            for (Configuration gpConfiguration : galleryConfiguration.getChildren("gallery-group")) {
                galleryItem.addGroup(this._configureGroupGallery(gpConfiguration));
            }
            this._galleryItems.add(galleryItem);
        }
        if (this._galleryItems.size() > 0) {
            try {
                this._getGalleryItemManager().initialize();
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to lookup parameter local components", configuration, (Throwable)e);
            }
        }
    }

    protected GalleryGroup _configureGroupGallery(Configuration configuration) throws ConfigurationException {
        Configuration labelConfig = configuration.getChild("label");
        I18nizableText label = labelConfig.getAttributeAsBoolean("i18n", false) ? new I18nizableText("plugin." + this._pluginName, labelConfig.getValue("")) : new I18nizableText(labelConfig.getValue(""));
        GalleryGroup galleryGroup = new GalleryGroup(label);
        for (Configuration itemConfig : configuration.getChildren("item")) {
            if (itemConfig.getAttribute("ref", null) != null) {
                galleryGroup.addItem(new UnresolvedItem(this, itemConfig.getAttribute("ref"), false));
                continue;
            }
            String id = itemConfig.getAttribute("id");
            DefaultConfiguration conf = new DefaultConfiguration("extension");
            conf.setAttribute("id", id);
            conf.addChild(itemConfig.getChild("class"));
            Map<String, List<String>> childDependencies = this._configureDependencies(itemConfig);
            this._addDependencies(childDependencies);
            if (itemConfig.getChild("right", false) != null) {
                conf.addChild(itemConfig.getChild("right"));
            }
            if (itemConfig.getChild("rights", false) != null) {
                conf.addChild(itemConfig.getChild("rights"));
            }
            this._getGalleryItemManager().addComponent(this._pluginName, null, id, StaticClientSideElement.class, (Configuration)conf);
            galleryGroup.addItem(new UnresolvedItem(this, id, true));
        }
        return galleryGroup;
    }

    protected void _configureItemsMenu(Configuration configuration) throws ConfigurationException {
        for (Configuration menuItemConfiguration : configuration.getChildren("menu-items")) {
            for (Configuration itemConfig : menuItemConfiguration.getChildren("item")) {
                boolean isPrimary = itemConfig.getAttributeAsBoolean("primaryItem", false);
                if (itemConfig.getAttribute("ref", null) != null) {
                    this._unresolvedMenuItems.add(new UnresolvedItem(this, itemConfig.getAttribute("ref"), false, isPrimary));
                    continue;
                }
                String id = itemConfig.getAttribute("id");
                DefaultConfiguration conf = new DefaultConfiguration("extension");
                conf.setAttribute("id", id);
                conf.addChild(itemConfig.getChild("class"));
                Map<String, List<String>> childDependencies = this._configureDependencies(itemConfig);
                this._addDependencies(childDependencies);
                if (itemConfig.getChild("menu-items", false) != null || itemConfig.getChild("gallery-item", false) != null) {
                    if (itemConfig.getChild("menu-items", false) != null) {
                        conf.addChild(itemConfig.getChild("menu-items"));
                    }
                    if (itemConfig.getChild("gallery-item", false) != null) {
                        conf.addChild(itemConfig.getChild("gallery-item"));
                    }
                    this._menuItemManager.addComponent(this._pluginName, null, id, SimpleMenu.class, (Configuration)conf);
                } else {
                    this._menuItemManager.addComponent(this._pluginName, null, id, StaticClientSideElement.class, (Configuration)conf);
                }
                this._unresolvedMenuItems.add(new UnresolvedItem(this, id, true, isPrimary));
            }
        }
    }

    private void _resolveMenuItems() throws Exception {
        if (this._unresolvedMenuItems != null) {
            this._menuItemManager.initialize();
            for (UnresolvedItem unresolvedItem : this._unresolvedMenuItems) {
                Object element;
                String id = unresolvedItem.getId();
                if (unresolvedItem.isLocalItem()) {
                    try {
                        element = this._menuItemManager.lookup(id);
                    }
                    catch (ComponentException e) {
                        throw new Exception("Unable to lookup client side element role: '" + id + "'", e);
                    }
                } else {
                    element = this._ribbonControlManager.getExtension(id);
                }
                if (unresolvedItem.isPrimary()) {
                    this._primaryMenuItem = element;
                }
                this._menuItems.add((ClientSideElement)element);
                this._addDependencies(element.getDependencies());
            }
        }
        this._unresolvedMenuItems = null;
    }

    private void _resolveGalleryItems() {
        for (GalleryItem item : this._getGalleryItems()) {
            for (GalleryGroup group : item.getGroups()) {
                group.getItems();
            }
        }
    }

    protected void _addDependencies(Map<String, List<String>> additionalDependencies) throws ConfigurationException {
        if (!additionalDependencies.isEmpty()) {
            for (Map.Entry<String, List<String>> additionalDependency : additionalDependencies.entrySet()) {
                String key = additionalDependency.getKey();
                if (!this._dependencies.containsKey(key)) {
                    this._dependencies.put(key, new ArrayList());
                }
                List dependenciesList = (List)this._dependencies.get(key);
                for (String dependency : additionalDependency.getValue()) {
                    if (dependenciesList.contains(dependency)) continue;
                    dependenciesList.add(dependency);
                }
            }
        }
    }

    public class GalleryItem {
        private final List<GalleryGroup> _groups = new ArrayList<GalleryGroup>();

        public GalleryItem(SimpleMenu this$0) {
        }

        public void addGroup(GalleryGroup group) {
            this._groups.add(group);
        }

        public List<GalleryGroup> getGroups() {
            return this._groups;
        }
    }

    public class GalleryGroup {
        private final I18nizableText _label;
        private List<UnresolvedItem> _unresolvedGalleryItems;
        private final List<ClientSideElement> _items;

        public GalleryGroup(I18nizableText label) {
            this._label = label;
            this._items = new ArrayList<ClientSideElement>();
            this._unresolvedGalleryItems = new ArrayList<UnresolvedItem>();
        }

        public void addItem(UnresolvedItem item) {
            this._unresolvedGalleryItems.add(item);
        }

        public I18nizableText getLabel() {
            return this._label;
        }

        public List<ClientSideElement> getItems() {
            try {
                this._resolveGalleryItems();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to lookup client side element local components", e);
            }
            return this._items;
        }

        private void _resolveGalleryItems() throws Exception {
            if (this._unresolvedGalleryItems != null) {
                for (UnresolvedItem unresolvedItem : this._unresolvedGalleryItems) {
                    Object element;
                    String id = unresolvedItem.getId();
                    if (unresolvedItem.isLocalItem()) {
                        try {
                            element = SimpleMenu.this._getGalleryItemManager().lookup(id);
                        }
                        catch (ComponentException e) {
                            throw new Exception("Unable to lookup client side element role: '" + id + "'", e);
                        }
                    } else {
                        element = SimpleMenu.this._ribbonControlManager.getExtension(id);
                    }
                    this._items.add((ClientSideElement)element);
                }
            }
            this._unresolvedGalleryItems = null;
        }
    }

    protected class UnresolvedItem {
        private final String _itemId;
        private final boolean _local;
        private final boolean _primary;

        public UnresolvedItem(SimpleMenu this$0, String id, boolean local) {
            this._itemId = id;
            this._local = local;
            this._primary = false;
        }

        public UnresolvedItem(SimpleMenu this$0, String id, boolean local, boolean primary) {
            this._itemId = id;
            this._local = local;
            this._primary = primary;
        }

        public String getId() {
            return this._itemId;
        }

        public boolean isLocalItem() {
            return this._local;
        }

        public boolean isPrimary() {
            return this._primary;
        }
    }
}

