/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui.dispatcher;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.dispatcher.DispatchProcessExtensionPoint;
import org.ametys.core.ui.dispatcher.DispatchRequestProcess;
import org.ametys.core.util.IgnoreRootHandler;
import org.ametys.core.util.JSONUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.core.ui.util.RequestAttributesHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.util.location.LocatedException;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DispatchGenerator
extends ServiceableGenerator {
    protected RequestAttributesHelper _requestAttributesHelper;
    protected SourceResolver _sourceResolver;
    protected DispatchProcessExtensionPoint _dispatchProcessExtensionPoint;
    protected JSONUtils _jsonUtils;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._sourceResolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
        this._dispatchProcessExtensionPoint = (DispatchProcessExtensionPoint)this.manager.lookup(DispatchProcessExtensionPoint.ROLE);
        this._jsonUtils = (JSONUtils)this.manager.lookup(JSONUtils.ROLE);
        this._requestAttributesHelper = (RequestAttributesHelper)this.manager.lookup(RequestAttributesHelper.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this._setResponseHeader();
        String requestBodyAsString = this._getRequestBody();
        Map<String, Object> requestBodyAsJson = this._jsonUtils.convertJsonToMap(requestBodyAsString);
        String contextAsString = this._getRequestContext();
        Map<String, Object> contextAsJson = this._jsonUtils.convertJsonToMap(contextAsString);
        this._dispatching(requestBodyAsJson, contextAsJson);
    }

    protected void _setResponseHeader() {
        ObjectModelHelper.getResponse((Map)this.objectModel).addHeader("Ametys-Dispatched", "true");
    }

    protected String _getRequestBody() {
        return ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("content");
    }

    protected String _getRequestContext() {
        return ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("context.parameters");
    }

    protected void _dispatching(Map<String, Object> requestBody, Map<String, Object> contextAsMap) throws SAXException {
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"responses");
        Map<String, Object> attributes = this._requestAttributesHelper.saveRequestAttributes();
        contextAsMap.putAll(this.transmitAttributes(attributes));
        HashMap<String, Long> times = new HashMap<String, Long>();
        for (String parameterKey : requestBody.keySet()) {
            Map subRequestParameters = (Map)requestBody.get(parameterKey);
            long time = this._dispatchingSubRequest(subRequestParameters, contextAsMap, parameterKey);
            times.put(parameterKey, time);
        }
        this._requestAttributesHelper.restoreRequestAttributes(attributes);
        this._saxMeasuredTimes(times);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"responses");
        this.contentHandler.endDocument();
    }

    protected void _saxMeasuredTimes(Map<String, Long> times) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("duration", Long.toString(times.values().stream().mapToLong(Long::longValue).sum()));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"times", (Attributes)attrs);
        for (String parameterKey : times.keySet()) {
            AttributesImpl internalAttrs = new AttributesImpl();
            internalAttrs.addCDATAAttribute("id", parameterKey);
            internalAttrs.addCDATAAttribute("duration", Long.toString(times.get(parameterKey)));
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"time", (Attributes)internalAttrs);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"times");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long _dispatchingSubRequest(Map<String, Object> parametersAsMap, Map<String, Object> contextAsMap, String parameterKey) throws SAXException {
        DispatchRequestProcess processor;
        long t0 = System.currentTimeMillis();
        this._removeRequestAttributes();
        for (String extension : this._dispatchProcessExtensionPoint.getExtensionsIds()) {
            DispatchRequestProcess processor2 = (DispatchRequestProcess)this._dispatchProcessExtensionPoint.getExtension(extension);
            processor2.preProcess(ObjectModelHelper.getRequest((Map)this.objectModel));
        }
        this._setContextInRequestAttributes(contextAsMap);
        String pluginOrWorkspace = (String)parametersAsMap.get("pluginOrWorkspace");
        String relativeUrl = (String)parametersAsMap.get("url");
        String responseType = (String)parametersAsMap.get("responseType");
        Map requestParameters = (Map)parametersAsMap.get("parameters");
        this._handleFiles(requestParameters, parameterKey);
        Source response = null;
        ResponseHandler responseHandler = null;
        try {
            String url = this._createUrl(pluginOrWorkspace, relativeUrl, requestParameters != null ? requestParameters : new HashMap());
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Dispatching url '" + (String)url + "'");
            }
            response = this._sourceResolver.resolveURI(url, null, requestParameters);
            responseHandler = new ResponseHandler(this.contentHandler, parameterKey, "200");
            this._handleResponse(response, responseType, responseHandler);
        }
        catch (Throwable e) {
            try {
                String message = String.format("Can not dispatch request '%s' : '%s' '%s' '%s'", parameterKey, pluginOrWorkspace, relativeUrl, requestParameters);
                this._handleError(responseHandler, parameterKey, message, e);
            }
            catch (Throwable throwable) {
                this._sourceResolver.release(response);
                for (String extension : this._dispatchProcessExtensionPoint.getExtensionsIds()) {
                    DispatchRequestProcess processor3 = (DispatchRequestProcess)this._dispatchProcessExtensionPoint.getExtension(extension);
                    processor3.postProcess(ObjectModelHelper.getRequest((Map)this.objectModel));
                }
                throw throwable;
            }
            this._sourceResolver.release(response);
            for (String extension : this._dispatchProcessExtensionPoint.getExtensionsIds()) {
                processor = (DispatchRequestProcess)this._dispatchProcessExtensionPoint.getExtension(extension);
                processor.postProcess(ObjectModelHelper.getRequest((Map)this.objectModel));
            }
        }
        this._sourceResolver.release(response);
        for (String extension : this._dispatchProcessExtensionPoint.getExtensionsIds()) {
            processor = (DispatchRequestProcess)this._dispatchProcessExtensionPoint.getExtension(extension);
            processor.postProcess(ObjectModelHelper.getRequest((Map)this.objectModel));
        }
        long t1 = System.currentTimeMillis();
        long time = t1 - t0;
        this.getLogger().debug("Request '" + parameterKey + "' took " + time + "ms");
        return time;
    }

    protected void _removeRequestAttributes() {
        this._requestAttributesHelper.removeRequestAttributes();
    }

    protected void _handleResponse(Source response, String responseType, ResponseHandler responseHandler) throws IOException, SAXException, ProcessingException {
        block13: {
            try (InputStream is = response.getInputStream();){
                if ("xml".equalsIgnoreCase(responseType)) {
                    SAXParser saxParser = null;
                    try {
                        saxParser = (SAXParser)this.manager.lookup(SAXParser.ROLE);
                        saxParser.parse(new InputSource(is), (ContentHandler)((Object)responseHandler));
                        break block13;
                    }
                    catch (ServiceException e) {
                        throw new ProcessingException("Unable to get a SAX parser", (Throwable)e);
                    }
                    finally {
                        this.manager.release((Object)saxParser);
                    }
                }
                responseHandler.startDocument();
                String data = IOUtils.toString((InputStream)is, (String)"UTF-8");
                if ("xml2text".equalsIgnoreCase(responseType)) {
                    data = data.substring(data.indexOf(">", data.indexOf("?>") + 2) + 1, data.lastIndexOf("<"));
                }
                XMLUtils.data((ContentHandler)((Object)responseHandler), (String)data);
                responseHandler.endDocument();
            }
        }
    }

    protected void _handleError(ResponseHandler responseHandler, String parameterKey, String message, Throwable e) throws SAXException {
        this.getLogger().error(message, (Throwable)new LocatedException(message, e));
        if (responseHandler != null) {
            responseHandler.exceptionFinish();
        }
        Throwable t = this._unroll(e);
        String code = "500";
        if (t instanceof ResourceNotFoundException || t.toString().startsWith("org.apache.cocoon.ResourceNotFoundException:")) {
            code = "404";
        }
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", parameterKey);
        attrs.addCDATAAttribute("code", code);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"response", (Attributes)attrs);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"message", (String)this._escape(this._exceptionToMessageInformation(t)));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"stacktrace", (String)this._escape(this._exceptionToStackTraceInformation(t)));
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"response");
    }

    protected void _handleFiles(Map<String, Object> params, String parameterKey) {
        Map<String, Object> uploadedFiles = this._extractFiles(parameterKey);
        if (!uploadedFiles.isEmpty()) {
            block0: for (Map.Entry<String, Object> entry : uploadedFiles.entrySet()) {
                Object parent = params;
                String[] cursors = StringUtils.split((String)entry.getKey(), (String)".");
                for (int i = 0; i < cursors.length; ++i) {
                    String cursor = cursors[i];
                    if (parent instanceof Map) {
                        Map<String, Object> parentMap = parent;
                        if (i == cursors.length - 1) {
                            parentMap.put(cursor, entry.getValue());
                            continue;
                        }
                        parent = parentMap.get(cursor);
                        continue;
                    }
                    if (parent instanceof List) {
                        List parentList = (List)parent;
                        int cursorIndex = Integer.parseInt(cursor);
                        if (i == cursors.length - 1) {
                            parentList.remove(cursorIndex);
                            parentList.add(cursorIndex, entry.getValue());
                            continue;
                        }
                        parent = parentList.get(cursorIndex);
                        continue;
                    }
                    this.getLogger().warn("Cannot replace files in objects that are not java.util.List nor java.util.Map: " + parent.getClass().getName());
                    continue block0;
                }
            }
        }
    }

    private Map<String, Object> _extractFiles(String index) {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        HashMap<String, Object> files = new HashMap<String, Object>();
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (!paramName.startsWith("request#" + index + "#")) continue;
            files.put(Strings.CS.removeStart(paramName, (CharSequence)("request#" + index + "#")), request.get(paramName));
        }
        return files;
    }

    protected Map<String, Object> transmitAttributes(Map<String, Object> attributes) {
        String[] attributesToTransmit;
        HashMap<String, Object> contextAsMap = new HashMap<String, Object>();
        for (String attributeToTransmit : attributesToTransmit = new String[]{"Runtime:RequestAuthenticated", "inWorkspaceURL", "workspaceName", "workspaceTheme", "workspaceThemeURL", "workspaceURI"}) {
            contextAsMap.put(attributeToTransmit, attributes.get(attributeToTransmit));
        }
        return contextAsMap;
    }

    private Throwable _unroll(Throwable initial) {
        Throwable t = initial;
        while (t.getCause() != null || t instanceof SAXException && ((SAXException)t).getException() != null) {
            if (t instanceof SAXException) {
                t = ((SAXException)t).getException();
                continue;
            }
            t = t.getCause();
        }
        return t;
    }

    protected void _setContextInRequestAttributes(Map<String, Object> contextAsMap) {
        if (contextAsMap != null) {
            Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
            contextAsMap.forEach((name, value) -> request.setAttribute(name, value));
        }
    }

    protected String _exceptionToStackTraceInformation(Throwable t) {
        return ExceptionUtils.getStackTrace((Throwable)t);
    }

    protected String _exceptionToMessageInformation(Throwable t) {
        return StringUtils.defaultString((String)t.getMessage());
    }

    private String _escape(String value) {
        return value.replaceAll("&", "&amp;").replaceAll("<", "&lt;".replaceAll(">", "&gt;"));
    }

    protected String _createUrl(String pluginOrWorkspace, String relativeUrl, Map<String, Object> requestParameters) {
        StringBuilder url;
        block5: {
            String[] queryParameters;
            int queryIndex;
            block4: {
                url = new StringBuilder();
                String urlPrefix = this._getUrlPrefix(pluginOrWorkspace);
                url.append(urlPrefix);
                url.append(this._getRelativePath(relativeUrl));
                queryIndex = relativeUrl.indexOf("?");
                if (queryIndex != -1 || requestParameters.isEmpty()) break block4;
                url.append("?");
                for (String key : requestParameters.keySet()) {
                    Object value = requestParameters.get(key);
                    if (value instanceof List) {
                        List valueAsList = (List)value;
                        for (Object v : valueAsList) {
                            if (v == null) continue;
                            url.append((CharSequence)this._buildQueryParameter(key, v));
                        }
                        continue;
                    }
                    if (value == null) continue;
                    url.append((CharSequence)this._buildQueryParameter(key, value));
                }
                break block5;
            }
            if (queryIndex <= 0) break block5;
            url.append("?");
            String queryUrl = relativeUrl.substring(queryIndex + 1, relativeUrl.length());
            for (String queryParameter : queryParameters = queryUrl.split("&")) {
                if (!StringUtils.isNotBlank((CharSequence)queryParameter)) continue;
                String[] part = queryParameter.split("=");
                String key = part[0];
                String v = part.length > 1 ? part[1] : "";
                String value = URIUtils.decode(v);
                url.append((CharSequence)this._buildQueryParameter(key, value));
                if (requestParameters.containsKey(key)) continue;
                requestParameters.put(key, value);
            }
        }
        return url.toString();
    }

    private String _getRelativePath(String url) {
        int beginIndex = url.length() != 0 && url.charAt(0) == '/' ? 1 : 0;
        int endIndex = url.indexOf("?");
        return endIndex == -1 ? url.substring(beginIndex) : url.substring(beginIndex, endIndex);
    }

    private StringBuilder _buildQueryParameter(String key, Object value) {
        StringBuilder queryParameter = new StringBuilder();
        queryParameter.append(key);
        queryParameter.append("=");
        queryParameter.append(String.valueOf(value).replaceAll("%", "%25").replaceAll("=", "%3D").replaceAll("&", "%26").replaceAll("\\+", "%2B"));
        queryParameter.append("&");
        return queryParameter;
    }

    protected String _getUrlPrefix(String pluginOrWorkspace) {
        StringBuffer url = new StringBuffer("cocoon://");
        if (pluginOrWorkspace != null && !pluginOrWorkspace.startsWith("_")) {
            url.append("_plugins/");
            url.append(pluginOrWorkspace);
            url.append("/");
        } else if (pluginOrWorkspace != null) {
            url.append(pluginOrWorkspace);
            url.append("/");
        }
        return url.toString();
    }

    public static class ResponseHandler
    extends IgnoreRootHandler {
        private final String _parameterKey;
        private final ContentHandler _handler;
        private final String _code;
        private final List<String> _startedElements;

        public ResponseHandler(ContentHandler handler, String parameterKey, String code) {
            super(handler);
            this._handler = handler;
            this._parameterKey = parameterKey;
            this._code = code;
            this._startedElements = new ArrayList<String>();
        }

        public void exceptionFinish() throws SAXException {
            while (this._startedElements.size() > 0) {
                XMLUtils.endElement((ContentHandler)this._handler, (String)this._startedElements.get(this._startedElements.size() - 1));
                this._startedElements.remove(this._startedElements.size() - 1);
            }
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", this._parameterKey);
            attrs.addCDATAAttribute("code", this._code);
            XMLUtils.startElement((ContentHandler)this._handler, (String)"response", (Attributes)attrs);
            this._startedElements.add("response");
        }

        public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
            super.startElement(uri, loc, raw, a);
            this._startedElements.add(loc);
        }

        public void endElement(String uri, String loc, String raw) throws SAXException {
            super.endElement(uri, loc, raw);
            if (!Strings.CS.equals(this._startedElements.get(this._startedElements.size() - 1), loc)) {
                throw new SAXException("Sax events are not consistents. Cannot close <" + loc + "> while it should be <" + this._startedElements.get(this._startedElements.size() - 1) + ">");
            }
            this._startedElements.remove(this._startedElements.size() - 1);
        }

        @Override
        public void endDocument() throws SAXException {
            XMLUtils.endElement((ContentHandler)this._handler, (String)"response");
            if (this._startedElements.size() != 1) {
                throw new SAXException("Sax events are not consistents. Remaining " + this._startedElements.size() + " events (should be one).");
            }
            this._startedElements.remove(this._startedElements.size() - 1);
            super.endDocument();
        }
    }
}

