/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui.mail;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.ametys.core.cocoon.ActionResultGenerator;
import org.ametys.core.user.User;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.language.LocaleHelper;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class StandardMailBodyHelper
implements Contextualizable,
Serviceable,
Initializable {
    public static final I18nizableText AUTOGENERATED_MAIL_TEXT = new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_MAIL_AUTOGENERATED_TEXT");
    public static final I18nizableText AUTOGENERATED_DO_NOT_ANSWER_TEXT = new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_MAIL_AUTOGENERATED_DO_NOT_ANSWER_TEXT");
    protected static Context _context;
    protected static UserHelper _userHelper;
    private static SourceResolver _srcResolver;
    private static StandardMailBodyHelper _instance;
    private static LocaleHelper _localeHelper;

    public void contextualize(Context context) {
        _context = context;
    }

    public void initialize() throws Exception {
        _instance = this;
    }

    public void service(ServiceManager manager) throws ServiceException {
        _srcResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        _userHelper = (UserHelper)manager.lookup(UserHelper.ROLE);
        _localeHelper = (LocaleHelper)manager.lookup(LocaleHelper.ROLE);
    }

    public String getMailBodyUri() {
        return "cocoon://_plugins/core-ui/wrapped-mail/standard/body.html";
    }

    public static MailBodyBuilder newHTMLBody() {
        return new MailBodyBuilder(_instance.getMailBodyUri());
    }

    public static class MailBodyBuilder {
        private Object _title;
        private List<Object> _messages;
        private I18nizableText _linkText;
        private String _linkUrl;
        private I18nizableText _footerLinkText;
        private String _footerLinkUrl;
        private String _footerImgPluginName;
        private String _footerImgPath;
        private Object _footerBottomText;
        private List<UserInputsSection> _userInputsSections;
        private List<UnauthenticatedUserInputsSection> _unauthenticatedUserInputsSections;
        private I18nizableText _detailsTitle;
        private Object _detailsText;
        private boolean _technicalDetails;
        private String _lang;
        private String _uri;

        MailBodyBuilder(String uri) {
            this._uri = uri;
        }

        public MailBodyBuilder withLanguage(String lang) {
            this._lang = lang;
            return this;
        }

        public MailBodyBuilder withTitle(I18nizableText title) {
            this._title = title;
            return this;
        }

        public MailBodyBuilder withTitle(String title) {
            this._title = title;
            return this;
        }

        public MailBodyBuilder withMessage(I18nizableText message) {
            this._messages = List.of(message);
            return this;
        }

        public MailBodyBuilder withMessage(String message) {
            this._messages = List.of(this._text2html(message));
            return this;
        }

        public MailBodyBuilder addMessage(I18nizableText message) {
            if (this._messages == null) {
                this._messages = new ArrayList<Object>();
            }
            this._messages.add(message);
            return this;
        }

        public MailBodyBuilder addMessage(String message) {
            if (this._messages == null) {
                this._messages = new ArrayList<Object>();
            }
            this._messages.add(this._text2html(message));
            return this;
        }

        public MailBodyBuilder withLink(String linkUrl, I18nizableText linkText) {
            this._linkText = linkText;
            this._linkUrl = linkUrl;
            return this;
        }

        public MailBodyBuilder withFooterLink(String linkUrl, I18nizableText linkText) {
            return this.withFooterLink(linkUrl, linkText, null, null);
        }

        public MailBodyBuilder withFooterLink(String linkUrl, I18nizableText linkText, String imgPluginName, String imgPath) {
            this._footerLinkText = linkText;
            this._footerLinkUrl = linkUrl;
            this._footerImgPluginName = imgPluginName;
            this._footerImgPath = imgPath;
            return this;
        }

        public MailBodyBuilder withFooterBottomText(String footerText) {
            this._footerBottomText = this._text2html(footerText);
            return this;
        }

        public MailBodyBuilder withFooterBottomText(I18nizableText footerText) {
            this._footerBottomText = footerText;
            return this;
        }

        public MailBodyBuilder withUserInputs(List<UserInput> userInputs) {
            this._userInputsSections = new ArrayList<UserInputsSection>();
            this._userInputsSections.add(new UserInputsSection(userInputs, null));
            return this;
        }

        public MailBodyBuilder withUserInputs(List<UserInput> userInputs, I18nizableText userInputHeader) {
            this._userInputsSections = new ArrayList<UserInputsSection>();
            this._userInputsSections.add(new UserInputsSection(userInputs, userInputHeader));
            return this;
        }

        public MailBodyBuilder addUserInputs(List<UserInput> userInputs) {
            if (this._userInputsSections == null) {
                this._userInputsSections = new ArrayList<UserInputsSection>();
            }
            this._userInputsSections.add(new UserInputsSection(userInputs, null));
            return this;
        }

        public MailBodyBuilder addUserInputs(List<UserInput> userInputs, I18nizableText userInputHeader) {
            if (this._userInputsSections == null) {
                this._userInputsSections = new ArrayList<UserInputsSection>();
            }
            this._userInputsSections.add(new UserInputsSection(userInputs, userInputHeader));
            return this;
        }

        public MailBodyBuilder withUnauthenticatedUserInputs(List<UnauthenticatedUserInput> unauthenticatedUserInputs) {
            this._unauthenticatedUserInputsSections = new ArrayList<UnauthenticatedUserInputsSection>();
            this._unauthenticatedUserInputsSections.add(new UnauthenticatedUserInputsSection(unauthenticatedUserInputs, null));
            return this;
        }

        public MailBodyBuilder withUnauthenticatedUserInputs(List<UnauthenticatedUserInput> unauthenticatedUserInputs, I18nizableText userInputHeader) {
            this._unauthenticatedUserInputsSections = new ArrayList<UnauthenticatedUserInputsSection>();
            this._unauthenticatedUserInputsSections.add(new UnauthenticatedUserInputsSection(unauthenticatedUserInputs, null));
            return this;
        }

        public MailBodyBuilder addUnauthenticatedUserInput(List<UnauthenticatedUserInput> unauthenticatedUserInputs) {
            if (this._unauthenticatedUserInputsSections == null) {
                this._unauthenticatedUserInputsSections = new ArrayList<UnauthenticatedUserInputsSection>();
            }
            this._unauthenticatedUserInputsSections.add(new UnauthenticatedUserInputsSection(unauthenticatedUserInputs, null));
            return this;
        }

        public MailBodyBuilder addUnauthenticatedUserInput(List<UnauthenticatedUserInput> unauthenticatedUserInputs, I18nizableText userInputHeader) {
            if (this._unauthenticatedUserInputsSections == null) {
                this._unauthenticatedUserInputsSections = new ArrayList<UnauthenticatedUserInputsSection>();
            }
            this._unauthenticatedUserInputsSections.add(new UnauthenticatedUserInputsSection(unauthenticatedUserInputs, userInputHeader));
            return this;
        }

        public MailBodyBuilder withDetails(I18nizableText detailsTitle, String detailsText, boolean technical) {
            this._detailsTitle = detailsTitle;
            this._detailsText = this._text2html(detailsText);
            this._technicalDetails = technical;
            return this;
        }

        public MailBodyBuilder withDetails(I18nizableText detailsTitle, I18nizableText detailsText, boolean technical) {
            this._detailsTitle = detailsTitle;
            this._detailsText = detailsText;
            this._technicalDetails = technical;
            return this;
        }

        private String _text2html(String text) {
            return text.replaceAll("\n", "<br/>");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String build() throws IOException {
            String string;
            Source src = null;
            Request request = ContextHelper.getRequest((Context)_context);
            Object pluginName = request.getAttribute("pluginName");
            Object requestAttr = request.getAttribute(ActionResultGenerator.MAP_REQUEST_ATTR);
            try {
                request.setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, this.toJson());
                HashMap<String, String> parameters = new HashMap<String, String>();
                if (StringUtils.isEmpty((CharSequence)this._lang)) {
                    Map objectModel = ContextHelper.getObjectModel((Context)_context);
                    Locale locale = _localeHelper.findLocale(objectModel);
                    parameters.put("lang", locale.toString());
                } else {
                    parameters.put("lang", this._lang);
                }
                src = _srcResolver.resolveURI(this._uri, null, parameters);
                InputStreamReader reader = new InputStreamReader(src.getInputStream(), StandardCharsets.UTF_8);
                string = IOUtils.toString((Reader)reader);
            }
            catch (Throwable throwable) {
                request.setAttribute("pluginName", pluginName);
                request.setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, requestAttr);
                _srcResolver.release(src);
                throw throwable;
            }
            request.setAttribute("pluginName", pluginName);
            request.setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, requestAttr);
            _srcResolver.release(src);
            return string;
        }

        public Map<String, Object> toJson() {
            HashMap<String, Object> json = new HashMap<String, Object>();
            json.put("title", this._title);
            if (this._messages != null && !this._messages.isEmpty()) {
                json.put("message", this._messages);
            }
            if (StringUtils.isNotEmpty((CharSequence)this._linkUrl)) {
                json.put("link", Map.of("url", this._linkUrl, "text", this._linkText));
            }
            if (this._userInputsSections != null) {
                json.put("userInputsSections", this._userInputsSections.stream().map(this::_userInputSection2json).toList());
            }
            if (this._unauthenticatedUserInputsSections != null) {
                json.put("unauthenticatedUserInputsSections", this._unauthenticatedUserInputsSections.stream().map(this::_unauthenticatedUserInputSection2json).toList());
            }
            if (this._detailsText != null) {
                json.put("details", this._details2json());
            }
            json.put("footer", this._footer2json());
            return json;
        }

        private Map<String, Object> _footer2json() {
            HashMap<String, Object> footer2json = new HashMap<String, Object>();
            if (this._footerLinkUrl != null && this._footerLinkText != null) {
                HashMap<String, Object> link2json = new HashMap<String, Object>();
                link2json.put("text", this._footerLinkText);
                link2json.put("url", this._footerLinkUrl);
                if (this._footerImgPath != null && this._footerImgPluginName != null) {
                    link2json.put("imgPluginName", this._footerImgPluginName);
                    link2json.put("imgPath", this._footerImgPath);
                }
                footer2json.put("link", link2json);
            }
            if (this._footerBottomText != null) {
                footer2json.put("additionalText", this._footerBottomText);
            }
            return footer2json;
        }

        private Map<String, Object> _details2json() {
            HashMap<String, Object> details2json = new HashMap<String, Object>();
            if (this._detailsText != null) {
                if (this._detailsTitle != null) {
                    details2json.put("title", this._detailsTitle);
                }
                details2json.put("text", this._detailsText);
                details2json.put("technical", this._technicalDetails);
            }
            return details2json;
        }

        private Map<String, Object> _userInputSection2json(UserInputsSection userInputsSection) {
            HashMap<String, Object> json = new HashMap<String, Object>();
            if (userInputsSection.userInputHeader() != null) {
                json.put("userInputHeader", userInputsSection.userInputHeader());
            }
            json.put("userInput", userInputsSection.userInputs().stream().map(this::_userInput2json).toList());
            return json;
        }

        private Map<String, Object> _userInput2json(UserInput userInput) {
            HashMap<String, Object> input2json = new HashMap<String, Object>();
            input2json.put("author", _userHelper.user2json(userInput.author()));
            input2json.put("date", DateUtils.zonedDateTimeToString(userInput.date()));
            input2json.put("description", userInput.description());
            return input2json;
        }

        private Map<String, Object> _unauthenticatedUserInputSection2json(UnauthenticatedUserInputsSection userInputsSection) {
            HashMap<String, Object> json = new HashMap<String, Object>();
            if (userInputsSection.userInputHeader() != null) {
                json.put("userInputHeader", userInputsSection.userInputHeader());
            }
            json.put("unauthenticatedUserInput", userInputsSection.userInputs().stream().map(this::unauthenticatedUserAction2json).toList());
            return json;
        }

        private Map<String, Object> unauthenticatedUserAction2json(UnauthenticatedUserInput unauthenticatedUserInput) {
            HashMap<String, Object> input2json = new HashMap<String, Object>();
            input2json.put("authorName", unauthenticatedUserInput.authorName());
            input2json.put("date", DateUtils.zonedDateTimeToString(unauthenticatedUserInput.date()));
            input2json.put("description", unauthenticatedUserInput.description());
            return input2json;
        }

        public record UserInputsSection(List<UserInput> userInputs, I18nizableText userInputHeader) {
        }

        public record UnauthenticatedUserInputsSection(List<UnauthenticatedUserInput> userInputs, I18nizableText userInputHeader) {
        }

        public record UserInput(User author, ZonedDateTime date, Object description) {
        }

        public record UnauthenticatedUserInput(String authorName, ZonedDateTime date, Object description) {
        }
    }
}

