/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui.ribbonconfiguration;

import java.util.Collection;
import java.util.Set;
import org.ametys.core.ui.RibbonManager;
import org.ametys.core.ui.ribbonconfiguration.Element;
import org.ametys.core.ui.ribbonconfiguration.GroupSize;
import org.ametys.core.ui.ribbonconfiguration.RibbonElementsInjectionHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Group {
    protected I18nizableText _label;
    protected String _icon;
    protected String _iconGlyph;
    protected int _priority;
    protected String _dialogBoxLauncher;
    protected GroupSize _largeSize;
    protected GroupSize _mediumSize;
    protected GroupSize _smallSize;
    protected Boolean _override;
    protected String _order;
    protected String _controlsOrder;
    protected RibbonElementsInjectionHelper<Element> _largeOverrideHelper;
    protected RibbonElementsInjectionHelper<Element> _mediumOverrideHelper;
    protected RibbonElementsInjectionHelper<Element> _smallOverrideHelper;
    protected Logger _groupLogger;

    public Group(Configuration groupConfiguration, RibbonManager ribbonManager, Logger logger) throws ConfigurationException {
        this._groupLogger = logger;
        this._dialogBoxLauncher = groupConfiguration.getAttribute("dialog-box-launcher", "");
        this._priority = groupConfiguration.getAttributeAsInteger("priority", 0);
        this._configureLabelAndIcon(groupConfiguration);
        this._configureSize(groupConfiguration, ribbonManager);
        this._configureOverride(groupConfiguration);
    }

    public Group(Logger logger) {
        this._groupLogger = logger;
    }

    public Group(Group ribbonGroup) {
        this._label = ribbonGroup._label;
        this._icon = ribbonGroup._icon;
        this._iconGlyph = ribbonGroup._iconGlyph;
        this._priority = ribbonGroup._priority;
        this._groupLogger = ribbonGroup._groupLogger;
        this._dialogBoxLauncher = ribbonGroup._dialogBoxLauncher;
        this._override = ribbonGroup._override;
        this._order = ribbonGroup._order;
        this._controlsOrder = ribbonGroup._controlsOrder;
        this._largeSize = new GroupSize(this._groupLogger);
        this._mediumSize = new GroupSize(this._groupLogger);
        this._smallSize = new GroupSize(this._groupLogger);
    }

    protected void _configureLabelAndIcon(Configuration groupConfiguration) throws ConfigurationException {
        this._label = new I18nizableText("application", groupConfiguration.getAttribute("label"));
        if (this._groupLogger.isDebugEnabled()) {
            this._groupLogger.debug("Group label is " + String.valueOf(this._label));
        }
        this._icon = groupConfiguration.getAttribute("icon", "");
        if (this._groupLogger.isDebugEnabled()) {
            this._groupLogger.debug("Group icon is " + this._icon);
        }
        this._iconGlyph = groupConfiguration.getAttribute("iconGlyph", "");
        if (this._groupLogger.isDebugEnabled()) {
            this._groupLogger.debug("Group glyph is " + this._iconGlyph);
        }
    }

    protected void _configureSize(Configuration groupConfiguration, RibbonManager ribbonManager) throws ConfigurationException {
        if (groupConfiguration.getChild("medium").getChildren().length > 0) {
            this._largeSize = groupConfiguration.getChild("large", false) != null ? new GroupSize(groupConfiguration.getChild("large"), ribbonManager, this._groupLogger) : null;
            this._mediumSize = new GroupSize(groupConfiguration.getChild("medium"), ribbonManager, this._groupLogger);
        } else {
            this._largeSize = new GroupSize(groupConfiguration.getChild("large", false) != null ? groupConfiguration.getChild("large") : groupConfiguration, ribbonManager, this._groupLogger);
            this._mediumSize = null;
        }
        this._smallSize = groupConfiguration.getChild("small", false) != null ? new GroupSize(groupConfiguration.getChild("small"), ribbonManager, this._groupLogger) : null;
        this._checkSizeConsistency(groupConfiguration);
    }

    private void _checkSizeConsistency(Configuration groupConfiguration) throws ConfigurationException {
        if (this._mediumSize != null) {
            Collection disjunction;
            Set<String> mediumControlIds = this._mediumSize.getControlIds();
            if (this._smallSize != null && this._smallSize.getControlIds().size() > 0 && (disjunction = CollectionUtils.disjunction(this._smallSize.getControlIds(), mediumControlIds)).size() > 0) {
                String disjunctionAdString = StringUtils.join((Iterable)disjunction, (String)", ");
                throw new ConfigurationException("The small configuration of the group does not have the same elements as the medium one (" + disjunctionAdString + ")", groupConfiguration);
            }
            if (this._largeSize != null && this._largeSize.getControlIds().size() > 0 && (disjunction = CollectionUtils.disjunction(this._largeSize.getControlIds(), mediumControlIds)).size() > 0) {
                String disjunctionAdString = StringUtils.join((Iterable)disjunction, (String)", ");
                throw new ConfigurationException("The large configuration of the group does not have the same elements as the medium one (" + disjunctionAdString + ")", groupConfiguration);
            }
        }
    }

    private void _configureOverride(Configuration groupConfiguration) {
        this._override = groupConfiguration.getAttributeAsBoolean("override", false);
        this._order = groupConfiguration.getAttribute("order", "0");
        this._controlsOrder = groupConfiguration.getAttribute("controlsOrder", "0");
    }

    public boolean isEmpty() {
        return this._mediumSize == null || this._mediumSize.getControlIds().size() <= 0;
    }

    public GroupSize getLargeGroupSize() {
        return this._largeSize;
    }

    public GroupSize getMediumGroupSize() {
        return this._mediumSize;
    }

    public GroupSize getSmallGroupSize() {
        return this._smallSize;
    }

    public boolean isOverride() {
        return this._override;
    }

    public String getOrder() {
        return this._order;
    }

    public void injectGroup(Group group) {
        if (this._largeSize != null) {
            if (this._largeOverrideHelper == null) {
                this._largeOverrideHelper = new RibbonElementsInjectionHelper<Element>(this._largeSize.getChildren(), this._groupLogger);
            }
            this.injectGroup(group, this._largeOverrideHelper, group.getLargeGroupSize(), group.getMediumGroupSize(), null);
        }
        if (this._mediumSize != null) {
            if (this._mediumOverrideHelper == null) {
                this._mediumOverrideHelper = new RibbonElementsInjectionHelper<Element>(this._mediumSize.getChildren(), this._groupLogger);
            }
            this.injectGroup(group, this._mediumOverrideHelper, group.getMediumGroupSize(), group.getLargeGroupSize(), null);
        }
        if (this._smallSize != null) {
            if (this._smallOverrideHelper == null) {
                this._smallOverrideHelper = new RibbonElementsInjectionHelper<Element>(this._smallSize.getChildren(), this._groupLogger);
            }
            this.injectGroup(group, this._smallOverrideHelper, group.getSmallGroupSize(), group.getMediumGroupSize(), group.getLargeGroupSize());
        }
    }

    private void injectGroup(Group group, RibbonElementsInjectionHelper<Element> overrideHelper, GroupSize fromSizeFirst, GroupSize fromSizeSecond, GroupSize fromSizeThird) {
        GroupSize fromSize = null;
        fromSize = fromSizeFirst != null ? fromSizeFirst : (fromSizeSecond != null ? fromSizeSecond : fromSizeThird);
        if (fromSize != null) {
            for (Element element : fromSize.getChildren()) {
                overrideHelper.injectElements(element, group._controlsOrder);
            }
        }
    }

    public void toSAX(ContentHandler handler) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("icon", this._icon);
        attrs.addCDATAAttribute("iconGlyph", this._iconGlyph);
        attrs.addCDATAAttribute("priority", Integer.toString(this._priority));
        attrs.addCDATAAttribute("label", this._label.getCatalogue() + ":" + this._label.getKey());
        if (!StringUtils.isEmpty((CharSequence)this._dialogBoxLauncher)) {
            attrs.addCDATAAttribute("dialog-box-launcher", this._dialogBoxLauncher);
        }
        attrs.addCDATAAttribute("http://apache.org/cocoon/i18n/2.1", "attr", "label");
        XMLUtils.startElement((ContentHandler)handler, (String)"group", (Attributes)attrs);
        this._largeSize.toSAX("large", handler);
        this._mediumSize.toSAX("medium", handler);
        this._smallSize.toSAX("small", handler);
        XMLUtils.endElement((ContentHandler)handler, (String)"group");
    }

    public String toString() {
        return super.toString() + "[" + String.valueOf(this._label) + "]";
    }
}

