/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui.ribbonconfiguration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ametys.core.ui.RibbonManager;
import org.ametys.core.ui.ribbonconfiguration.ControlRef;
import org.ametys.core.ui.ribbonconfiguration.Element;
import org.ametys.core.ui.ribbonconfiguration.Layout;
import org.ametys.core.ui.ribbonconfiguration.Toolbar;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.xml.XMLUtils;
import org.slf4j.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class GroupSize {
    protected List<Element> _elements = new ArrayList<Element>();
    protected Logger _groupSizeLogger;

    public GroupSize(Configuration groupSizeConfiguration, RibbonManager ribbonManager, Logger logger) throws ConfigurationException {
        Configuration[] elementsConfigurations;
        this._groupSizeLogger = logger;
        for (Configuration elementConfiguration : elementsConfigurations = groupSizeConfiguration.getChildren()) {
            if ("control".equals(elementConfiguration.getName())) {
                ControlRef control = new ControlRef(elementConfiguration, ribbonManager, this._groupSizeLogger);
                this._elements.add(control);
                continue;
            }
            if ("layout".equals(elementConfiguration.getName())) {
                Layout layout = new Layout(elementConfiguration, ribbonManager, this._groupSizeLogger);
                this._elements.add(layout);
                continue;
            }
            if (!this._groupSizeLogger.isWarnEnabled()) continue;
            this._groupSizeLogger.warn("During configuration of the ribbon, the group use an unknow tag '" + elementConfiguration.getName() + "'");
        }
    }

    public GroupSize(Logger logger) {
        this._groupSizeLogger = logger;
    }

    public Set<String> getControlIds() {
        return this._getControlIds(this._elements);
    }

    private Set<String> _getControlIds(List<Element> elements) {
        HashSet<String> ids = new HashSet<String>();
        for (Element element : elements) {
            if (element instanceof ControlRef) {
                ControlRef controlRef = (ControlRef)element;
                ids.add(controlRef._id);
                continue;
            }
            if (element instanceof Layout) {
                Layout layout = (Layout)element;
                ids.addAll(this._getControlIds(layout._elements));
                continue;
            }
            Toolbar toolbar = (Toolbar)element;
            ids.addAll(this._getControlIds(toolbar._elements));
        }
        return ids;
    }

    public List<Element> getChildren() {
        return this._elements;
    }

    public void toSAX(String elementName, ContentHandler handler) throws SAXException {
        XMLUtils.startElement((ContentHandler)handler, (String)elementName);
        for (Element element : this._elements) {
            element.toSAX(handler);
        }
        XMLUtils.endElement((ContentHandler)handler, (String)elementName);
    }

    public boolean isSame(GroupSize obj) {
        List<Element> objElements = obj.getChildren();
        if (objElements.size() != this._elements.size()) {
            return false;
        }
        for (int i = 0; i < this._elements.size(); ++i) {
            Element element = this._elements.get(i);
            Element objElement = objElements.get(i);
            if (element != null && objElement != null && element.isSame(objElement)) continue;
            return false;
        }
        return true;
    }
}

