/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui.ribbonconfiguration;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.SAXException;

public class RibbonConfigurationSource {
    Source _source;
    String _uri;
    Long _lastModified;

    public RibbonConfigurationSource(String uri, Source source, Map<String, Object> returnedParameters) {
        this._uri = uri;
        this._source = source;
        this._lastModified = returnedParameters.containsKey("lastModified") ? ((Long)returnedParameters.get("lastModified")).longValue() : source.getLastModified();
    }

    public static RibbonConfigurationSource createFromUri(String uri, SourceResolver resolver) throws IOException {
        HashMap<String, Object> returnedParameters = new HashMap<String, Object>();
        Source resolvedSource = resolver.resolveURI(uri, null, returnedParameters);
        return new RibbonConfigurationSource(uri, resolvedSource, returnedParameters);
    }

    public Source getSource() {
        return this._source;
    }

    public String getUri() {
        return this._uri;
    }

    public Long getLastModified() {
        return this._lastModified;
    }

    public Configuration getConfiguration() throws ConfigurationException, SAXException, IOException {
        if (this._source.exists()) {
            try (InputStream is = this._source.getInputStream();){
                Configuration configuration = new DefaultConfigurationBuilder().build(is);
                return configuration;
            }
        }
        return new DefaultConfiguration("ribbon");
    }
}

