/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui.ribbonconfiguration;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.ametys.core.ui.RibbonManager;
import org.ametys.core.ui.RibbonTabsManager;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.core.ui.ribbonconfiguration.Group;
import org.ametys.core.ui.ribbonconfiguration.RibbonElementsInjectionHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.slf4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Tab {
    protected I18nizableText _label;
    protected String _controlId;
    protected String _contextualColor;
    protected String _contextualGroup;
    protected Object _order;
    protected Boolean _orderBefore;
    protected Boolean _override;
    protected List<Group> _groups = new ArrayList<Group>();
    protected RibbonElementsInjectionHelper<Group> _tabOverrideHelper;
    protected Logger _log;

    public Tab(Configuration tabConfiguration, RibbonManager ribbonManager, Integer defaultOrder, Logger logger) throws ConfigurationException {
        this._log = logger;
        if (this._log.isDebugEnabled()) {
            this._log.debug("Creating tab");
        }
        this._configureId(tabConfiguration);
        if (tabConfiguration.getAttribute("ref-id", null) != null || tabConfiguration.getChild("tab-control", false) != null) {
            this._generateTabControl(tabConfiguration, ribbonManager);
        }
        this._label = new I18nizableText("application", tabConfiguration.getAttribute("label"));
        if (this._log.isDebugEnabled()) {
            this._log.debug("Tab label is " + String.valueOf(this._label));
        }
        this._override = tabConfiguration.getAttributeAsBoolean("override", false);
        this._configureGroups(tabConfiguration, ribbonManager);
        this._configureOrder(tabConfiguration, defaultOrder);
    }

    public String getId() {
        return this._controlId;
    }

    public Boolean isContextual() {
        return this._controlId != null;
    }

    protected void _configureId(Configuration tabConfiguration) throws ConfigurationException {
        this._controlId = tabConfiguration.getAttribute("controlId", null);
        this._contextualColor = tabConfiguration.getAttribute("contextualColor", null);
        this._contextualGroup = tabConfiguration.getAttribute("contextualGroup", null);
        if (this._log.isDebugEnabled() && this._controlId != null) {
            this._log.debug("Tab control id is " + this._controlId);
        }
    }

    protected void _generateTabControl(Configuration tabConfiguration, RibbonManager ribbonManager) throws ConfigurationException {
        if (this._controlId == null) {
            this._controlId = UUID.randomUUID().toString();
        }
        DefaultConfiguration defaultConfig = new DefaultConfiguration(tabConfiguration.getChild("tab-control"));
        String refId = defaultConfig.getAttribute("ref-id", null);
        String classname = tabConfiguration.getAttribute("class", null);
        if (classname == null) {
            if (refId != null) {
                defaultConfig.setAttribute("point", tabConfiguration.getAttribute("point", RibbonTabsManager.ROLE));
            } else {
                classname = StaticClientSideElement.class.getName();
                defaultConfig.setAttribute("class", classname);
            }
        }
        ribbonManager.addExtension(this._controlId, "core-ui", null, (Configuration)defaultConfig);
        if (this._log.isDebugEnabled()) {
            this._log.debug("Generated Tab control id is " + this._controlId);
        }
    }

    protected void _configureGroups(Configuration tabConfiguration, RibbonManager ribbonManager) throws ConfigurationException {
        Configuration[] groupsConfigurations;
        for (Configuration groupConfiguration : groupsConfigurations = tabConfiguration.getChild("groups").getChildren("group")) {
            Group group = new Group(groupConfiguration, ribbonManager, this._log);
            this._groups.add(group);
        }
    }

    private void _configureOrder(Configuration tabConfiguration, Integer defaultOrder) {
        String order = tabConfiguration.getAttribute("order", null);
        try {
            this._order = Integer.parseInt(order);
        }
        catch (NumberFormatException e) {
            this._order = order != null ? order : defaultOrder;
        }
        this._orderBefore = tabConfiguration.getAttributeAsBoolean("order-before", false);
    }

    public String getLabel() {
        return this._label.toString();
    }

    public String getOrderAsString() {
        if (this._order instanceof String) {
            return (String)this._order;
        }
        return null;
    }

    public Integer getOrderAsInteger() {
        if (this._order instanceof Integer) {
            return (Integer)this._order;
        }
        return null;
    }

    public void setOrder(Object order) {
        this._order = order;
    }

    public boolean orderBefore() {
        return this._orderBefore;
    }

    public List<Group> getGroups() {
        return this._groups;
    }

    public boolean isOverride() {
        return this._override;
    }

    public void injectGroups(List<Group> groups) {
        for (Group group : groups) {
            if (group.isOverride()) continue;
            if (this._tabOverrideHelper == null) {
                this._tabOverrideHelper = new RibbonElementsInjectionHelper<Group>(this._groups, this._log);
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug("RibbonConfigurationManager : new group '" + group._label.toString() + "' injected into tab '" + this._label.toString() + "'");
            }
            this._tabOverrideHelper.injectElements(group, group.getOrder());
        }
    }

    public void injectGroupsOverride(List<Group> groups) {
        for (Group group : groups) {
            if (!group.isOverride()) continue;
            for (Group selfGroup : this._groups) {
                if (!selfGroup._label.equals(group._label)) continue;
                if (this._log.isDebugEnabled()) {
                    this._log.debug("RibbonConfigurationManager : overriding group '" + String.valueOf(group._label) + "' of tab '" + String.valueOf(this._label) + "' to inject new controls");
                }
                selfGroup.injectGroup(group);
            }
        }
    }

    public void saxGroups(ContentHandler handler, List<Group> groups) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("label", this._label.getCatalogue() + ":" + this._label.getKey());
        StringBuilder i18nAttr = new StringBuilder("label");
        if (this._controlId != null) {
            attrs.addCDATAAttribute("controlId", this._controlId);
            if (this._contextualColor != null) {
                attrs.addCDATAAttribute("contextualColor", this._contextualColor);
            }
            if (this._contextualGroup != null) {
                attrs.addCDATAAttribute("contextualGroup", this._contextualGroup);
            }
        }
        attrs.addCDATAAttribute("http://apache.org/cocoon/i18n/2.1", "attr", "i18n:attr", i18nAttr.toString());
        XMLUtils.startElement((ContentHandler)handler, (String)"tab", (Attributes)attrs);
        XMLUtils.startElement((ContentHandler)handler, (String)"groups");
        for (Group group : groups) {
            group.toSAX(handler);
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"groups");
        XMLUtils.endElement((ContentHandler)handler, (String)"tab");
    }

    public String toString() {
        return super.toString() + "[" + String.valueOf(this._label) + "]";
    }
}

