/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui.right;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupDirectoryDAO;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.GroupManager;
import org.ametys.core.right.AccessController;
import org.ametys.core.right.AccessExplanation;
import org.ametys.core.right.Profile;
import org.ametys.core.right.Right;
import org.ametys.core.right.RightManager;
import org.ametys.core.right.RightProfilesDAO;
import org.ametys.core.right.RightsExtensionPoint;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.right.ProfileAssignmentsToolClientSideElement;
import org.ametys.core.ui.right.TargetToContextConvertor;
import org.ametys.core.ui.right.TargetToContextConvertorClientSideElement;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class ContextPermissionsToolClientSideElement
extends TargetToContextConvertorClientSideElement {
    protected GroupDirectoryDAO _groupDirectoryDAO;
    protected GroupManager _groupManager;
    protected UserPopulationDAO _populationDAO;
    protected RightProfilesDAO _profileDAO;
    protected RightsExtensionPoint _rightsEP;
    protected UserManager _userManager;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._groupDirectoryDAO = (GroupDirectoryDAO)smanager.lookup(GroupDirectoryDAO.ROLE);
        this._groupManager = (GroupManager)smanager.lookup(GroupManager.ROLE);
        this._populationDAO = (UserPopulationDAO)smanager.lookup(UserPopulationDAO.ROLE);
        this._profileDAO = (RightProfilesDAO)smanager.lookup(RightProfilesDAO.ROLE);
        this._rightsEP = (RightsExtensionPoint)smanager.lookup(RightsExtensionPoint.ROLE);
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
    }

    @Callable(rights={"Runtime_Rights_ContextPermissions"})
    public Map<String, Object> getContextPermissions(String contextId, String convertorId) {
        Object context;
        if (convertorId == null) {
            context = "/${WorkspaceName}";
        } else {
            TargetToContextConvertor convertor = (TargetToContextConvertor)this._targetToContextConvertorEP.getExtension(convertorId);
            if (convertor == null) {
                throw new IllegalArgumentException("There is no convertor with id " + convertorId + ". Context permission can not be determined");
            }
            try {
                context = convertor.convertJSContext(contextId);
            }
            catch (TargetToContextConvertor.UnsupportedContextException e) {
                throw new IllegalArgumentException("The context " + contextId + " is not a valid context for convertor " + convertorId + ". Context permission can not be determined", e);
            }
        }
        RightManager.ContextPermissions contextPermissions = this._rightManager.explainAllPermissions(context);
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        HashSet<AccessController.Permission> includedPermissions = new HashSet<AccessController.Permission>();
        Map<String, Object> anonymousPermissions = this._contextPermissionsToJSON(contextPermissions.permissionsForAnonymous());
        anonymousPermissions.put("targetType", ProfileAssignmentsToolClientSideElement.TargetType.ANONYMOUS.toString());
        results.add(anonymousPermissions);
        includedPermissions.addAll(contextPermissions.permissionsForAnonymous().keySet());
        Map<String, Object> anyConnectedPermissions = this._contextPermissionsToJSON(contextPermissions.permissionsForAnyConnected());
        anyConnectedPermissions.put("targetType", ProfileAssignmentsToolClientSideElement.TargetType.ANYCONNECTED_USER.toString());
        results.add(anyConnectedPermissions);
        includedPermissions.addAll(contextPermissions.permissionsForAnyConnected().keySet());
        Map<UserIdentity, Map<AccessController.Permission, List<AccessExplanation>>> permissionsByUser = contextPermissions.permissionsByUser();
        for (UserIdentity identity : permissionsByUser.keySet()) {
            User user = this._userManager.getUser(identity);
            if (user == null) continue;
            Map<String, Object> userPermissions = this._contextPermissionsToJSON(permissionsByUser.get(identity));
            userPermissions.put("targetType", ProfileAssignmentsToolClientSideElement.TargetType.USER.toString());
            userPermissions.put("login", identity.getLogin());
            userPermissions.put("populationId", identity.getPopulationId());
            userPermissions.put("populationLabel", this._populationDAO.getUserPopulation(identity.getPopulationId()).getLabel());
            userPermissions.put("groups", this._groupManager.getUserGroups(identity).stream().map(this::_userGroup2json).collect(Collectors.toList()));
            userPermissions.put("userSortableName", user.getSortableName());
            results.add(userPermissions);
            includedPermissions.addAll(permissionsByUser.get(identity).keySet());
        }
        Map<GroupIdentity, Map<AccessController.Permission, List<AccessExplanation>>> permissionsByGroup = contextPermissions.permissionsByGroup();
        for (GroupIdentity identity : permissionsByGroup.keySet()) {
            Group group = this._groupManager.getGroup(identity);
            if (group == null) continue;
            Map<String, Object> groupPermissions = this._contextPermissionsToJSON(permissionsByGroup.get(identity));
            groupPermissions.put("targetType", ProfileAssignmentsToolClientSideElement.TargetType.GROUP.toString());
            String groupId = identity.getId();
            String directoryId = identity.getDirectoryId();
            groupPermissions.put("groupId", groupId);
            groupPermissions.put("groupDirectory", directoryId);
            groupPermissions.put("groupDirectoryLabel", this._groupDirectoryDAO.getGroupDirectory(directoryId).getLabel());
            groupPermissions.put("groupLabel", group.getLabel());
            results.add(groupPermissions);
            includedPermissions.addAll(permissionsByGroup.get(identity).keySet());
        }
        return Map.of("data", results, "metaData", Map.of("permissions", includedPermissions.stream().map(this::_permissionToJSON).filter(Objects::nonNull).toList()));
    }

    private Map<String, Object> _contextPermissionsToJSON(Map<AccessController.Permission, List<AccessExplanation>> contextPermissions) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<AccessController.Permission, List<AccessExplanation>> entry : contextPermissions.entrySet()) {
            List<AccessExplanation> explanations = entry.getValue();
            if (explanations.isEmpty()) continue;
            explanations.sort(Comparator.naturalOrder());
            AccessController.Permission permission = entry.getKey();
            result.put(permission.toString(), Map.of("accessResult", explanations.get(0).accessResult(), "accessExplanations", explanations));
        }
        return result;
    }

    private Map<String, Object> _permissionToJSON(AccessController.Permission permission) {
        switch (permission.type()) {
            case READ: {
                return Map.of("key", permission.toString(), "type", permission.type().name(), "label", new I18nizableText("plugin.core", "PLUGINS_CORE_RIGHTS_READER_LABEL"), "rights", List.of());
            }
            case ALL_RIGHTS: {
                return Map.of("key", permission.toString(), "type", permission.type().name(), "label", new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_TOOL_USER_PROFILES_ALL_RIGHTS_COLUMN_LABEL"), "rights", List.of());
            }
            case PROFILE: {
                Profile profile = this._profileDAO.getProfile(permission.id());
                if (profile != null) {
                    return Map.of("key", permission.toString(), "id", permission.id(), "type", permission.type().name(), "label", profile.getLabel(), "rights", this._profileDAO.getRights(permission.id()));
                }
                this.getLogger().info("No profile with id '" + permission.id() + "'. The permission is ignored.");
                return null;
            }
            case RIGHT: {
                Right right = this._rightsEP.getExtension(permission.id());
                if (right != null) {
                    return Map.of("key", permission.toString(), "id", permission.id(), "type", permission.type().name(), "label", right.getLabel(), "rights", List.of(permission.id()));
                }
                this.getLogger().info("No right with id '" + permission.id() + "'. The permission is ignored.");
                return null;
            }
        }
        return null;
    }

    private Map<String, Object> _userGroup2json(GroupIdentity group) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("groupId", group.getId());
        result.put("groupDirectory", group.getDirectoryId());
        return result;
    }
}

