/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui.right;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.core.right.AccessController;
import org.ametys.core.right.AccessExplanation;
import org.ametys.core.right.RightAssignmentContextExtensionPoint;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.right.TargetToContextConvertor;
import org.ametys.core.ui.right.TargetToContextConvertorClientSideElement;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.user.UserHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class ExplainUserRightTool
extends TargetToContextConvertorClientSideElement {
    public static final String RIGHT_EXPLAIN_ALL_USERS_RIGHTS = "Runtime_Rights_ExplainAllUsersRights";
    public static final String RIGHT_EXPLAIN_OWN_RIGHTS = "Runtime_Rights_ExplainOwnRights";
    protected UserHelper _userHelper;
    protected RightAssignmentContextExtensionPoint _rightAssignmentContextEP;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._rightAssignmentContextEP = (RightAssignmentContextExtensionPoint)manager.lookup(RightAssignmentContextExtensionPoint.ROLE);
        this._userHelper = (UserHelper)manager.lookup(UserHelper.ROLE);
    }

    @Callable(rights={"Runtime_Rights_ExplainOwnRights"})
    public Map<String, Object> explainCurrentUserRight(String rightId, Object contextJS, String targetToContextConvertorId) {
        return this.explainUserRight(rightId, this._currentUserProvider.getUser(), contextJS, targetToContextConvertorId);
    }

    @Callable(rights={"Runtime_Rights_ExplainAllUsersRights"})
    public Map<String, Object> explainRight(String rightId, Map<String, Object> user, Object contextJS, String targetToContextConvertorId) {
        return this.explainUserRight(rightId, this._userHelper.json2userIdentity(user), contextJS, targetToContextConvertorId);
    }

    private Map<String, Object> explainUserRight(String rightId, UserIdentity userIdentity, Object contextJS, String targetToContextConvertorId) {
        Object context;
        if (contextJS == null) {
            context = "/${WorkspaceName}";
        } else {
            try {
                context = ((TargetToContextConvertor)this._targetToContextConvertorEP.getExtension(targetToContextConvertorId)).convertJSContext(contextJS);
            }
            catch (TargetToContextConvertor.UnsupportedContextException e) {
                throw new IllegalArgumentException("The context " + String.valueOf(contextJS) + " is not a valid context for convertor " + targetToContextConvertorId + ". Context permission can not be determined", e);
            }
        }
        List<AccessExplanation> explanations = this._rightManager.explain(userIdentity, rightId.equals("READER") ? null : rightId, context);
        explanations.sort(Comparator.naturalOrder());
        AccessController.AccessResult summary = explanations.isEmpty() ? AccessController.AccessResult.UNKNOWN : explanations.stream().map(AccessExplanation::accessResult).collect(Collectors.collectingAndThen(Collectors.toList(), AccessController.AccessResult::merge));
        return Map.of("result", summary, "explanations", explanations);
    }
}

