/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui.right;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.ametys.core.right.Profile;
import org.ametys.core.right.Right;
import org.ametys.core.right.RightManager;
import org.ametys.core.right.RightProfilesDAO;
import org.ametys.core.right.RightsExtensionPoint;
import org.ametys.core.ui.Callable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.excalibur.source.ModifiableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ExternalRightsDAO
extends AbstractLogEnabled
implements Component,
Serviceable {
    protected RightsExtensionPoint _rightsExtensionPoint;
    protected RightManager _rightManager;
    protected RightProfilesDAO _profileDAO;
    protected SourceResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._rightsExtensionPoint = (RightsExtensionPoint)manager.lookup(RightsExtensionPoint.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._profileDAO = (RightProfilesDAO)manager.lookup(RightProfilesDAO.ROLE);
        this._resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    @Callable(rights={"CORE_Rights_Edit_Right"})
    public Map<String, Object> getRightsCategories() {
        HashSet<Map<String, String>> categories2Json = new HashSet<Map<String, String>>();
        for (String rightId : this._rightsExtensionPoint.getExtensionsIds()) {
            Right right = this._rightsExtensionPoint.getExtension(rightId);
            I18nizableText category = right.getCategory();
            categories2Json.add(Map.of("label", category, "id", category.toString()));
        }
        return Map.of("data", categories2Json);
    }

    @Callable(rights={"CORE_Rights_Edit_Right"})
    public Map<String, Object> getRightsToDelete() {
        ArrayList<Map<String, String>> rights2Json = new ArrayList<Map<String, String>>();
        List<Profile> profiles = this._profileDAO.getProfiles();
        for (String rightId : this._rightManager.getExternalRightIds()) {
            if (this._isRightUsed(profiles, rightId)) continue;
            Right right = this._rightsExtensionPoint.getExtension(rightId);
            rights2Json.add(Map.of("label", right.getLabel(), "id", right.getId()));
        }
        return Map.of("data", rights2Json);
    }

    private boolean _isRightUsed(List<Profile> profiles, String rightId) {
        return profiles.stream().map(p -> this._profileDAO.getRights((Profile)p)).filter(rights -> rights.contains(rightId)).findAny().isPresent();
    }

    @Callable(rights={"CORE_Rights_Edit_Right"})
    public Map<String, Object> addRight(String id, String label, String description, String category) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        if (!this.getRightsIds().contains(id)) {
            this._rightManager.addExternalRight(id, label, description, category);
            try {
                this.writeRightsXML();
                results.put("id", id);
            }
            catch (Exception e) {
                this.getLogger().error("An error occured while writing in rights.xml", (Throwable)e);
                results.put("message", "error");
            }
        } else {
            results.put("message", "duplicate-id");
        }
        return results;
    }

    @Callable(rights={"CORE_Rights_Edit_Right"})
    public Map<String, Object> removeRight(String id) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        if (!this._isRightUsed(this._profileDAO.getProfiles(), id)) {
            this._rightManager.removeExternalRight(id);
            try {
                this.writeRightsXML();
                results.put("id", id);
            }
            catch (Exception e) {
                this.getLogger().error("An error occured while writing in rights.xml", (Throwable)e);
                results.put("message", "error");
            }
        } else {
            results.put("message", "rigth-used");
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRightsXML() throws Exception {
        String filepath = "context://WEB-INF/param/rights.xml";
        ModifiableSource source = (ModifiableSource)this._resolver.resolveURI(filepath);
        try (OutputStream os = source.getOutputStream();){
            TransformerHandler th = ((SAXTransformerFactory)TransformerFactory.newInstance()).newTransformerHandler();
            StreamResult result = new StreamResult(os);
            th.setResult(result);
            Properties format = new Properties();
            format.put("method", "xml");
            format.put("indent", "yes");
            format.put("encoding", "UTF-8");
            format.put("{http://xml.apache.org/xalan}indent-amount", "2");
            th.getTransformer().setOutputProperties(format);
            this._saxRights(th);
        }
        finally {
            if (source != null) {
                this._resolver.release((Source)source);
            }
        }
    }

    protected void _saxRights(TransformerHandler handler) throws SAXException {
        handler.startDocument();
        AttributesImpl attribute = new AttributesImpl();
        XMLUtils.startElement((ContentHandler)handler, (String)"rights", (Attributes)attribute);
        List<String> externalRightIds = this._rightManager.getExternalRightIds();
        for (String rightId : externalRightIds) {
            Right right = this._rightsExtensionPoint.getExtension(rightId);
            attribute.addCDATAAttribute("id", right.getId());
            XMLUtils.startElement((ContentHandler)handler, (String)"right", (Attributes)attribute);
            this._saxI18nizableText(handler, right.getLabel(), "label");
            this._saxI18nizableText(handler, right.getDescription(), "description");
            this._saxI18nizableText(handler, right.getCategory(), "category");
            XMLUtils.endElement((ContentHandler)handler, (String)"right");
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"rights");
        handler.endDocument();
    }

    private void _saxI18nizableText(TransformerHandler handler, I18nizableText text, String tagName) throws SAXException {
        AttributesImpl attributeI18n = new AttributesImpl();
        attributeI18n.addCDATAAttribute("type", "i18n");
        if (text.isI18n()) {
            XMLUtils.createElement((ContentHandler)handler, (String)tagName, (Attributes)attributeI18n, (String)text.toString());
        } else {
            XMLUtils.createElement((ContentHandler)handler, (String)tagName, (String)text.toString());
        }
    }

    @Callable(rights={"CORE_Rights_Edit_Right"})
    public Set<String> getRightsIds() {
        return this._rightsExtensionPoint.getExtensionsIds();
    }
}

