/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui.right;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.group.GroupDirectoryDAO;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.GroupManager;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.right.Profile;
import org.ametys.core.right.ProfileAssignmentStorage;
import org.ametys.core.right.ProfileAssignmentStorageExtensionPoint;
import org.ametys.core.right.RightAssignmentContext;
import org.ametys.core.right.RightAssignmentContextExtensionPoint;
import org.ametys.core.right.RightManager;
import org.ametys.core.right.RightProfilesDAO;
import org.ametys.core.right.RightsException;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.ClientSideElementHelper;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class ProfileAssignmentsToolClientSideElement
extends StaticClientSideElement {
    protected ProfileAssignmentStorageExtensionPoint _profileAssignmentStorageEP;
    protected RightAssignmentContextExtensionPoint _rightAssignmentContextEP;
    protected GroupDirectoryDAO _groupDirectoryDAO;
    protected GroupManager _groupManager;
    protected ObservationManager _observationManager;
    protected UserHelper _userHelper;
    protected RightProfilesDAO _profileDAO;
    private Set<String> _rightContexts;
    private boolean _readerProfileOnly;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._profileAssignmentStorageEP = (ProfileAssignmentStorageExtensionPoint)smanager.lookup(ProfileAssignmentStorageExtensionPoint.ROLE);
        this._rightAssignmentContextEP = (RightAssignmentContextExtensionPoint)smanager.lookup(RightAssignmentContextExtensionPoint.ROLE);
        this._groupDirectoryDAO = (GroupDirectoryDAO)smanager.lookup(GroupDirectoryDAO.ROLE);
        this._groupManager = (GroupManager)smanager.lookup(GroupManager.ROLE);
        this._observationManager = (ObservationManager)((Object)smanager.lookup(ObservationManager.ROLE));
        this._userHelper = (UserHelper)smanager.lookup(UserHelper.ROLE);
        this._profileDAO = (RightProfilesDAO)smanager.lookup(RightProfilesDAO.ROLE);
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this._configureRightContextIds(configuration);
        this._readerProfileOnly = configuration.getChild("class").getChild("reader-profile-only").getValueAsBoolean(false);
    }

    protected void _configureRightContextIds(Configuration configuration) throws ConfigurationException {
        Configuration[] rightCtxConfig;
        this._rightContexts = new HashSet<String>();
        for (Configuration conf : rightCtxConfig = configuration.getChild("class").getChild("right-contexts").getChildren("right-context")) {
            this._rightContexts.add(conf.getValue());
        }
    }

    protected Set<RightAssignmentContext> getRightAssignmentContexts() {
        if (!this._rightContexts.isEmpty()) {
            return this._rightContexts.stream().map(id -> (RightAssignmentContext)this._rightAssignmentContextEP.getExtension((String)id)).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        return this._rightAssignmentContextEP.getExtensionsIds().stream().map(id -> (RightAssignmentContext)this._rightAssignmentContextEP.getExtension((String)id)).filter(ctx -> !ctx.isPrivate()).collect(Collectors.toSet());
    }

    @Override
    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        List<ClientSideElement.Script> scripts = super.getScripts(ignoreRights, contextParameters);
        if (scripts.size() > 0) {
            ClientSideElement.Script script = ClientSideElementHelper.cloneScript(scripts.get(0));
            HashMap jsClasses = new HashMap();
            script.getParameters().put("classes", jsClasses);
            Set<RightAssignmentContext> rightAssignmentContexts = this.getRightAssignmentContexts();
            for (RightAssignmentContext rightAssignmentContext : rightAssignmentContexts) {
                List<ClientSideElement.Script> rightAssignmentContextScripts = rightAssignmentContext.getScripts(ignoreRights, contextParameters);
                int index = 0;
                for (ClientSideElement.Script rightAssignmentContextScript : rightAssignmentContextScripts) {
                    HashMap<String, Object> classInfo = new HashMap<String, Object>();
                    classInfo.put("className", rightAssignmentContextScript.getScriptClassname());
                    classInfo.put("serverId", rightAssignmentContext.getId());
                    classInfo.put("parameters", rightAssignmentContextScript.getParameters());
                    jsClasses.put((CallSite)((Object)(rightAssignmentContext.getId() + "-" + index++)), classInfo);
                    script.getScriptFiles().addAll(rightAssignmentContextScript.getScriptFiles());
                    script.getCSSFiles().addAll(rightAssignmentContextScript.getCSSFiles());
                }
            }
            scripts = new ArrayList<ClientSideElement.Script>();
            scripts.add(script);
        }
        return scripts;
    }

    @Callable(rights={""})
    public List<Map<String, Object>> getUserGroups(String login, String populationId) {
        if (!this.hasRight(this.getRights(Map.of()))) {
            throw new AccessDeniedException("The user '" + String.valueOf(this._currentUserProvider.getUser()) + "' is not authorized to get user's groups");
        }
        return this._groupManager.getUserGroups(new UserIdentity(login, populationId)).stream().map(this::_groupToJson).collect(Collectors.toList());
    }

    private Map<String, Object> _groupToJson(GroupIdentity groupIdentity) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("groupId", groupIdentity.getId());
        result.put("groupDirectory", groupIdentity.getDirectoryId());
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> saveChanges(String rightAssignmentCtxId, Object jsContext, List<Map<String, Object>> assignmentsInfo) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> successInfos = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> errorInfos = new ArrayList<Map<String, Object>>();
        UserIdentity user = this._currentUserProvider.getUser();
        Set<GroupIdentity> groups = this._groupManager.getUserGroups(user);
        if (!this._checkRightAssignmentContext(rightAssignmentCtxId)) {
            throw new RightsException("The user '" + String.valueOf(user) + "' try to assign profile on unauthorized context '" + rightAssignmentCtxId + "'");
        }
        HashMap<String, String> rights = new HashMap<String, String>(this.getRights(Map.of()));
        rights.remove("CMS_Rights_Delegate_Rights");
        RightAssignmentContext rightAssignmentContext = (RightAssignmentContext)this._rightAssignmentContextEP.getExtension(rightAssignmentCtxId);
        Object context = rightAssignmentContext.convertJSContext(jsContext);
        boolean hasHandleRight = this.hasRight(rights, context);
        HashSet<String> updatedProfiles = new HashSet<String>();
        String contextIdentifier = rightAssignmentContext.getContextIdentifier(context);
        for (Map<String, Object> assignmentInfo : assignmentsInfo) {
            String profileId = (String)assignmentInfo.get("profileId");
            if (this._readerProfileOnly && !"READER".equals(profileId)) {
                throw new RightsException("The user '" + String.valueOf(user) + "' try to the assign profile '" + profileId + "' on the object context '" + String.valueOf(jsContext) + "' but only the reader profile is allowed for the right assignment context '" + rightAssignmentCtxId + "'");
            }
            String assignment = (String)assignmentInfo.get("assignment");
            String targetType = (String)assignmentInfo.get("targetType");
            Profile profile = this._profileDAO.getProfile(profileId);
            assignmentInfo.put("profileLabel", profile.getLabel());
            if (hasHandleRight || this.canDelegateRights(user, groups, profileId, assignment, context)) {
                updatedProfiles.add(profileId);
                Map identity = (Map)assignmentInfo.get("identity");
                this._saveChange(context, profileId, assignment, targetType, identity);
                successInfos.add(assignmentInfo);
                continue;
            }
            errorInfos.add(assignmentInfo);
        }
        this._notifyObservers(context, contextIdentifier, updatedProfiles);
        result.put("successInfos", successInfos);
        result.put("errorInfos", errorInfos);
        result.put("success", errorInfos.isEmpty());
        return result;
    }

    protected boolean hasRight(Map<String, String> rights, Object context) {
        return this.hasRight(rights);
    }

    protected boolean _checkRightAssignmentContext(String rightAssignmentCtxId) {
        Set rightAssignmentCtxIds = this.getRightAssignmentContexts().stream().map(ClientSideElement::getId).collect(Collectors.toSet());
        return rightAssignmentCtxIds.contains(rightAssignmentCtxId);
    }

    @Callable(rights={""})
    public boolean applyAssignments(String rightAssignmentCtxId, List<Map<String, Object>> targetContexts, List<Map<String, Object>> assignmentsInfo, boolean disallowInheritance) {
        UserIdentity user = this._currentUserProvider.getUser();
        if (!this.hasRight(this.getRights(Map.of()))) {
            throw new AccessDeniedException("The user '" + String.valueOf(user) + "' try to apply assignments without sufficient rights");
        }
        if (!this._checkRightAssignmentContext(rightAssignmentCtxId)) {
            throw new RightsException("The user '" + String.valueOf(user) + "' tries to apply assignments on an unauthorized context '" + rightAssignmentCtxId + "'");
        }
        Set<String> allProfileIds = this._profileDAO.getProfiles().stream().map(Profile::getId).collect(Collectors.toSet());
        Set<AssignmentTarget> assignmentTargets = this._getAssignmentTargets(assignmentsInfo);
        RightAssignmentContext rightAssignmentContext = (RightAssignmentContext)this._rightAssignmentContextEP.getExtension(rightAssignmentCtxId);
        for (Map<String, Object> targetContext : targetContexts) {
            String jsContext = (String)targetContext.get("context");
            Object context = rightAssignmentContext.convertJSContext(jsContext);
            for (AssignmentTarget assignmentTarget : assignmentTargets) {
                this._resetAssignments(allProfileIds, context, assignmentTarget.targetType(), assignmentTarget.identity());
            }
            for (Map map : assignmentsInfo) {
                String profileId = (String)map.get("profileId");
                if (this._readerProfileOnly && !"READER".equals(profileId)) {
                    throw new RightsException("The user '" + String.valueOf(user) + "' try to apply the profile '" + profileId + "' on the object context '" + jsContext + "' but only the reader profile is allowed for the right assignment context '" + rightAssignmentCtxId + "'");
                }
                String targetType = (String)map.get("targetType");
                Map identity = (Map)map.get("identity");
                String assignment = (String)map.get("assignment");
                this._saveChange(context, profileId, assignment, targetType, identity);
            }
            boolean inheritanceAvailable = (Boolean)targetContext.get("inheritanceAvailable");
            if (inheritanceAvailable) {
                this._profileAssignmentStorageEP.disallowInheritance(context, disallowInheritance);
            }
            String string = rightAssignmentContext.getContextIdentifier(context);
            this._notifyObservers(context, string, allProfileIds);
        }
        return true;
    }

    private Set<AssignmentTarget> _getAssignmentTargets(List<Map<String, Object>> assignmentsInfo) {
        HashSet<AssignmentTarget> targets = new HashSet<AssignmentTarget>();
        for (Map<String, Object> assignmentInfo : assignmentsInfo) {
            String targetType = (String)assignmentInfo.get("targetType");
            switch (TargetType.valueOf(targetType.toUpperCase()).ordinal()) {
                case 0: 
                case 1: {
                    targets.add(new AssignmentTarget(targetType, null));
                    break;
                }
                case 2: 
                case 3: {
                    Map identity = (Map)assignmentInfo.get("identity");
                    targets.add(new AssignmentTarget(targetType, identity));
                    break;
                }
            }
        }
        return targets;
    }

    protected boolean canDelegateRights(UserIdentity user, Set<GroupIdentity> groups, String profileId, String assignment, Object context) {
        AccessType accessType = assignment != null ? AccessType.valueOf(assignment.toUpperCase()) : AccessType.UNKNOWN;
        return accessType == AccessType.ALLOW && this._rightManager.hasRight(user, "CMS_Rights_Delegate_Rights", "/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW && this._profileAssignmentStorageEP.getPermissions(user, groups, Set.of(profileId), context).get(profileId).toRightResult() == RightManager.RightResult.RIGHT_ALLOW;
    }

    protected void _notifyObservers(Object context, String contextIdentifier, Set<String> profileIds) {
        this._observationManager.notify(new Event("acl.update", this._currentUserProvider.getUser(), this._getEventParams(context, contextIdentifier, profileIds)));
    }

    protected Map<String, Object> _getEventParams(Object context, String contextIdentifier, Set<String> profileIds) {
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("acl-context", context);
        eventParams.put("acl-context-identifier", contextIdentifier);
        eventParams.put("acl-profiles", profileIds);
        return eventParams;
    }

    @Callable(rights={""})
    public boolean isInheritanceDisallowed(String rightAssignmentCtxId, Object jsContext) {
        if (!this.hasRight(this.getRights(Map.of()))) {
            throw new AccessDeniedException("The user '" + String.valueOf(this._currentUserProvider.getUser()) + "' is not authorized to get right's inheritance status");
        }
        RightAssignmentContext rightCtx = (RightAssignmentContext)this._rightAssignmentContextEP.getExtension(rightAssignmentCtxId);
        Object context = rightCtx.convertJSContext(jsContext);
        return this._profileAssignmentStorageEP.isInheritanceDisallowed(context);
    }

    @Callable(rights={""})
    public void disallowInheritance(String rightAssignmentCtxId, Object jsContext, boolean disallow) {
        if (!this.hasRight(this.getRights(Map.of()))) {
            throw new AccessDeniedException("The user '" + String.valueOf(this._currentUserProvider.getUser()) + "' try to disallow rights inheritance without sufficient rights");
        }
        RightAssignmentContext rightCtx = (RightAssignmentContext)this._rightAssignmentContextEP.getExtension(rightAssignmentCtxId);
        Object context = rightCtx.convertJSContext(jsContext);
        String contextIdentifier = rightCtx.getContextIdentifier(context);
        this._profileAssignmentStorageEP.disallowInheritance(context, disallow);
        Set<String> profileIds = this._profileDAO.getProfiles().stream().map(Profile::getId).collect(Collectors.toSet());
        this._notifyObservers(context, contextIdentifier, profileIds);
    }

    @Callable(rights={""})
    public Map<String, String> getInheritedAssignments(String rightAssignmentCtxId, Object jsContext, List<String> profileIds, String targetType, Map<String, String> identity) {
        if (!this.hasRight(this.getRights(Map.of()))) {
            throw new AccessDeniedException("The user '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to get inherited assignments without sufficient right");
        }
        RightAssignmentContext rightCtx = (RightAssignmentContext)this._rightAssignmentContextEP.getExtension(rightAssignmentCtxId);
        Object context = rightCtx.convertJSContext(jsContext);
        if (this._profileAssignmentStorageEP.isInheritanceDisallowed(context)) {
            return profileIds.stream().collect(Collectors.toMap(profileId -> profileId, profileId -> AccessType.UNKNOWN.toString()));
        }
        return profileIds.stream().collect(Collectors.toMap(profileId -> profileId, profileId -> this.getInheritedAssignment(rightAssignmentCtxId, jsContext, (String)profileId, targetType, identity)));
    }

    @Callable(rights={""})
    public String getInheritedAssignment(String rightAssignmentCtxId, Object jsContext, String profileId, String targetType, Map<String, String> identity) {
        if (!this.hasRight(this.getRights(Map.of()))) {
            throw new AccessDeniedException("The user '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to get inherited assignments without sufficient right");
        }
        RightAssignmentContext rightCtx = (RightAssignmentContext)this._rightAssignmentContextEP.getExtension(rightAssignmentCtxId);
        Object context = rightCtx.convertJSContext(jsContext);
        if (this._profileAssignmentStorageEP.isInheritanceDisallowed(context)) {
            return AccessType.UNKNOWN.toString();
        }
        switch (TargetType.valueOf(targetType.toUpperCase()).ordinal()) {
            case 0: {
                return this._getInheritedAssignmentForAnonymous(rightCtx, context, profileId);
            }
            case 1: {
                return this._getInheritedAssignmentForAnyconnected(rightCtx, context, profileId);
            }
            case 2: {
                UserIdentity user = this._userHelper.json2userIdentity(identity);
                return this._getInheritedAssignmentForUser(rightCtx, context, profileId, user);
            }
            case 3: {
                GroupIdentity group = new GroupIdentity(identity.get("groupId"), identity.get("groupDirectory"));
                return this._getInheritedAssignmentForGroup(rightCtx, context, profileId, group);
            }
        }
        return AccessType.UNKNOWN.toString();
    }

    private String _getInheritedAssignmentForAnonymous(RightAssignmentContext extension, Object context, String profileId) {
        String value = AccessType.UNKNOWN.toString();
        Set<Object> parentContexts = extension.getParentContexts(context);
        if (parentContexts != null) {
            for (Object parentContext : parentContexts) {
                Map<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys, Set<String>> profilesForAnonymousAndAnyConnectedUser = this._profileAssignmentStorageEP.getProfilesForAnonymousAndAnyConnectedUser(parentContexts);
                Set deniedProfiles = Optional.ofNullable(profilesForAnonymousAndAnyConnectedUser.get((Object)ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_DENIED)).orElse(Set.of());
                if (deniedProfiles.contains(profileId)) {
                    return AccessType.INHERITED_DENY.toString();
                }
                Set allowedProfiles = Optional.ofNullable(profilesForAnonymousAndAnyConnectedUser.get((Object)ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_ALLOWED)).orElse(Set.of());
                if (allowedProfiles.contains(profileId)) {
                    value = AccessType.INHERITED_ALLOW.toString();
                }
                String parentsValue = this._getInheritedAssignmentForAnonymous(extension, parentContext, profileId);
                if (AccessType.UNKNOWN.toString().equals(parentsValue)) continue;
                value = parentsValue;
            }
        }
        return value;
    }

    private String _getInheritedAssignmentForAnyconnected(RightAssignmentContext extension, Object context, String profileId) {
        String value = AccessType.UNKNOWN.toString();
        Set<Object> parentContexts = extension.getParentContexts(context);
        if (parentContexts != null) {
            for (Object parentContext : parentContexts) {
                Map<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys, Set<String>> profilesForAnonymousAndAnyConnectedUser = this._profileAssignmentStorageEP.getProfilesForAnonymousAndAnyConnectedUser(parentContexts);
                Set deniedProfiles = Optional.ofNullable(profilesForAnonymousAndAnyConnectedUser.get((Object)ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_DENIED)).orElse(Set.of());
                if (deniedProfiles.contains(profileId)) {
                    return AccessType.INHERITED_DENY.toString();
                }
                Set allowedProfiles = Optional.ofNullable(profilesForAnonymousAndAnyConnectedUser.get((Object)ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_ALLOWED)).orElse(Set.of());
                if (allowedProfiles.contains(profileId)) {
                    value = AccessType.INHERITED_ALLOW.toString();
                }
                String parentsValue = this._getInheritedAssignmentForAnyconnected(extension, parentContext, profileId);
                if (AccessType.UNKNOWN.toString().equals(parentsValue)) continue;
                value = parentsValue;
            }
        }
        return value;
    }

    private String _getInheritedAssignmentForUser(RightAssignmentContext extension, Object context, String profileId, UserIdentity user) {
        String value = AccessType.UNKNOWN.toString();
        Set<Object> parentContexts = extension.getParentContexts(context);
        if (parentContexts != null) {
            for (Object parentContext : parentContexts) {
                Map<UserIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> profilesForUsers = this._profileAssignmentStorageEP.getProfilesForUsers(parentContext, user);
                Set deniedProfiles = Optional.ofNullable(profilesForUsers.get(user)).map(a -> (Set)a.get((Object)ProfileAssignmentStorage.UserOrGroup.DENIED)).orElse(Set.of());
                if (deniedProfiles.contains(profileId)) {
                    return AccessType.INHERITED_DENY.toString();
                }
                Set allowedProfiles = Optional.ofNullable(profilesForUsers.get(user)).map(a -> (Set)a.get((Object)ProfileAssignmentStorage.UserOrGroup.ALLOWED)).orElse(Set.of());
                if (allowedProfiles.contains(profileId)) {
                    value = AccessType.INHERITED_ALLOW.toString();
                }
                String parentsValue = this._getInheritedAssignmentForUser(extension, parentContext, profileId, user);
                if (AccessType.UNKNOWN.toString().equals(parentsValue)) continue;
                value = parentsValue;
            }
        }
        return value;
    }

    private String _getInheritedAssignmentForGroup(RightAssignmentContext extension, Object context, String profileId, GroupIdentity group) {
        String value = AccessType.UNKNOWN.toString();
        Set<Object> parentContexts = extension.getParentContexts(context);
        if (parentContexts != null) {
            for (Object parentContext : parentContexts) {
                Map<GroupIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> profilesForGroups = this._profileAssignmentStorageEP.getProfilesForGroups(parentContext, Set.of(group));
                Set deniedProfiles = Optional.ofNullable(profilesForGroups.get(group)).map(a -> (Set)a.get((Object)ProfileAssignmentStorage.UserOrGroup.DENIED)).orElse(Set.of());
                if (deniedProfiles.contains(profileId)) {
                    return AccessType.INHERITED_DENY.toString();
                }
                Set allowedProfiles = Optional.ofNullable(profilesForGroups.get(group)).map(a -> (Set)a.get((Object)ProfileAssignmentStorage.UserOrGroup.ALLOWED)).orElse(Set.of());
                if (allowedProfiles.contains(profileId)) {
                    value = AccessType.INHERITED_ALLOW.toString();
                }
                String parentsValue = this._getInheritedAssignmentForGroup(extension, parentContext, profileId, group);
                if (AccessType.UNKNOWN.toString().equals(parentsValue)) continue;
                value = parentsValue;
            }
        }
        return value;
    }

    private void _resetAssignments(Set<String> profileIds, Object context, String targetType, Map<String, String> identity) {
        TargetType type = TargetType.valueOf(targetType.toUpperCase());
        for (String profileId : profileIds) {
            switch (type.ordinal()) {
                case 0: {
                    this._profileAssignmentStorageEP.removeAllowedProfileFromAnonymous(profileId, context);
                    this._profileAssignmentStorageEP.removeDeniedProfileFromAnonymous(profileId, context);
                    break;
                }
                case 1: {
                    this._profileAssignmentStorageEP.removeAllowedProfileFromAnyConnectedUser(profileId, context);
                    this._profileAssignmentStorageEP.removeDeniedProfileFromAnyConnectedUser(profileId, context);
                    break;
                }
                case 2: {
                    UserIdentity user = this._userHelper.json2userIdentity(identity);
                    this._profileAssignmentStorageEP.removeAllowedProfileFromUser(user, profileId, context);
                    this._profileAssignmentStorageEP.removeDeniedProfileFromUser(user, profileId, context);
                    break;
                }
                case 3: {
                    GroupIdentity group = new GroupIdentity(identity.get("groupId"), identity.get("groupDirectory"));
                    this._profileAssignmentStorageEP.removeAllowedProfileFromGroup(group, profileId, context);
                    this._profileAssignmentStorageEP.removeDeniedProfileFromGroup(group, profileId, context);
                    break;
                }
            }
        }
    }

    private void _saveChange(Object context, String profileId, String assignment, String targetType, Map<String, String> identity) {
        AccessType accessType = assignment != null ? AccessType.valueOf(assignment.toUpperCase()) : AccessType.UNKNOWN;
        block0 : switch (TargetType.valueOf(targetType.toUpperCase()).ordinal()) {
            case 0: {
                switch (accessType.ordinal()) {
                    case 0: {
                        this._profileAssignmentStorageEP.removeDeniedProfileFromAnonymous(profileId, context);
                        this._profileAssignmentStorageEP.allowProfileToAnonymous(profileId, context);
                        break block0;
                    }
                    case 1: {
                        this._profileAssignmentStorageEP.removeAllowedProfileFromAnonymous(profileId, context);
                        this._profileAssignmentStorageEP.denyProfileToAnonymous(profileId, context);
                        break block0;
                    }
                }
                this._profileAssignmentStorageEP.removeAllowedProfileFromAnonymous(profileId, context);
                this._profileAssignmentStorageEP.removeDeniedProfileFromAnonymous(profileId, context);
                break;
            }
            case 1: {
                switch (accessType.ordinal()) {
                    case 0: {
                        this._profileAssignmentStorageEP.removeDeniedProfileFromAnyConnectedUser(profileId, context);
                        this._profileAssignmentStorageEP.allowProfileToAnyConnectedUser(profileId, context);
                        break block0;
                    }
                    case 1: {
                        this._profileAssignmentStorageEP.removeAllowedProfileFromAnyConnectedUser(profileId, context);
                        this._profileAssignmentStorageEP.denyProfileToAnyConnectedUser(profileId, context);
                        break block0;
                    }
                }
                this._profileAssignmentStorageEP.removeAllowedProfileFromAnyConnectedUser(profileId, context);
                this._profileAssignmentStorageEP.removeDeniedProfileFromAnyConnectedUser(profileId, context);
                break;
            }
            case 2: {
                UserIdentity user = this._userHelper.json2userIdentity(identity);
                switch (accessType.ordinal()) {
                    case 0: {
                        this._profileAssignmentStorageEP.removeDeniedProfileFromUser(user, profileId, context);
                        this._profileAssignmentStorageEP.allowProfileToUser(user, profileId, context);
                        break block0;
                    }
                    case 1: {
                        this._profileAssignmentStorageEP.removeAllowedProfileFromUser(user, profileId, context);
                        this._profileAssignmentStorageEP.denyProfileToUser(user, profileId, context);
                        break block0;
                    }
                }
                this._profileAssignmentStorageEP.removeAllowedProfileFromUser(user, profileId, context);
                this._profileAssignmentStorageEP.removeDeniedProfileFromUser(user, profileId, context);
                break;
            }
            case 3: {
                GroupIdentity group = new GroupIdentity(identity.get("groupId"), identity.get("groupDirectory"));
                switch (accessType.ordinal()) {
                    case 0: {
                        this._profileAssignmentStorageEP.removeDeniedProfileFromGroup(group, profileId, context);
                        this._profileAssignmentStorageEP.allowProfileToGroup(group, profileId, context);
                        break block0;
                    }
                    case 1: {
                        this._profileAssignmentStorageEP.removeAllowedProfileFromGroup(group, profileId, context);
                        this._profileAssignmentStorageEP.denyProfileToGroup(group, profileId, context);
                        break block0;
                    }
                }
                this._profileAssignmentStorageEP.removeAllowedProfileFromGroup(group, profileId, context);
                this._profileAssignmentStorageEP.removeDeniedProfileFromGroup(group, profileId, context);
                break;
            }
        }
    }

    record AssignmentTarget(String targetType, Map<String, String> identity) {
    }

    public static enum TargetType {
        ANONYMOUS{

            public String toString() {
                return "anonymous";
            }
        }
        ,
        ANYCONNECTED_USER{

            public String toString() {
                return "anyconnected_user";
            }
        }
        ,
        USER{

            public String toString() {
                return "user";
            }
        }
        ,
        GROUP{

            public String toString() {
                return "group";
            }
        };

    }

    public static enum AccessType {
        ALLOW{

            public String toString() {
                return "allow";
            }
        }
        ,
        DENY{

            public String toString() {
                return "deny";
            }
        }
        ,
        INHERITED_ALLOW{

            public String toString() {
                return "inherited_allow";
            }
        }
        ,
        INHERITED_DENY{

            public String toString() {
                return "inherited_deny";
            }
        }
        ,
        UNKNOWN{

            public String toString() {
                return "unknown";
            }
        };

    }
}

