/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui.widgets.richtext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.widgets.richtext.RichTextConfiguration;
import org.ametys.core.ui.widgets.richtext.RichTextConfigurationExtensionPoint;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class RichTextConfigurationFileImportsClientSideElement
implements ClientSideElement,
PluginAware,
Serviceable {
    private RichTextConfigurationExtensionPoint _richTextConfigurationExtensionPoint;
    private String _id;
    private String _pluginName;

    public void service(ServiceManager manager) throws ServiceException {
        this._richTextConfigurationExtensionPoint = (RichTextConfigurationExtensionPoint)manager.lookup(RichTextConfigurationExtensionPoint.ROLE);
    }

    @Override
    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
        this._id = id;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public List<ClientSideElement.Script> getScripts(Map<String, Object> contextParameters) {
        return this.getScripts(false, contextParameters);
    }

    @Override
    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        ArrayList<ClientSideElement.Script> scripts = new ArrayList<ClientSideElement.Script>();
        for (String richTextConfigurationId : this._richTextConfigurationExtensionPoint.getExtensionsIds()) {
            RichTextConfiguration richTextConfiguration = (RichTextConfiguration)this._richTextConfigurationExtensionPoint.getExtension(richTextConfigurationId);
            for (String category : richTextConfiguration.getCategories()) {
                Set<ClientSideElement> validators;
                Set<ClientSideElement> convertors = richTextConfiguration.getConvertors(category, contextParameters);
                if (convertors != null) {
                    for (ClientSideElement convertor : convertors) {
                        List<ClientSideElement.Script> scriptsToAdd = convertor.getScripts(contextParameters);
                        if (scriptsToAdd == null) continue;
                        scripts.addAll(scriptsToAdd);
                    }
                }
                if ((validators = richTextConfiguration.getValidators(category, contextParameters)) == null) continue;
                for (ClientSideElement validator : validators) {
                    List<ClientSideElement.Script> scriptsToAdd = validator.getScripts(contextParameters);
                    if (scriptsToAdd == null) continue;
                    scripts.addAll(scriptsToAdd);
                }
            }
        }
        return scripts;
    }

    @Override
    public Map<String, String> getRights(Map<String, Object> contextParameters) {
        return Collections.EMPTY_MAP;
    }

    @Override
    public String getPluginName() {
        return this._pluginName;
    }

    @Override
    public Map<String, List<String>> getDependencies() {
        return Collections.EMPTY_MAP;
    }
}

