/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui.widgets.richtext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.widgets.richtext.RichTextConfiguration;
import org.ametys.core.ui.widgets.richtext.RichTextConfigurationAttribute;
import org.ametys.core.ui.widgets.richtext.RichTextConfigurationStyle;
import org.ametys.core.ui.widgets.richtext.RichTextConfigurationStyleGroup;
import org.ametys.core.ui.widgets.richtext.RichTextConfigurationTag;
import org.ametys.core.util.StringUtils;
import org.ametys.plugins.core.ui.util.ConfigurationHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.slf4j.Logger;

public class StaticRichTextConfiguration
extends AbstractLogEnabled
implements RichTextConfiguration,
Configurable,
PluginAware {
    protected String _pluginName;
    protected String _featureName;
    protected String _id;
    protected Map<String, Map<String, RichTextConfigurationTag>> _handledTags;
    protected Map<String, List<ClientSideElement.ScriptFile>> _cssFiles;
    protected Map<String, Set<ClientSideElement>> _validators;
    protected Map<String, Set<ClientSideElement>> _convertors;
    protected Map<String, Map<String, Map<RichTextConfigurationStyleGroup, List<RichTextConfigurationStyle>>>> _styles;

    public void configure(Configuration configuration) throws ConfigurationException {
        String category;
        this._handledTags = new HashMap<String, Map<String, RichTextConfigurationTag>>();
        for (Configuration tagsConfiguration : configuration.getChildren("tags")) {
            category = tagsConfiguration.getAttribute("category", "");
            if (this._handledTags.containsKey(category)) {
                throw new ConfigurationException("The tag category " + (String)(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)category) ? "'" + category + "'" : "<default>") + " has been defined twice", tagsConfiguration);
            }
            this._handledTags.put(category, this._configureTags(tagsConfiguration));
        }
        this._cssFiles = new HashMap<String, List<ClientSideElement.ScriptFile>>();
        for (Configuration cssConfiguration : configuration.getChildren("css")) {
            category = cssConfiguration.getAttribute("category", "");
            if (this._cssFiles.containsKey(category)) {
                throw new ConfigurationException("The css category " + (String)(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)category) ? "'" + category + "'" : "<default>") + " has been defined twice", cssConfiguration);
            }
            this._cssFiles.put(category, ConfigurationHelper.parsePluginResourceList(cssConfiguration, this._pluginName, this.getLogger()));
        }
        this._validators = new HashMap<String, Set<ClientSideElement>>();
        for (Configuration validatorsConfiguration : configuration.getChildren("validators")) {
            category = validatorsConfiguration.getAttribute("category", "");
            if (this._validators.containsKey(category)) {
                throw new ConfigurationException("The validators category " + (String)(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)category) ? "'" + category + "'" : "<default>") + " has been defined twice", validatorsConfiguration);
            }
            this._validators.put(category, this._configureValidators(validatorsConfiguration));
        }
        this._convertors = new HashMap<String, Set<ClientSideElement>>();
        for (Configuration convertorsConfiguration : configuration.getChildren("convertors")) {
            category = convertorsConfiguration.getAttribute("category", "");
            if (this._convertors.containsKey(category)) {
                throw new ConfigurationException("The convertors category " + (String)(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)category) ? "'" + category + "'" : "<default>") + " has been defined twice", convertorsConfiguration);
            }
            this._convertors.put(category, this._configureConvertors(convertorsConfiguration));
        }
        this._styles = this._configureCategoryAndStyles(configuration);
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
        this._featureName = featureName;
        this._id = id;
    }

    protected Map<String, RichTextConfigurationTag> _configureTags(Configuration tagsConfiguration) throws ConfigurationException {
        HashMap<String, RichTextConfigurationTag> tags = new HashMap<String, RichTextConfigurationTag>();
        for (Configuration tagConfiguration : tagsConfiguration.getChildren("tag")) {
            StaticRichTextConfigurationTag tag = new StaticRichTextConfigurationTag(tagConfiguration);
            if (tags.containsKey(tag.getTag())) {
                throw new ConfigurationException("The tag '" + tag.getTag() + "' cannot be defined twice in the same category", tagsConfiguration);
            }
            tags.put(tag.getTag(), tag);
        }
        return tags;
    }

    protected Set<ClientSideElement> _configureValidators(Configuration validatorsConfiguration) throws ConfigurationException {
        HashSet<ClientSideElement> validators = new HashSet<ClientSideElement>();
        for (Configuration validatorConfiguration : validatorsConfiguration.getChildren("validator")) {
            validators.add(new StaticRichTextConfigurationClientSideElement(validatorConfiguration, this._pluginName, this.getLogger()));
        }
        return validators;
    }

    protected Set<ClientSideElement> _configureConvertors(Configuration convertorsConfiguration) throws ConfigurationException {
        HashSet<ClientSideElement> convertors = new HashSet<ClientSideElement>();
        for (Configuration convertorConfiguration : convertorsConfiguration.getChildren("convertor")) {
            convertors.add(new StaticRichTextConfigurationClientSideElement(convertorConfiguration, this._pluginName, this.getLogger()));
        }
        return convertors;
    }

    private Map<String, Map<String, Map<RichTextConfigurationStyleGroup, List<RichTextConfigurationStyle>>>> _configureCategoryAndStyles(Configuration configuration) throws ConfigurationException {
        HashMap<String, Map<String, Map<RichTextConfigurationStyleGroup, List<RichTextConfigurationStyle>>>> allStyles = new HashMap<String, Map<String, Map<RichTextConfigurationStyleGroup, List<RichTextConfigurationStyle>>>>();
        for (Configuration stylesConfiguration : configuration.getChildren("styles")) {
            String category = stylesConfiguration.getAttribute("category", "");
            if (allStyles.containsKey(category)) {
                throw new ConfigurationException("The style category " + (String)(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)category) ? "'" + category + "'" : "<default>") + " has been defined twice", stylesConfiguration);
            }
            allStyles.put(category, this._configureStyles(stylesConfiguration));
        }
        return allStyles;
    }

    protected Map<String, Map<RichTextConfigurationStyleGroup, List<RichTextConfigurationStyle>>> _configureStyles(Configuration stylesConfiguration) throws ConfigurationException {
        HashMap<String, Map<RichTextConfigurationStyleGroup, List<RichTextConfigurationStyle>>> oneStyles = new HashMap<String, Map<RichTextConfigurationStyleGroup, List<RichTextConfigurationStyle>>>();
        for (Configuration styleConfiguration : stylesConfiguration.getChildren("style")) {
            String key = styleConfiguration.getAttribute("name");
            HashMap groups = new HashMap();
            oneStyles.put(key, groups);
            for (Configuration groupConfiguration : styleConfiguration.getChildren("group")) {
                StaticRichTextConfigurationStyleGroup group = new StaticRichTextConfigurationStyleGroup(groupConfiguration, this._pluginName);
                ArrayList<StaticRichTextConfigurationStyle> values = new ArrayList<StaticRichTextConfigurationStyle>();
                groups.put(group, values);
                for (Configuration valueConfiguration : groupConfiguration.getChild("values").getChildren("value")) {
                    values.add(new StaticRichTextConfigurationStyle(valueConfiguration, !"paragraph".equals(key), this._pluginName, this.getLogger()));
                }
            }
        }
        return oneStyles;
    }

    @Override
    public Set<String> getCategories() {
        HashSet<String> categories = new HashSet<String>();
        categories.addAll(this._handledTags.keySet());
        categories.addAll(this._cssFiles.keySet());
        categories.addAll(this._validators.keySet());
        categories.addAll(this._convertors.keySet());
        categories.addAll(this._styles.keySet());
        return categories;
    }

    @Override
    public Collection<RichTextConfigurationTag> getHandledTags(String category, Map<String, Object> contextParameters) {
        return this._handledTags.containsKey(category) ? this._handledTags.get(category).values() : List.of();
    }

    @Override
    public List<ClientSideElement.ScriptFile> getCSSFiles(String category, Map<String, Object> contextParameters) {
        return this._cssFiles.containsKey(category) ? this._cssFiles.get(category) : List.of();
    }

    @Override
    public Set<ClientSideElement> getValidators(String category, Map<String, Object> contextParameters) {
        return this._validators.containsKey(category) ? this._validators.get(category) : Set.of();
    }

    @Override
    public Set<ClientSideElement> getConvertors(String category, Map<String, Object> contextParameters) {
        return this._convertors.containsKey(category) ? this._convertors.get(category) : Set.of();
    }

    @Override
    public Map<String, Map<RichTextConfigurationStyleGroup, List<RichTextConfigurationStyle>>> getAvailableStyles(String category, Map<String, Object> contextualParameters) {
        return this._styles.containsKey(category) ? this._styles.get(category) : Map.of();
    }

    public static class StaticRichTextConfigurationTag
    implements RichTextConfigurationTag {
        protected String _tagName;
        protected String _typeName;
        protected RichTextConfigurationTag.EMPTY_TAG _emptyTag;
        protected Set<String> _synonyms;
        protected Set<RichTextConfigurationAttribute> _attributes;
        protected List<String> _removedInlineEditor;

        public StaticRichTextConfigurationTag(String tagName, RichTextConfigurationTag.EMPTY_TAG emptyTag, Set<String> synonyms, Set<RichTextConfigurationAttribute> attributes, String typeName, List<String> removedInlineEditor) {
            this._tagName = tagName;
            this._typeName = typeName;
            this._emptyTag = emptyTag != null ? emptyTag : RichTextConfigurationTag.EMPTY_TAG.CLOSE;
            this._synonyms = synonyms != null ? synonyms : Collections.EMPTY_SET;
            this._attributes = attributes != null ? attributes : Collections.EMPTY_SET;
            this._removedInlineEditor = removedInlineEditor != null ? removedInlineEditor : List.of();
        }

        protected StaticRichTextConfigurationTag(Configuration configuration) throws ConfigurationException {
            this._tagName = configuration.getAttribute("name");
            try {
                this._emptyTag = RichTextConfigurationTag.EMPTY_TAG.valueOf(configuration.getAttribute("empty", "CLOSE"));
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("The attribute empty does not accept the value '" + configuration.getAttribute("empty", "CLOSE") + "'. Should be one of <" + org.apache.commons.lang3.StringUtils.join((Object[])RichTextConfigurationTag.EMPTY_TAG.values(), (String)"|") + ">", configuration, (Throwable)e);
            }
            this._synonyms = new HashSet<String>();
            for (Configuration synonymConfiguration : configuration.getChild("synonyms").getChildren("synonym")) {
                this._synonyms.add(synonymConfiguration.getValue());
            }
            this._attributes = new HashSet<RichTextConfigurationAttribute>();
            for (Configuration attributeConfiguration : configuration.getChild("attributes").getChildren("attribute")) {
                StaticRichTextConfigurationAttribute attribute = new StaticRichTextConfigurationAttribute(attributeConfiguration);
                this._attributes.add(attribute);
            }
            this._removedInlineEditor = List.of();
        }

        @Override
        public String getTag() {
            return this._tagName;
        }

        @Override
        public String getType() {
            return this._typeName;
        }

        @Override
        public RichTextConfigurationTag.EMPTY_TAG onEmptyTag() {
            return this._emptyTag;
        }

        @Override
        public Set<String> getSynonyms() {
            return this._synonyms;
        }

        @Override
        public Set<RichTextConfigurationAttribute> getAttributes() {
            return this._attributes;
        }

        @Override
        public List<String> getRemovedInlineValues() {
            return this._removedInlineEditor;
        }
    }

    protected static class StaticRichTextConfigurationClientSideElement
    implements ClientSideElement {
        protected String _id = StringUtils.generateKey();
        protected String _pluginName;
        protected ClientSideElement.Script _script;

        protected StaticRichTextConfigurationClientSideElement(Configuration configuration, String pluginName, Logger logger) throws ConfigurationException {
            this._pluginName = pluginName;
            Configuration classConfiguration = configuration.getChild("class");
            List<ClientSideElement.ScriptFile> scriptsImports = ConfigurationHelper.parsePluginResourceList(configuration.getChild("scripts"), this.getPluginName(), logger);
            List<ClientSideElement.ScriptFile> cssImports = ConfigurationHelper.parsePluginResourceList(configuration.getChild("css"), this.getPluginName(), logger);
            Map<String, Object> parameters = ConfigurationHelper.parsePluginParameters(configuration.getChild("class"), this.getPluginName(), logger);
            this._script = new ClientSideElement.Script(this._id, classConfiguration.getAttribute("name"), scriptsImports, cssImports, parameters);
        }

        @Override
        public String getId() {
            return this._id;
        }

        @Override
        public List<ClientSideElement.Script> getScripts(Map<String, Object> contextParameters) {
            return this.getScripts(false, contextParameters);
        }

        @Override
        public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
            return Collections.singletonList(this._script);
        }

        @Override
        public Map<String, String> getRights(Map<String, Object> contextParameters) {
            return Collections.EMPTY_MAP;
        }

        @Override
        public String getPluginName() {
            return this._pluginName;
        }

        @Override
        public Map<String, List<String>> getDependencies() {
            return Collections.EMPTY_MAP;
        }
    }

    public static class StaticRichTextConfigurationStyleGroup
    implements RichTextConfigurationStyleGroup {
        protected I18nizableText _label;
        protected int _priority;

        protected StaticRichTextConfigurationStyleGroup(Configuration configuration, String pluginName) throws ConfigurationException {
            Configuration labelConfiguration = configuration.getChild("label");
            this._label = I18nizableText.getI18nizableTextValue(labelConfiguration, "plugin." + pluginName, labelConfiguration.getValue());
            this._priority = configuration.getChild("priority").getValueAsInteger(0);
        }

        public StaticRichTextConfigurationStyleGroup(I18nizableText label, int priority) {
            this._label = label;
            this._priority = priority;
        }

        @Override
        public I18nizableText getLabel() {
            return this._label;
        }

        @Override
        public int getPriority() {
            return this._priority;
        }
    }

    public static class StaticRichTextConfigurationStyle
    implements RichTextConfigurationStyle {
        protected String _tagName;
        protected String _className;
        protected I18nizableText _label;
        protected I18nizableText _description;
        protected String _buttonCSSClass;
        protected String _buttonSmallIcon;
        protected String _buttonMediumIcon;
        protected String _buttonLargeIcon;

        protected StaticRichTextConfigurationStyle(Configuration configuration, boolean isRenderingOnlyAClass, String pluginName, Logger logger) throws ConfigurationException {
            if (isRenderingOnlyAClass) {
                this._className = configuration.getAttribute("rendering");
            } else {
                this._tagName = configuration.getAttribute("rendering");
                int dotPosition = this._tagName.indexOf(46);
                if (this._tagName.contains(".")) {
                    this._className = this._tagName.substring(dotPosition + 1);
                    this._tagName = this._tagName.substring(0, dotPosition);
                }
            }
            Map<String, Object> parsePluginParameters = ConfigurationHelper.parsePluginParameters(configuration, pluginName, logger);
            this._label = (I18nizableText)parsePluginParameters.get("label");
            this._description = (I18nizableText)parsePluginParameters.get("description");
            this._buttonCSSClass = (String)parsePluginParameters.get("cssclass");
            this._buttonSmallIcon = (String)parsePluginParameters.get("icon-small");
            this._buttonMediumIcon = (String)parsePluginParameters.get("icon-medium");
            this._buttonLargeIcon = (String)parsePluginParameters.get("icon-large");
        }

        public StaticRichTextConfigurationStyle(String tagNameAndClassName, I18nizableText label, I18nizableText description, String buttonCSSClass, String buttonSmallIcon, String buttonMediumIcon, String buttonLargeIcon, boolean isRenderingOnlyAClass) {
            if (isRenderingOnlyAClass) {
                this._className = tagNameAndClassName;
            } else {
                this._tagName = tagNameAndClassName;
                int dotPosition = this._tagName.indexOf(46);
                if (this._tagName.contains(".")) {
                    this._className = this._tagName.substring(dotPosition + 1);
                    this._tagName = this._tagName.substring(0, dotPosition);
                }
            }
            this._label = label;
            this._description = description;
            this._buttonCSSClass = buttonCSSClass;
            this._buttonSmallIcon = buttonSmallIcon;
            this._buttonMediumIcon = buttonMediumIcon;
            this._buttonLargeIcon = buttonLargeIcon;
        }

        @Override
        public String getTagName() {
            return this._tagName;
        }

        @Override
        public String getClassName() {
            return this._className;
        }

        @Override
        public I18nizableText getButtonLabel() {
            return this._label;
        }

        @Override
        public I18nizableText getButtonDescription() {
            return this._description;
        }

        @Override
        public String getButtonCSSClass() {
            return this._buttonCSSClass;
        }

        @Override
        public String getButtonSmallIcon() {
            return this._buttonSmallIcon;
        }

        @Override
        public String getButtonMediumIcon() {
            return this._buttonMediumIcon;
        }

        @Override
        public String getButtonLargeIcon() {
            return this._buttonLargeIcon;
        }
    }

    public static class StaticRichTextConfigurationAttribute
    implements RichTextConfigurationAttribute {
        protected String _name;
        protected String _defaultValue;
        protected Set<String> _authorizedValues;
        protected Set<String> _technicalValues;

        public StaticRichTextConfigurationAttribute(String name, String defaultValue, Set<String> authorizedValues, Set<String> technicalValues) {
            this._name = name;
            this._defaultValue = defaultValue;
            this._authorizedValues = authorizedValues != null ? authorizedValues : Collections.EMPTY_SET;
            this._technicalValues = technicalValues != null ? technicalValues : Collections.EMPTY_SET;
        }

        protected StaticRichTextConfigurationAttribute(Configuration configuration) throws ConfigurationException {
            this._name = configuration.getAttribute("name");
            this._defaultValue = configuration.getChild("default-value").getValue(null);
            this._authorizedValues = new HashSet<String>();
            this._technicalValues = new HashSet<String>();
            if (this._defaultValue != null) {
                this._authorizedValues.add(this._defaultValue);
            }
            for (Configuration valueConfiguration : configuration.getChild("values").getChildren("value")) {
                if ("true".equals(valueConfiguration.getAttribute("technical", "false"))) {
                    this._technicalValues.add(valueConfiguration.getValue());
                }
                this._authorizedValues.add(valueConfiguration.getValue());
            }
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public String getDefaultValue() {
            return this._defaultValue;
        }

        @Override
        public Set<String> getAuthorizedValues() {
            return this._authorizedValues;
        }

        @Override
        public Set<String> getTechnicalValues() {
            return this._technicalValues;
        }
    }
}

