/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.user;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.core.user.UserFactory;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserImageAccessor;
import org.ametys.core.user.dataprovider.UserDataProvider;
import org.ametys.core.user.directory.StoredUser;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.util.SizeUtils;
import org.apache.commons.lang3.StringUtils;

public class User<T extends UserFactory>
implements Principal {
    public static final String LAST_NAME_DATA_ID = "lastname";
    public static final String FIRST_NAME_DATA_ID = "firstname";
    public static final String EMAIL_DATA_ID = "email";
    public static final String IMAGE_DATA_ID = "image";
    public static final String LANGUAGE_DATA_ID = "language";
    public static final String TIMEZONE_DATA_ID = "timezone";
    public static final String CREATION_DATE_DATA_ID = "creation-date";
    public static final String CREATION_ORIGIN_DATA_ID = "creation-origin";
    protected UserIdentity _identity;
    @SizeUtils.ExcludeFromSizeCalculation
    protected UserDirectory _userDirectory;
    @SizeUtils.ExcludeFromSizeCalculation
    protected T _factory;
    private StoredUser _storedUser;

    User(StoredUser storedUser, UserDirectory userDirectory, T factory) {
        this._identity = new UserIdentity(storedUser.getIdentifier(), userDirectory.getPopulationId());
        this._storedUser = storedUser;
        this._userDirectory = userDirectory;
        this._factory = factory;
    }

    public UserIdentity getIdentity() {
        return this._identity;
    }

    public StoredUser getStoredUser() {
        return this._storedUser;
    }

    @Override
    public String getName() {
        return UserIdentity.userIdentityToString(this._identity);
    }

    public UserDirectory getUserDirectory() {
        return this._userDirectory;
    }

    public String getLastName() {
        return (String)this.getValue(LAST_NAME_DATA_ID);
    }

    public String getFirstName() {
        return (String)this.getValue(FIRST_NAME_DATA_ID);
    }

    public String getEmail() {
        return (String)this.getValue(EMAIL_DATA_ID);
    }

    public String getFullName() {
        return this._getFullName(true);
    }

    public String getSortableName() {
        return this._getFullName(false);
    }

    public UserImage getImage(int size, int maxSize) {
        UserImageAccessor imageAccessor = (UserImageAccessor)this.getValue(IMAGE_DATA_ID);
        return imageAccessor != null ? imageAccessor.getImage(size, maxSize) : null;
    }

    public String getLanguage() {
        return (String)this.getValue(LANGUAGE_DATA_ID);
    }

    public TimeZone getTimeZone() {
        Object timezoneFound = this.getValue(TIMEZONE_DATA_ID);
        if (timezoneFound instanceof TimeZone) {
            TimeZone timeZone = (TimeZone)timezoneFound;
            return timeZone;
        }
        if (timezoneFound instanceof String) {
            String timeZoneId = (String)timezoneFound;
            if (List.of(TimeZone.getAvailableIDs()).contains(timeZoneId)) {
                return TimeZone.getTimeZone(timeZoneId);
            }
        }
        return null;
    }

    public ZonedDateTime getLastConnectionDate() {
        return ((UserFactory)this._factory).getUserStatusManager().getLastConnectionDate(this.getIdentity()).orElse(null);
    }

    public ZonedDateTime getCreationDate() {
        return (ZonedDateTime)this.getValue(CREATION_DATE_DATA_ID);
    }

    public UserCreationOrigin getCreationOrigin() {
        return (UserCreationOrigin)((Object)this.getValue(CREATION_ORIGIN_DATA_ID));
    }

    public Object getValue(String dataId) {
        return ((UserFactory)this._factory).getUserDataProviderEP().getValue(this, dataId);
    }

    public UserDataProvider getProviderFor(String dataId) {
        return ((UserFactory)this._factory).getUserDataProviderEP().getProviderFor(this, dataId);
    }

    protected String _getFullName(boolean firstnameThenLastname) {
        Stream<String> stream = firstnameThenLastname ? Stream.of(this.getFirstName(), this.getLastName()) : Stream.of(this.getLastName(), this.getFirstName());
        String sortableName = stream.filter(StringUtils::isNotEmpty).collect(Collectors.joining(" "));
        return (String)StringUtils.defaultIfEmpty((CharSequence)sortableName, (CharSequence)this._identity.getLogin());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Principal[");
        sb.append(this._userDirectory.getPopulationId());
        sb.append(", ");
        sb.append(this._storedUser.toString());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean equals(Object another) {
        if (another == null || !(another instanceof User)) {
            return false;
        }
        User otherUser = (User)another;
        return this._identity != null && this._identity.equals(otherUser.getIdentity());
    }

    @Override
    public int hashCode() {
        return this._identity.hashCode();
    }

    public static class UserImage
    implements Closeable {
        private final InputStream _inputstream;
        private final String _filename;
        private final Long _length;
        private final Long _lastModified;
        private final String _type;

        public UserImage(InputStream inputstream, String filename, Long length, Long lastModified, String type) {
            this._inputstream = inputstream;
            this._filename = filename;
            this._length = length;
            this._lastModified = lastModified;
            this._type = type;
        }

        public String getType() {
            return this._type;
        }

        public InputStream getInputstream() {
            return this._inputstream;
        }

        public String getFilename() {
            return this._filename;
        }

        public Long getLength() {
            return this._length;
        }

        public Long getLastModified() {
            return this._lastModified;
        }

        @Override
        public void close() throws IOException {
            this._inputstream.close();
        }
    }

    public static enum UserCreationOrigin {
        SYSTEM,
        ADMIN,
        USER_SIGNUP,
        NOT_AVAILABLE;

    }
}

