/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.user;

import org.apache.commons.lang3.StringUtils;

public class UserIdentity {
    private static final String __SEPARATOR = "#";
    private String _login;
    private String _populationId;

    public UserIdentity(String login, String populationId) {
        this._login = login;
        this._populationId = populationId;
    }

    public static String userIdentityToString(UserIdentity userIdentity) {
        if (userIdentity != null) {
            return userIdentity.getLogin() + __SEPARATOR + userIdentity.getPopulationId();
        }
        return null;
    }

    public static UserIdentity stringToUserIdentity(String string) {
        if (string != null && string.contains(__SEPARATOR)) {
            String login = StringUtils.substringBeforeLast((String)string, (String)__SEPARATOR);
            String populationId = StringUtils.substringAfterLast((String)string, (String)__SEPARATOR);
            return new UserIdentity(login, populationId);
        }
        return null;
    }

    public String getLogin() {
        return this._login;
    }

    public String getPopulationId() {
        return this._populationId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._login == null ? 0 : this._login.hashCode());
        result = 31 * result + (this._populationId == null ? 0 : this._populationId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserIdentity)) {
            return false;
        }
        UserIdentity other = (UserIdentity)obj;
        if (this._login == null ? other._login != null : !this._login.equals(other._login)) {
            return false;
        }
        return !(this._populationId == null ? other._populationId != null : !this._populationId.equals(other._populationId));
    }

    public String toString() {
        return "UserIdentity [login=" + this._login + ", population=" + this._populationId + "]";
    }
}

