/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.cache.CacheException;
import org.ametys.core.user.User;
import org.ametys.core.user.UserFactory;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.directory.NotUniqueUserException;
import org.ametys.core.user.directory.StoredUser;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.user.population.PopulationContextHelper;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.tuple.Pair;

public class UserManager
extends AbstractLogEnabled
implements Component,
Serviceable,
Initializable {
    public static final String ROLE = UserManager.class.getName();
    private static final String __USER_CACHE_ID = UserHelper.class.getName() + "$userCache";
    private static final String __USER_CACHE_BY_EMAIL_ID = UserHelper.class.getName() + "$userByEmailCache";
    protected UserPopulationDAO _userPopulationDAO;
    protected PopulationContextHelper _populationContextHelper;
    private AbstractCacheManager _abstractCacheManager;
    private UserFactory _userFactory;

    public void service(ServiceManager manager) throws ServiceException {
        this._userPopulationDAO = (UserPopulationDAO)manager.lookup(UserPopulationDAO.ROLE);
        this._populationContextHelper = (PopulationContextHelper)manager.lookup(PopulationContextHelper.ROLE);
        this._abstractCacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
        this._userFactory = (UserFactory)manager.lookup(UserFactory.ROLE);
    }

    public void initialize() throws Exception {
        this._abstractCacheManager.createRequestCache(__USER_CACHE_ID, new I18nizableText("plugin.core", "PLUGINS_CORE_CACHE_USER_BY_USER_IDENTITY_LABEL"), new I18nizableText("plugin.core", "PLUGINS_CORE_CACHE_USER_BY_USER_IDENTITY_DESCRIPTION"), true);
        this._abstractCacheManager.createRequestCache(__USER_CACHE_BY_EMAIL_ID, new I18nizableText("plugin.core", "PLUGINS_CORE_CACHE_USER_BY_EMAIL_LABEL"), new I18nizableText("plugin.core", "PLUGINS_CORE_CACHE_USER_BY_EMAIL_DESCRIPTION"), true);
    }

    public Collection<User> getUsersByContext(Set<String> contexts, boolean checkRight) {
        List<UserPopulation> userPopulations = this._populationContextHelper.getUserPopulationsOnContexts(contexts, false, checkRight).stream().map(upId -> this._userPopulationDAO.getUserPopulation((String)upId)).collect(Collectors.toList());
        return this.getUsersByPopulations(userPopulations);
    }

    public Collection<User> getUsersByPopulationIds(List<String> userPopulationIds) {
        ArrayList<User> users = new ArrayList<User>();
        for (String id : userPopulationIds) {
            UserPopulation userPopulation = this._userPopulationDAO.getUserPopulation(id);
            if (userPopulation == null) continue;
            for (User user : this.getUsers(userPopulation)) {
                if (users.contains(user)) continue;
                users.add(user);
            }
        }
        return users;
    }

    public Collection<User> getUsersByPopulations(List<UserPopulation> userPopulations) {
        ArrayList<User> users = new ArrayList<User>();
        for (UserPopulation userPopulation : userPopulations) {
            for (User user : this.getUsers(userPopulation)) {
                if (users.contains(user)) continue;
                users.add(user);
            }
        }
        return users;
    }

    public Collection<User> getUsers(String userPopulationId) {
        UserPopulation userPopulation = this._userPopulationDAO.getUserPopulation(userPopulationId);
        if (userPopulation != null) {
            return this.getUsers(userPopulation);
        }
        return Collections.EMPTY_LIST;
    }

    public Collection<User> getUsers(UserPopulation userPopulation) {
        ArrayList<User> users = new ArrayList<User>();
        for (UserDirectory ud : userPopulation.getUserDirectories()) {
            Collection<User> usersOfUd = this._storedUsers2Users(ud.getStoredUsers(), ud);
            for (User user : usersOfUd) {
                if (users.contains(user)) continue;
                users.add(user);
            }
        }
        return users;
    }

    public List<User> getUsersByContext(Set<String> contexts, int count, int offset, Map<String, Object> parameters, boolean checkRight, boolean sort) {
        List<UserPopulation> userPopulations = this._populationContextHelper.getUserPopulationsOnContexts(contexts, false, checkRight).stream().map(upId -> this._userPopulationDAO.getUserPopulation((String)upId)).collect(Collectors.toList());
        return this.getUsers(userPopulations, count, offset, parameters, sort);
    }

    public List<User> getUsers(List<UserPopulation> userPopulations, int count, int offset, Map<String, Object> parameters, boolean sort) {
        ArrayList<User> users = new ArrayList<User>();
        for (UserPopulation userPopulation : userPopulations) {
            for (User user : this.getUsers(userPopulation, count + offset, 0, parameters, sort)) {
                if (users.contains(user)) continue;
                users.add(user);
            }
        }
        int boundedCount = count >= 0 ? count : Integer.MAX_VALUE;
        int boundedOffset = offset >= 0 ? offset : 0;
        int toIndex = boundedOffset + boundedCount >= 0 ? Math.min(boundedOffset + boundedCount, users.size()) : users.size();
        return users.subList(boundedOffset, toIndex);
    }

    public Collection<User> getUsers(String userPopulationId, int count, int offset, Map<String, Object> parameters, boolean sort) {
        UserPopulation userPopulation = this._userPopulationDAO.getUserPopulation(userPopulationId);
        if (userPopulation != null) {
            return this.getUsers(userPopulation, count, offset, parameters, sort);
        }
        return Collections.EMPTY_LIST;
    }

    public Collection<User> getUsersByDirectory(String userPopulationId, String userDirectoryId, int count, int offset, Map<String, Object> parameters) {
        UserPopulation userPopulation = this._userPopulationDAO.getUserPopulation(userPopulationId);
        if (userPopulation == null) {
            return Collections.EMPTY_LIST;
        }
        UserDirectory ud = userPopulation.getUserDirectory(userDirectoryId);
        if (ud == null) {
            throw new IllegalArgumentException("In the population '" + userPopulationId + "' the directory '" + userDirectoryId + "' was referenced but does not exists");
        }
        return this._storedUsers2Users(ud.getStoredUsers(count, offset, parameters), ud);
    }

    public Collection<User> getUsers(UserPopulation userPopulation, int count, int offset, Map<String, Object> parameters, boolean sort) {
        HashSet<User> users = new HashSet<User>();
        for (UserDirectory ud : userPopulation.getUserDirectories()) {
            users.addAll(this._storedUsers2Users(ud.getStoredUsers(count + offset, 0, parameters), ud));
        }
        int boundedCount = count >= 0 ? count : Integer.MAX_VALUE;
        int boundedOffset = offset >= 0 ? offset : 0;
        int toIndex = boundedOffset + boundedCount >= 0 ? Math.min(boundedOffset + boundedCount, users.size()) : users.size();
        ArrayList<User> usersList = new ArrayList<User>(users);
        if (sort) {
            usersList.sort(Comparator.comparing(UserManager::_getSortableNameLowerCase));
        }
        return usersList.subList(boundedOffset, toIndex);
    }

    private static String _getSortableNameLowerCase(User user) {
        return user.getSortableName().toLowerCase();
    }

    public Collection<User> getUsersByDirectory(UserPopulation userPopulation, String userDirectoryId, int count, int offset, Map<String, Object> parameters) {
        UserDirectory ud = userPopulation.getUserDirectory(userDirectoryId);
        return this._storedUsers2Users(ud.getStoredUsers(count, offset, parameters), ud);
    }

    public User getUserByContext(Set<String> contexts, String login, boolean checkRight) {
        Set<String> upIds = this._populationContextHelper.getUserPopulationsOnContexts(contexts, false, checkRight);
        for (String upId : upIds) {
            UserPopulation userPopulation = this._userPopulationDAO.getUserPopulation(upId);
            User user = this.getUser(userPopulation, login);
            if (user == null) continue;
            return user;
        }
        return null;
    }

    public User getUser(UserIdentity userIdentity) {
        if (userIdentity == null) {
            return null;
        }
        Cache<UserIdentity, User> cache = this._getUserCache();
        return cache.get(userIdentity, key -> {
            UserPopulation userPopulation = this._userPopulationDAO.getUserPopulation(key.getPopulationId());
            if (userPopulation != null) {
                return this.getUser(userPopulation, key.getLogin());
            }
            return null;
        });
    }

    public User getUser(String userPopulationId, String login) {
        UserIdentity userIdentity = new UserIdentity(login, userPopulationId);
        return this.getUser(userIdentity);
    }

    private Cache<UserIdentity, User> _getUserCache() {
        return this._abstractCacheManager.get(__USER_CACHE_ID);
    }

    public User getUserByEmail(Set<String> userPopulationIds, String email) throws NotUniqueUserException {
        if (email == null) {
            return null;
        }
        User user = null;
        for (String populationId : userPopulationIds) {
            User u = this.getUserByEmail(populationId, email);
            if (u == null) continue;
            if (user == null) {
                user = u;
                continue;
            }
            throw new NotUniqueUserException("Cannot find user in populations '" + String.valueOf(userPopulationIds) + "' by email '" + email + "' because 2 or more users match (at least " + UserIdentity.userIdentityToString(u.getIdentity()) + " and " + UserIdentity.userIdentityToString(user.getIdentity()) + ")");
        }
        return user;
    }

    public User getUserByEmail(String userPopulationId, String email) throws NotUniqueUserException {
        if (email == null) {
            return null;
        }
        Cache<Pair<String, String>, User> cache = this._getUserByEmailCache();
        try {
            return cache.get((Pair<String, String>)Pair.of((Object)userPopulationId, (Object)email), LambdaUtils.wrap(key -> {
                UserPopulation userPopulation = this._userPopulationDAO.getUserPopulation(userPopulationId);
                if (userPopulation != null) {
                    return this.getUserByEmail(userPopulation, email);
                }
                return null;
            }));
        }
        catch (CacheException e) {
            if (e.getCause() instanceof LambdaUtils.LambdaException) {
                if (e.getCause().getCause() instanceof NotUniqueUserException) {
                    throw (NotUniqueUserException)e.getCause().getCause();
                }
                throw new RuntimeException(e.getCause().getCause());
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private Cache<Pair<String, String>, User> _getUserByEmailCache() {
        return this._abstractCacheManager.get(__USER_CACHE_BY_EMAIL_ID);
    }

    public User getUserByDirectory(String userPopulationId, String userDirectoryId, String login) {
        UserPopulation userPopulation = this._userPopulationDAO.getUserPopulation(userPopulationId);
        if (userPopulation != null) {
            return this.getUserByDirectory(userPopulation, userDirectoryId, login);
        }
        return null;
    }

    public User getUser(UserPopulation userPopulation, String login) {
        for (UserDirectory ud : userPopulation.getUserDirectories()) {
            StoredUser storedUser = ud.getStoredUser(login);
            if (storedUser == null) continue;
            return this._storedUser2User(storedUser, ud);
        }
        return null;
    }

    public User getUserByEmail(UserPopulation userPopulation, String email) throws NotUniqueUserException {
        for (UserDirectory ud : userPopulation.getUserDirectories()) {
            StoredUser storedUser = ud.getStoredUserByEmail(email);
            if (storedUser == null) continue;
            return this._storedUser2User(storedUser, ud);
        }
        return null;
    }

    public User getUserByUserDirectoryAndEmail(UserDirectory userDirectory, String email) throws NotUniqueUserException {
        StoredUser storedUser = userDirectory.getStoredUserByEmail(email);
        if (storedUser != null) {
            return this._storedUser2User(storedUser, userDirectory);
        }
        return null;
    }

    public User getUserByDirectory(UserPopulation userPopulation, String userDirectoryId, String login) {
        UserDirectory ud = userPopulation.getUserDirectory(userDirectoryId);
        StoredUser storedUser = ud.getStoredUser(login);
        if (storedUser != null) {
            return this._storedUser2User(storedUser, ud);
        }
        return null;
    }

    public User getUserByDirectory(UserDirectory userDirectory, String login) {
        StoredUser storedUser = userDirectory.getStoredUser(login);
        if (storedUser != null) {
            return this._storedUser2User(storedUser, userDirectory);
        }
        return null;
    }

    public UserDirectory getUserDirectory(String userPopulationId, String login) {
        UserPopulation userPopulation = this._userPopulationDAO.getUserPopulation(userPopulationId);
        if (userPopulation == null) {
            return null;
        }
        for (UserDirectory ud : userPopulation.getUserDirectories()) {
            StoredUser storedUser = ud.getStoredUser(login);
            if (storedUser == null) continue;
            return ud;
        }
        return null;
    }

    private User _storedUser2User(StoredUser storedUser, UserDirectory userDirectory) {
        return this._userFactory.createUser(storedUser, userDirectory);
    }

    private Collection<User> _storedUsers2Users(Collection<StoredUser> storedUsers, UserDirectory userDirectory) {
        ArrayList<User> users = new ArrayList<User>();
        for (StoredUser storedUser : storedUsers) {
            users.add(this._storedUser2User(storedUser, userDirectory));
        }
        return users;
    }
}

