/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.user.dataprovider;

import java.util.Set;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.dataprovider.UserDataProvider;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentPrioritizableSupporterExtensionPoint;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class UserDataProviderExtensionPoint
extends AbstractThreadSafeComponentPrioritizableSupporterExtensionPoint<UserDataProvider, String> {
    public static final String ROLE = UserDataProviderExtensionPoint.class.getName();
    private UserManager _userManager;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
    }

    public Object getValue(User user, String dataId) {
        if (user == null) {
            return null;
        }
        Set<String> sortedExtensionIds = this.getExtensionsIds();
        for (String extensionId : sortedExtensionIds) {
            Object value;
            UserDataProvider userDataProvider = (UserDataProvider)this.getExtension(extensionId);
            if (!userDataProvider.supports(dataId) || (value = userDataProvider.getValue(user, dataId)) == null) continue;
            return value;
        }
        return null;
    }

    public Object getValue(UserIdentity userIdentity, String dataId) {
        if (userIdentity != null) {
            this.getValue(this._userManager.getUser(userIdentity), dataId);
        }
        return null;
    }

    public UserDataProvider getProviderFor(User user, String dataId) {
        Set<String> sortedExtensionIds = this.getExtensionsIds();
        for (String extensionId : sortedExtensionIds) {
            UserDataProvider userDataProvider = (UserDataProvider)this.getExtension(extensionId);
            if (!userDataProvider.hasValue(user, dataId)) continue;
            return userDataProvider;
        }
        return null;
    }
}

