/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.user.directory;

import java.time.ZonedDateTime;
import org.ametys.core.user.User;
import org.apache.commons.lang3.StringUtils;

public class StoredUser {
    protected String _identifier;
    protected String _lastName;
    protected String _firstName;
    protected String _email;
    protected ZonedDateTime _creationDate;
    protected User.UserCreationOrigin _creationOrigin;

    public StoredUser(String identifier, String lastName) {
        this(identifier, lastName, null, null);
    }

    public StoredUser(String identifier, String lastName, String firstName, String email) {
        this(identifier, lastName, firstName, email, null, User.UserCreationOrigin.NOT_AVAILABLE);
    }

    public StoredUser(String identifier, String lastName, String firstName, String email, ZonedDateTime creationDate, User.UserCreationOrigin creationOrigin) {
        this._identifier = identifier;
        this._lastName = StringUtils.defaultString((String)lastName);
        this._firstName = StringUtils.defaultString((String)firstName);
        this._email = StringUtils.defaultString((String)email);
        this._creationDate = creationDate;
        this._creationOrigin = creationOrigin;
    }

    public String getIdentifier() {
        return this._identifier;
    }

    public String getLastName() {
        return this._lastName;
    }

    public String getFirstName() {
        return this._firstName;
    }

    public String getEmail() {
        return this._email;
    }

    public ZonedDateTime getCreationDate() {
        return this._creationDate;
    }

    public User.UserCreationOrigin getCreationOrigin() {
        return this._creationOrigin;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this._identifier);
        sb.append(", ");
        sb.append(this._lastName);
        sb.append(", ");
        sb.append(this._firstName);
        sb.append(", ");
        sb.append(this._email);
        sb.append(", ");
        sb.append(this._creationDate);
        sb.append(", ");
        sb.append((Object)this._creationOrigin);
        return sb.toString();
    }
}

