/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.user.directory;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.directory.NotUniqueUserException;
import org.ametys.core.user.directory.StoredUser;

public interface UserDirectory {
    public String getId();

    public String getLabel();

    public Collection<StoredUser> getStoredUsers();

    public List<StoredUser> getStoredUsers(int var1, int var2, Map<String, Object> var3);

    public StoredUser getStoredUser(String var1);

    public StoredUser getStoredUserByEmail(String var1) throws NotUniqueUserException;

    public String getUserDirectoryModelId();

    public Map<String, Object> getParameterValues();

    public void init(String var1, String var2, Map<String, Object> var3, String var4) throws Exception;

    public void setPopulationId(String var1);

    public String getPopulationId();

    default public UserIdentity getUserIdentity(String login) {
        StoredUser storedUser = this.getStoredUser(login);
        if (storedUser != null) {
            return this.getUserIdentity(storedUser);
        }
        return null;
    }

    default public UserIdentity getUserIdentity(StoredUser storedUser) {
        return new UserIdentity(storedUser.getIdentifier(), this.getPopulationId());
    }

    public CredentialsResult checkCredentials(String var1, String var2);

    default public boolean isCaseSensitive() {
        return true;
    }

    public static enum CredentialsResult {
        AUTHENTICATED,
        NOT_AUTHENTICATED,
        WEAK_PASSWORD;

    }
}

