/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.user.directory;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.ametys.core.model.type.ModelItemTypeExtensionPoint;
import org.ametys.core.user.directory.DefaultUserDirectoryModel;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.user.directory.UserDirectoryModel;
import org.ametys.core.util.UsersAndGroupsDataDisableConditions;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.AbstractElementDefinitionParser;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.checker.ItemChecker;
import org.ametys.runtime.model.checker.ItemCheckerDescriptor;
import org.ametys.runtime.model.checker.ItemCheckerParser;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.ametys.runtime.parameter.Validator;
import org.ametys.runtime.plugin.ExtensionPoint;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.LogEnabled;
import org.ametys.runtime.plugin.component.ThreadSafeComponentManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.LifecycleHelper;
import org.apache.cocoon.util.log.SLF4JLoggerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDirectoryFactory
extends AbstractLogEnabled
implements ExtensionPoint<UserDirectoryModel>,
Initializable,
ThreadSafe,
Component,
Serviceable,
Contextualizable,
Disposable {
    public static final String ROLE = UserDirectoryFactory.class.getName();
    protected ModelItemTypeExtensionPoint _userDirectoryParameterTypeExtensionPoint;
    private Map<String, UserDirectoryModel> _udModels;
    private ServiceManager _smanager;
    private Context _context;

    public void initialize() throws Exception {
        this._udModels = new HashMap<String, UserDirectoryModel>();
    }

    public void dispose() {
        this._udModels.clear();
    }

    public void service(ServiceManager smanager) throws ServiceException {
        this._smanager = smanager;
        this._userDirectoryParameterTypeExtensionPoint = (ModelItemTypeExtensionPoint)this._smanager.lookup(ModelItemTypeExtensionPoint.ROLE_USER_DIRECTORY);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public UserDirectory createUserDirectory(String id, String modelId, Map<String, Object> paramsValues, String populationId, String label) {
        if (this._udModels.containsKey(modelId)) {
            UserDirectoryModel userDirectoryModel = this._udModels.get(modelId);
            UserDirectory ud = null;
            Class<UserDirectory> udClass = userDirectoryModel.getUserDirectoryClass();
            try {
                ud = userDirectoryModel.getUserDirectoryClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException("Cannot instanciate the class " + udClass.getCanonicalName() + ". Check that there is a public constructor with no arguments.");
            }
            Logger logger = LoggerFactory.getLogger(udClass);
            try {
                if (ud instanceof LogEnabled) {
                    ((LogEnabled)((Object)ud)).setLogger(logger);
                }
                LifecycleHelper.setupComponent((Object)ud, (org.apache.avalon.framework.logger.Logger)new SLF4JLoggerAdapter(logger), (Context)this._context, (ServiceManager)this._smanager, (Configuration)userDirectoryModel.getUserDirectoryConfiguration());
            }
            catch (Exception e) {
                this.getLogger().warn("An exception occured during the setup of the component " + modelId, (Throwable)e);
            }
            ud.setPopulationId(populationId);
            try {
                ud.init(id, modelId, paramsValues, label);
            }
            catch (Exception e) {
                throw new IllegalStateException("An error occured during the initialization of the UserDirectory '" + modelId + "' of the UserPopulation '" + populationId + "'", e);
            }
            return ud;
        }
        return null;
    }

    @Override
    public void addExtension(String id, String pluginName, String featureName, Configuration configuration) throws ConfigurationException {
        block2: {
            this.getLogger().debug("Adding user directory model from plugin {}/{}", (Object)pluginName, (Object)featureName);
            try {
                this.addUserDirectoryModel(pluginName, configuration);
            }
            catch (ConfigurationException e) {
                if (!this.getLogger().isWarnEnabled()) break block2;
                this.getLogger().warn("The plugin '" + pluginName + "." + featureName + "' has a user directory model extension but has an incorrect configuration", (Throwable)e);
            }
        }
    }

    protected void addUserDirectoryModel(String pluginName, Configuration configuration) throws ConfigurationException {
        Configuration[] paramCheckersConfiguration;
        Configuration[] paramsConfiguration;
        String id = configuration.getAttribute("id");
        I18nizableText label = I18nizableText.parseI18nizableText(configuration.getChild("label"), "plugin." + pluginName);
        I18nizableText description = I18nizableText.parseI18nizableText(configuration.getChild("description"), "plugin." + pluginName);
        String className = null;
        Class<UserDirectory> udClass = null;
        Configuration classConfig = null;
        try {
            className = configuration.getChild("class").getAttribute("name");
            udClass = Class.forName(className);
            classConfig = configuration.getChild("class");
        }
        catch (ClassNotFoundException | ConfigurationException e) {
            throw new ConfigurationException("User directory model with id '" + id + "' has an invalid configuration for class name " + (String)(className != null ? className + " <class not found>" : "<missing tag <class>") + "'", e);
        }
        if (!UserDirectory.class.isAssignableFrom(udClass)) {
            throw new ConfigurationException("User directory model with id '" + id + "' has an invalid configuration: '" + className + "' is not an instance of UserDirectory");
        }
        LinkedHashMap<String, ElementDefinition> parameters = new LinkedHashMap<String, ElementDefinition>();
        ThreadSafeComponentManager<DisableConditions> disableConditionsManager = new ThreadSafeComponentManager<DisableConditions>();
        disableConditionsManager.setLogger(this.getLogger());
        disableConditionsManager.contextualize(this._context);
        disableConditionsManager.service(this._smanager);
        ThreadSafeComponentManager<Validator> validatorManager = new ThreadSafeComponentManager<Validator>();
        validatorManager.setLogger(this.getLogger());
        validatorManager.contextualize(this._context);
        validatorManager.service(this._smanager);
        ThreadSafeComponentManager<Enumerator> enumeratorManager = new ThreadSafeComponentManager<Enumerator>();
        enumeratorManager.setLogger(this.getLogger());
        enumeratorManager.contextualize(this._context);
        enumeratorManager.service(this._smanager);
        UserDirectoryModelParameterParser udParser = new UserDirectoryModelParameterParser(this, this._userDirectoryParameterTypeExtensionPoint, disableConditionsManager, enumeratorManager, validatorManager);
        for (Configuration paramConfiguration : paramsConfiguration = configuration.getChild("parameters").getChildren("param")) {
            this.configureParameters(udParser, paramConfiguration, pluginName, parameters);
        }
        LinkedHashMap<String, ItemCheckerDescriptor> parameterCheckers = new LinkedHashMap<String, ItemCheckerDescriptor>();
        ThreadSafeComponentManager<ItemChecker> parameterCheckerManager = new ThreadSafeComponentManager<ItemChecker>();
        parameterCheckerManager.setLogger(this.getLogger());
        parameterCheckerManager.contextualize(this._context);
        parameterCheckerManager.service(this._smanager);
        ItemCheckerParser parameterCheckerParser = new ItemCheckerParser(parameterCheckerManager);
        for (Configuration paramCheckerConfiguration : paramCheckersConfiguration = configuration.getChild("parameters").getChildren("param-checker")) {
            this.configureParamChecker(parameterCheckerParser, paramCheckerConfiguration, pluginName, parameterCheckers);
        }
        try {
            udParser.lookupComponents();
            parameterCheckerParser.lookupComponents();
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to lookup parameter local components", configuration, (Throwable)e);
        }
        DefaultUserDirectoryModel udModel = new DefaultUserDirectoryModel(id, udClass, classConfig, label, description, parameters, parameterCheckers, pluginName);
        if (this._udModels.containsKey(id)) {
            UserDirectoryModel oldUDModel = this._udModels.get(id);
            throw new IllegalArgumentException("User directory model with id '" + id + "' is already declared in plugin '" + oldUDModel.getPluginName() + "'. This second declaration is ignored.");
        }
        this._udModels.put(id, udModel);
    }

    protected void configureParameters(UserDirectoryModelParameterParser paramParser, Configuration configuration, String pluginName, Map<String, ElementDefinition> parameters) throws ConfigurationException {
        ElementDefinition parameter = (ElementDefinition)paramParser.parse(this._smanager, pluginName, configuration, null, null);
        String id = parameter.getName();
        if (parameters.containsKey(id)) {
            throw new ConfigurationException("The parameter '" + id + "' is already declared. IDs must be unique.", configuration);
        }
        parameters.put(id, parameter);
    }

    protected void configureParamChecker(ItemCheckerParser parser, Configuration configuration, String pluginName, Map<String, ItemCheckerDescriptor> parameterCheckers) throws ConfigurationException {
        ItemCheckerDescriptor parameterChecker = parser.parseParameterChecker(pluginName, configuration);
        String id = parameterChecker.getName();
        if (parameterCheckers.containsKey(id)) {
            throw new ConfigurationException("The parameter checker '" + id + "' is already declared. IDs must be unique.", configuration);
        }
        parameterCheckers.put(id, parameterChecker);
    }

    @Override
    public void initializeExtensions() throws Exception {
    }

    @Override
    public boolean hasExtension(String id) {
        return this._udModels.containsKey(id);
    }

    @Override
    public UserDirectoryModel getExtension(String id) {
        return this._udModels.get(id);
    }

    @Override
    public Set<String> getExtensionsIds() {
        return this._udModels.keySet();
    }

    public class UserDirectoryModelParameterParser
    extends AbstractElementDefinitionParser<UsersAndGroupsDataDisableConditions> {
        public UserDirectoryModelParameterParser(UserDirectoryFactory this$0, ModelItemTypeExtensionPoint userDirectoryParameterTypeExtensionPoint, ThreadSafeComponentManager<DisableConditions> disableConditionsManager, ThreadSafeComponentManager<Enumerator> enumeratorManager, ThreadSafeComponentManager<Validator> validatorManager) {
            super(userDirectoryParameterTypeExtensionPoint, disableConditionsManager, enumeratorManager, validatorManager);
        }

        @Override
        protected String _getNameConfigurationAttribute() {
            return "id";
        }
    }
}

